/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.BuildToolFailure;
import org.openrewrite.marker.Markup;
import org.openrewrite.table.BuildToolFailures;

public final class FindBuildToolFailures
extends Recipe {
    private final BuildToolFailures failures = new BuildToolFailures(this);

    @Override
    public String getDisplayName() {
        return "Find source files with `BuildToolFailure` markers";
    }

    @Override
    public String getDescription() {
        return "This recipe explores build tool failures after an AST is produced for classifying the types of failures that can occur and prioritizing fixes according to the most common problems.";
    }

    @Override
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visitSourceFile(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile.getMarkers().findFirst(BuildToolFailure.class).map(failure -> {
                    FindBuildToolFailures.this.failures.insertRow(ctx, new BuildToolFailures.Row(failure.getType(), failure.getVersion(), failure.getCommand(), failure.getExitCode(), sourceFile.printAll()));
                    return Markup.info(sourceFile, String.format("Exit code %d", failure.getExitCode()));
                }).orElse(sourceFile);
            }
        };
    }

    public BuildToolFailures getFailures() {
        return this.failures;
    }

    @NonNull
    public String toString() {
        return "FindBuildToolFailures(failures=" + this.getFailures() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindBuildToolFailures)) {
            return false;
        }
        FindBuildToolFailures other = (FindBuildToolFailures)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildToolFailures this$failures = this.getFailures();
        BuildToolFailures other$failures = other.getFailures();
        return !(this$failures == null ? other$failures != null : !this$failures.equals(other$failures));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindBuildToolFailures;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BuildToolFailures $failures = this.getFailures();
        result = result * 59 + ($failures == null ? 43 : $failures.hashCode());
        return result;
    }
}

