/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import org.openrewrite.shaded.jgit.attributes.AttributesNode;
import org.openrewrite.shaded.jgit.internal.storage.file.FileRepository;
import org.openrewrite.shaded.jgit.lib.CoreConfig;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.util.FS;

public class GlobalAttributesNode
extends AttributesNode {
    final Repository repository;

    public GlobalAttributesNode(Repository repository) {
        this.repository = repository;
    }

    public AttributesNode load() throws IOException {
        AttributesNode r = new AttributesNode();
        FS fs = this.repository.getFS();
        String path = this.repository.getConfig().get(CoreConfig.KEY).getAttributesFile();
        if (path != null) {
            File attributesFile = path.startsWith("~/") ? fs.resolve(fs.userHome(), path.substring(2)) : fs.resolve(null, path);
            FileRepository.AttributesNodeProviderImpl.loadRulesFromFile(r, attributesFile);
        }
        return r.getRules().isEmpty() ? null : r;
    }
}

