/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.Duration;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;

@Incubating(since="7.29.0")
public class RecipeRunStats {
    final Recipe recipe;
    final List<RecipeRunStats> called;
    private final AtomicInteger calls = new AtomicInteger();
    private final AtomicLong cumulative = new AtomicLong();
    private final AtomicLong max = new AtomicLong();
    private final AtomicLong ownGetVisitor = new AtomicLong();
    private final AtomicLong ownVisit = new AtomicLong();
    private final AtomicLong applicability = new AtomicLong();

    public RecipeRunStats(Recipe recipe) {
        this.recipe = recipe;
        if (recipe.getRecipeList().isEmpty()) {
            this.called = new ArrayList<RecipeRunStats>();
        } else {
            this.called = new ArrayList<RecipeRunStats>(recipe.getRecipeList().size());
            for (Recipe callee : recipe.getRecipeList()) {
                this.addCalledRecipe(callee);
            }
        }
    }

    RecipeRunStats addCalledRecipe(Recipe recipe) {
        RecipeRunStats stats = new RecipeRunStats(recipe);
        this.called.add(stats);
        return stats;
    }

    void markCall() {
        this.calls.incrementAndGet();
    }

    public int getCalls() {
        return this.calls.get();
    }

    public Duration getCumulative() {
        return Duration.ofNanos(this.cumulative.get());
    }

    public Duration getMax() {
        return Duration.ofNanos(this.max.get());
    }

    void recipeVisitCompleted(long startTime) {
        long totalTime = System.nanoTime() - startTime;
        this.max.compareAndSet(Math.min(this.max.get(), totalTime), totalTime);
        this.cumulative.addAndGet(totalTime);
    }

    public Duration getOwnGetVisitor() {
        return Duration.ofNanos(this.ownGetVisitor.get());
    }

    void ownGetVisitorCompleted(long ownGetVisitorStartTime) {
        this.ownGetVisitor.addAndGet(System.nanoTime() - ownGetVisitorStartTime);
    }

    public Duration getOwnVisit() {
        return Duration.ofNanos(this.ownVisit.get());
    }

    void ownVisitCompleted(long ownVisitStartTime) {
        this.ownVisit.addAndGet(System.nanoTime() - ownVisitStartTime);
    }

    void applicabilityCompleted(long applicabilityStartTime) {
        this.applicability.addAndGet(System.nanoTime() - applicabilityStartTime);
    }

    public Duration getApplicability() {
        return Duration.ofNanos(this.applicability.get());
    }

    @Incubating(since="7.29.0")
    public String printAsMermaidGantt(double scale) {
        StringBuilder gantt = new StringBuilder("gantt\n");
        gantt.append("  axisFormat %M:%S\n");
        gantt.append("  dateFormat S\n\n");
        gantt.append("  section Recipe run\n");
        this.printAsMermaidGanttRecursive(gantt, null, this, new IdentityHashMap<RecipeRunStats, Integer>(), scale);
        return gantt.toString();
    }

    private void printAsMermaidGanttRecursive(StringBuilder gantt, @Nullable RecipeRunStats after, RecipeRunStats stats, Map<RecipeRunStats, Integer> seen, double scale) {
        seen.putIfAbsent(stats, seen.size() + 1);
        String id = "r" + seen.size();
        Duration time = stats.getOwnGetVisitor().plus(stats.getOwnVisit());
        String label = stats.getRecipe().getClass().getSimpleName();
        if (label.isEmpty()) {
            label = "Recipe";
        }
        gantt.append("  ").append(label).append("  :").append(id);
        if (after != null) {
            gantt.append(", ").append("after r").append(seen.get(after));
        } else {
            gantt.append(", 0");
        }
        long scaled = (long)((double)time.toNanos() / (1000000.0 / scale));
        gantt.append(", ").append(scaled).append("ms");
        gantt.append("\n");
        for (RecipeRunStats called : stats.getCalled()) {
            this.printAsMermaidGanttRecursive(gantt, stats, called, seen, scale);
        }
    }

    public String printAsCsv() {
        StringBuilder csv = new StringBuilder("id,caller,name,cumulative,max,ownGetVisitor,ownVisit,ownTotal\n");
        this.printAsCsvRecursive(csv, null, this, new IdentityHashMap<RecipeRunStats, Integer>());
        return csv.toString();
    }

    private void printAsCsvRecursive(StringBuilder csv, @Nullable RecipeRunStats after, RecipeRunStats stats, Map<RecipeRunStats, Integer> seen) {
        seen.putIfAbsent(stats, seen.size() + 1);
        String label = "r" + seen.size();
        Duration ownTotal = stats.getOwnGetVisitor().plus(stats.getOwnVisit());
        csv.append(label).append(",").append(after == null ? "" : "r" + seen.get(after)).append(",").append(stats.getRecipe().getClass().getSimpleName()).append(",").append(RecipeRunStats.humanReadableFormat(stats.getCumulative())).append(",").append(RecipeRunStats.humanReadableFormat(stats.getMax())).append(",").append(RecipeRunStats.humanReadableFormat(stats.getOwnGetVisitor())).append(",").append(RecipeRunStats.humanReadableFormat(stats.getOwnVisit())).append(",").append(RecipeRunStats.humanReadableFormat(ownTotal)).append("\n");
        for (RecipeRunStats called : stats.getCalled()) {
            this.printAsCsvRecursive(csv, stats, called, seen);
        }
    }

    private static String humanReadableFormat(Duration duration) {
        long seconds = duration.getSeconds();
        long micros = duration.toNanos() / 1000L - TimeUnit.SECONDS.toMicros(duration.getSeconds());
        return String.format("%s.%06d", seconds, micros);
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public List<RecipeRunStats> getCalled() {
        return this.called;
    }
}

