/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class BuildToolFailures
extends DataTable<Row> {
    public BuildToolFailures(Recipe recipe) {
        super(recipe, "Build tool failures", "Log output of failed build tool runs along with exit code and further diagnostics.");
    }

    public static final class Row {
        @Column(displayName="Type", description="The type of build tool that failed.")
        private final String type;
        @Column(displayName="Version", description="The version of the build tool that failed, if available.")
        private final String version;
        @Column(displayName="Command", description="The command that was executed.")
        private final String command;
        @Column(displayName="Exit code", description="The exit code of the build tool run.")
        private final Integer exitCode;
        @Column(displayName="Required Java version", description="The required Java version for the build, if detectable.")
        private final String requiredJavaVersion;
        @Column(displayName="Log output", description="The log output of the build tool run.")
        private final String logOutput;

        public Row(String type, String version, String command, Integer exitCode, String requiredJavaVersion, String logOutput) {
            this.type = type;
            this.version = version;
            this.command = command;
            this.exitCode = exitCode;
            this.requiredJavaVersion = requiredJavaVersion;
            this.logOutput = logOutput;
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public String getCommand() {
            return this.command;
        }

        public Integer getExitCode() {
            return this.exitCode;
        }

        public String getRequiredJavaVersion() {
            return this.requiredJavaVersion;
        }

        public String getLogOutput() {
            return this.logOutput;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$exitCode = this.getExitCode();
            Integer other$exitCode = other.getExitCode();
            if (this$exitCode == null ? other$exitCode != null : !((Object)this$exitCode).equals(other$exitCode)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            String this$requiredJavaVersion = this.getRequiredJavaVersion();
            String other$requiredJavaVersion = other.getRequiredJavaVersion();
            if (this$requiredJavaVersion == null ? other$requiredJavaVersion != null : !this$requiredJavaVersion.equals(other$requiredJavaVersion)) {
                return false;
            }
            String this$logOutput = this.getLogOutput();
            String other$logOutput = other.getLogOutput();
            return !(this$logOutput == null ? other$logOutput != null : !this$logOutput.equals(other$logOutput));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $exitCode = this.getExitCode();
            result = result * 59 + ($exitCode == null ? 43 : ((Object)$exitCode).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            String $requiredJavaVersion = this.getRequiredJavaVersion();
            result = result * 59 + ($requiredJavaVersion == null ? 43 : $requiredJavaVersion.hashCode());
            String $logOutput = this.getLogOutput();
            result = result * 59 + ($logOutput == null ? 43 : $logOutput.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "BuildToolFailures.Row(type=" + this.getType() + ", version=" + this.getVersion() + ", command=" + this.getCommand() + ", exitCode=" + this.getExitCode() + ", requiredJavaVersion=" + this.getRequiredJavaVersion() + ", logOutput=" + this.getLogOutput() + ")";
        }
    }
}

