/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.text.PlainText;

public class PlainTextVisitor<P>
extends TreeVisitor<PlainText, P> {
    @Override
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof PlainText;
    }

    public PlainText visitText(PlainText text, P p) {
        PlainText t = text.withMarkers(this.visitMarkers(text.getMarkers(), p));
        t = t.withSnippets(ListUtils.map(t.getSnippets(), snippet -> {
            this.setCursor(new Cursor(this.getCursor(), snippet));
            PlainText.Snippet s = this.visitSnippet((PlainText.Snippet)snippet, p);
            this.setCursor(this.getCursor().getParent());
            return s;
        }));
        return t;
    }

    public PlainText.Snippet visitSnippet(PlainText.Snippet snippet, P p) {
        return snippet.withMarkers(this.visitMarkers(snippet.getMarkers(), p));
    }
}

