/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;

public class PathUtils {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    private PathUtils() {
    }

    public static boolean equalIgnoringSeparators(Path a, Path b) {
        return PathUtils.equalIgnoringSeparators(a.normalize().toString(), b.normalize().toString());
    }

    public static boolean equalIgnoringSeparators(String a, String b) {
        return PathUtils.separatorsToSystem(a).equals(PathUtils.separatorsToSystem(b));
    }

    public static String separatorsToUnix(String path) {
        return path.replace('\\', '/');
    }

    public static String separatorsToWindows(String path) {
        return path.replace('/', '\\');
    }

    public static String separatorsToSystem(String path) {
        if (File.separatorChar == '\\') {
            return PathUtils.separatorsToWindows(path);
        }
        return PathUtils.separatorsToUnix(path);
    }

    public static boolean matchesGlob(@Nullable Path path, @Nullable String globPattern) {
        if ("**".equals(globPattern)) {
            return true;
        }
        if (globPattern == null || path == null) {
            return false;
        }
        String relativePath = path.toString();
        if (relativePath.isEmpty() && globPattern.isEmpty()) {
            return true;
        }
        List<String> eitherOrPatterns = PathUtils.getEitherOrPatterns(globPattern);
        List<String> excludedPatterns = PathUtils.getExcludedPatterns(globPattern);
        if (eitherOrPatterns.isEmpty() && excludedPatterns.isEmpty()) {
            return PathUtils.matchesGlob(globPattern, relativePath);
        }
        if (!eitherOrPatterns.isEmpty()) {
            for (String eitherOrPattern : eitherOrPatterns) {
                if (!PathUtils.matchesGlob(Paths.get(relativePath, new String[0]), eitherOrPattern)) continue;
                return true;
            }
            return false;
        }
        String wildcard = PathUtils.convertNegationToWildcard(globPattern);
        if (!PathUtils.matchesGlob(wildcard, relativePath)) {
            return false;
        }
        for (String excludedPattern : excludedPatterns) {
            if (!PathUtils.matchesGlob(excludedPattern, relativePath)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesGlob(String pattern, String path) {
        int pathIdxStart;
        String[] pattTokens = PathUtils.tokenize(pattern);
        String[] pathTokens = PathUtils.tokenize(path);
        int pattIdxStart = 0;
        int pattIdxEnd = pattTokens.length - 1;
        int pathIdxEnd = pathTokens.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(pattTokens[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (StringUtils.matchesGlob(pathTokens[pathIdxStart], pattTokens[pattIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return !PathUtils.isFileSeparator(pattern.charAt(pattern.length() - 1));
            }
            if (pattIdxStart == pattIdxEnd && pattTokens[pattIdxStart].equals("*") && PathUtils.isFileSeparator(path.charAt(path.length() - 1))) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattTokens[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(pattTokens[pattIdxEnd])) {
            if (!StringUtils.matchesGlob(pathTokens[pathIdxEnd], pattTokens[pattIdxEnd])) {
                return false;
            }
            if (pattIdxEnd == pattTokens.length - 1 && PathUtils.isFileSeparator(pattern.charAt(pattern.length() - 1)) ^ PathUtils.isFileSeparator(path.charAt(path.length() - 1))) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattTokens[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattTokens[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    if (!StringUtils.matchesGlob(pathTokens[pathIdxStart + i + j], pattTokens[pattIdxStart + j + 1])) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattTokens[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    public static String convertNegationToWildcard(String globPattern) {
        String negationPattern = "!\\((.*?)\\)";
        return globPattern.replaceAll(negationPattern, "**");
    }

    public static List<String> getExcludedPatterns(String globPattern) {
        if (!globPattern.contains("!")) {
            return Collections.emptyList();
        }
        ArrayList<String> excludedPatterns = new ArrayList<String>(3);
        String negationPattern = "!\\((.*?)\\)";
        Pattern pattern = Pattern.compile(negationPattern);
        Matcher matcher = pattern.matcher(globPattern);
        while (matcher.find()) {
            String[] options;
            String negationContent = matcher.group(1);
            for (String option : options = negationContent.split("\\|")) {
                excludedPatterns.add(globPattern.replace(matcher.group(), option));
            }
        }
        return excludedPatterns;
    }

    public static List<String> getEitherOrPatterns(String globPattern) {
        if (!globPattern.contains("{")) {
            return Collections.emptyList();
        }
        ArrayList<String> eitherOrPatterns = new ArrayList<String>(3);
        String eitherOrPattern = "\\{(.*?)}";
        Pattern pattern = Pattern.compile(eitherOrPattern);
        Matcher matcher = pattern.matcher(globPattern);
        while (matcher.find()) {
            String[] options;
            String eitherOrContent = matcher.group(1);
            for (String option : options = eitherOrContent.split(",")) {
                eitherOrPatterns.add(globPattern.replace(matcher.group(), option));
            }
        }
        return eitherOrPatterns;
    }

    private static String[] tokenize(String path) {
        int pathIdxTmp;
        ArrayList<String> tokens = new ArrayList<String>();
        int pathIdxStart = 0;
        int pathIdxEnd = path.length() - 1;
        for (pathIdxTmp = 0; pathIdxTmp <= pathIdxEnd; ++pathIdxTmp) {
            if (!PathUtils.isFileSeparator(path.charAt(pathIdxTmp))) continue;
            tokens.add(path.substring(pathIdxStart, pathIdxTmp));
            pathIdxStart = pathIdxTmp + 1;
        }
        if (pathIdxStart == 0) {
            tokens.add(path);
        } else if (pathIdxStart != pathIdxTmp) {
            tokens.add(path.substring(pathIdxStart, pathIdxTmp));
        }
        return tokens.toArray(new String[0]);
    }

    private static boolean isFileSeparator(char ch) {
        return PathUtils.isFileSeparator(false, ch);
    }

    private static boolean isFileSeparator(boolean strict, char ch) {
        return strict ? ch == File.separatorChar : ch == '/' || ch == '\\';
    }
}

