/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.TildeRange;
import org.openrewrite.semver.VersionComparator;

public class LatestIntegration
extends LatestRelease {
    @Nullable String metadataPattern;

    public LatestIntegration(@Nullable String metadataPattern) {
        super(metadataPattern);
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return VersionComparator.checkVersion(version, this.getMetadataPattern(), false);
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        if (currentVersion == null) {
            return new LatestRelease(null).compare(null, v1, v2);
        }
        return TildeRange.build("~" + Semver.majorVersion(currentVersion) + "." + Semver.minorVersion(currentVersion), this.metadataPattern).getValue().compare(currentVersion, v1, v2);
    }

    public static Validated<LatestIntegration> build(String toVersion, @Nullable String metadataPattern) {
        return "latest.integration".equalsIgnoreCase(toVersion) || "latest.snapshot".equalsIgnoreCase(toVersion) ? Validated.valid("latestIntegration", new LatestIntegration(metadataPattern)) : Validated.invalid("latestIntegration", toVersion, "not latest integration");
    }
}

