/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.MavenRepository;

public final class GradleProject
implements Marker,
Serializable {
    private final UUID id;
    private final @Nullable String group;
    private final String name;
    private final @Nullable String version;
    private final String path;
    private final List<GradlePluginDescriptor> plugins;
    private final List<MavenRepository> mavenRepositories;
    private final List<MavenRepository> mavenPluginRepositories;
    private final Map<String, GradleDependencyConfiguration> nameToConfiguration;

    public GradleProject(UUID id, String name, String path, List<GradlePluginDescriptor> plugins, List<MavenRepository> mavenRepositories, List<MavenRepository> mavenPluginRepositories, Map<String, GradleDependencyConfiguration> nameToConfiguration) {
        this(id, "", name, "", path, plugins, mavenRepositories, mavenPluginRepositories, nameToConfiguration);
    }

    public List<MavenRepository> getMavenPluginRepositories() {
        return this.mavenPluginRepositories == null ? Collections.emptyList() : this.mavenPluginRepositories;
    }

    public @Nullable GradleDependencyConfiguration getConfiguration(String name) {
        return this.nameToConfiguration.get(name);
    }

    public List<GradleDependencyConfiguration> getConfigurations() {
        return new ArrayList<GradleDependencyConfiguration>(this.nameToConfiguration.values());
    }

    public List<GradleDependencyConfiguration> configurationsExtendingFrom(GradleDependencyConfiguration parentConfiguration, boolean transitive) {
        ArrayList<GradleDependencyConfiguration> result = new ArrayList<GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration configuration : this.nameToConfiguration.values()) {
            if (configuration == parentConfiguration) continue;
            for (GradleDependencyConfiguration extendsFrom : configuration.getExtendsFrom()) {
                if (extendsFrom != parentConfiguration) continue;
                result.add(configuration);
                if (!transitive) continue;
                result.addAll(this.configurationsExtendingFrom(configuration, true));
            }
        }
        return result;
    }

    public GradleProject withNameToConfiguration(Map<String, GradleDependencyConfiguration> nameToConfiguration) {
        HashMap<String, GradleDependencyConfiguration> configurations = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration);
        for (GradleDependencyConfiguration gdc : configurations.values()) {
            ArrayList<GradleDependencyConfiguration> extendsFromList = new ArrayList<GradleDependencyConfiguration>(gdc.getExtendsFrom());
            boolean changed = false;
            for (int i = 0; i < extendsFromList.size(); ++i) {
                GradleDependencyConfiguration extendsFrom = (GradleDependencyConfiguration)extendsFromList.get(i);
                if (configurations.get(extendsFrom.getName()) == extendsFrom) continue;
                extendsFromList.set(i, (GradleDependencyConfiguration)configurations.get(extendsFrom.getName()));
                changed = true;
            }
            if (!changed) continue;
            configurations.put(gdc.getName(), gdc.withExtendsFrom(extendsFromList));
        }
        return new GradleProject(this.id, this.group, this.name, this.version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, configurations);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public @Nullable String getGroup() {
        return this.group;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public List<GradlePluginDescriptor> getPlugins() {
        return this.plugins;
    }

    @Generated
    public List<MavenRepository> getMavenRepositories() {
        return this.mavenRepositories;
    }

    @Generated
    public Map<String, GradleDependencyConfiguration> getNameToConfiguration() {
        return this.nameToConfiguration;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleProject)) {
            return false;
        }
        GradleProject other = (GradleProject)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<GradlePluginDescriptor> this$plugins = this.getPlugins();
        List<GradlePluginDescriptor> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        List<MavenRepository> this$mavenRepositories = this.getMavenRepositories();
        List<MavenRepository> other$mavenRepositories = other.getMavenRepositories();
        if (this$mavenRepositories == null ? other$mavenRepositories != null : !((Object)this$mavenRepositories).equals(other$mavenRepositories)) {
            return false;
        }
        List<MavenRepository> this$mavenPluginRepositories = this.getMavenPluginRepositories();
        List<MavenRepository> other$mavenPluginRepositories = other.getMavenPluginRepositories();
        if (this$mavenPluginRepositories == null ? other$mavenPluginRepositories != null : !((Object)this$mavenPluginRepositories).equals(other$mavenPluginRepositories)) {
            return false;
        }
        Map<String, GradleDependencyConfiguration> this$nameToConfiguration = this.getNameToConfiguration();
        Map<String, GradleDependencyConfiguration> other$nameToConfiguration = other.getNameToConfiguration();
        return !(this$nameToConfiguration == null ? other$nameToConfiguration != null : !((Object)this$nameToConfiguration).equals(other$nameToConfiguration));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<GradlePluginDescriptor> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        List<MavenRepository> $mavenRepositories = this.getMavenRepositories();
        result = result * 59 + ($mavenRepositories == null ? 43 : ((Object)$mavenRepositories).hashCode());
        List<MavenRepository> $mavenPluginRepositories = this.getMavenPluginRepositories();
        result = result * 59 + ($mavenPluginRepositories == null ? 43 : ((Object)$mavenPluginRepositories).hashCode());
        Map<String, GradleDependencyConfiguration> $nameToConfiguration = this.getNameToConfiguration();
        result = result * 59 + ($nameToConfiguration == null ? 43 : ((Object)$nameToConfiguration).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleProject(id=" + this.getId() + ", group=" + this.getGroup() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", path=" + this.getPath() + ", plugins=" + this.getPlugins() + ", mavenRepositories=" + this.getMavenRepositories() + ", mavenPluginRepositories=" + this.getMavenPluginRepositories() + ", nameToConfiguration=" + this.getNameToConfiguration() + ")";
    }

    @JsonCreator
    @Generated
    public GradleProject(UUID id, @Nullable String group, String name, @Nullable String version, String path, List<GradlePluginDescriptor> plugins, List<MavenRepository> mavenRepositories, List<MavenRepository> mavenPluginRepositories, Map<String, GradleDependencyConfiguration> nameToConfiguration) {
        this.id = id;
        this.group = group;
        this.name = name;
        this.version = version;
        this.path = path;
        this.plugins = plugins;
        this.mavenRepositories = mavenRepositories;
        this.mavenPluginRepositories = mavenPluginRepositories;
        this.nameToConfiguration = nameToConfiguration;
    }

    @NonNull
    @Generated
    public GradleProject withId(UUID id) {
        return this.id == id ? this : new GradleProject(id, this.group, this.name, this.version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration);
    }

    @NonNull
    @Generated
    public GradleProject withGroup(@Nullable String group) {
        return this.group == group ? this : new GradleProject(this.id, group, this.name, this.version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration);
    }

    @NonNull
    @Generated
    public GradleProject withName(String name) {
        return this.name == name ? this : new GradleProject(this.id, this.group, name, this.version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration);
    }

    @NonNull
    @Generated
    public GradleProject withVersion(@Nullable String version) {
        return this.version == version ? this : new GradleProject(this.id, this.group, this.name, version, this.path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration);
    }

    @NonNull
    @Generated
    public GradleProject withPath(String path) {
        return this.path == path ? this : new GradleProject(this.id, this.group, this.name, this.version, path, this.plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration);
    }

    @NonNull
    @Generated
    public GradleProject withPlugins(List<GradlePluginDescriptor> plugins) {
        return this.plugins == plugins ? this : new GradleProject(this.id, this.group, this.name, this.version, this.path, plugins, this.mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration);
    }

    @NonNull
    @Generated
    public GradleProject withMavenRepositories(List<MavenRepository> mavenRepositories) {
        return this.mavenRepositories == mavenRepositories ? this : new GradleProject(this.id, this.group, this.name, this.version, this.path, this.plugins, mavenRepositories, this.mavenPluginRepositories, this.nameToConfiguration);
    }

    @NonNull
    @Generated
    public GradleProject withMavenPluginRepositories(List<MavenRepository> mavenPluginRepositories) {
        return this.mavenPluginRepositories == mavenPluginRepositories ? this : new GradleProject(this.id, this.group, this.name, this.version, this.path, this.plugins, this.mavenRepositories, mavenPluginRepositories, this.nameToConfiguration);
    }
}

