/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.hcl.JsonPathMatcher;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class MoveContentToFile
extends ScanningRecipe<Scanned> {
    @Option(displayName="Content path", description="A JSONPath expression specifying the block to move.", example="$.provider")
    private final String contentPath;
    @Option(displayName="From path", description="The source path of the file from which content is being moved.", example="from.tf")
    private final String fromPath;
    @Option(displayName="To path", description="The source path of the file to move the content to.", example="to.tf")
    private final String destinationPath;

    public String getDisplayName() {
        return "Move content to another file";
    }

    public String getDescription() {
        return "Move content to another HCL file, deleting it in the original file.";
    }

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        final JsonPathMatcher pathMatcher = new JsonPathMatcher(this.contentPath);
        final Path from = Paths.get(this.fromPath, new String[0]);
        final Path dest = Paths.get(this.destinationPath, new String[0]);
        return new HclIsoVisitor<ExecutionContext>(){

            @Override
            public Hcl.ConfigFile visitConfigFile(Hcl.ConfigFile configFile, ExecutionContext ctx) {
                if (configFile.getSourcePath().equals(from)) {
                    return super.visitConfigFile(configFile, ctx);
                }
                if (configFile.getSourcePath().equals(dest)) {
                    acc.destinationExists = true;
                }
                return configFile;
            }

            @Override
            public BodyContent visitBodyContent(BodyContent bodyContent, ExecutionContext ctx) {
                Hcl b = super.visitBodyContent(bodyContent, ctx);
                if (pathMatcher.matches(this.getCursor())) {
                    acc.toMove = bodyContent;
                }
                return b;
            }
        };
    }

    public Collection<Hcl.ConfigFile> generate(Scanned acc, ExecutionContext ctx) {
        if (acc.destinationExists || acc.toMove == null) {
            return Collections.emptyList();
        }
        Hcl.ConfigFile configFile = HclParser.builder().build().parse(new String[]{""}).findFirst().map(Hcl.ConfigFile.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as HCL"));
        configFile = configFile.withBody(Collections.singletonList(acc.toMove.withPrefix(Space.EMPTY))).withSourcePath(Paths.get(this.destinationPath, new String[0]));
        return Collections.singletonList(configFile);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Scanned acc) {
        final JsonPathMatcher pathMatcher = new JsonPathMatcher(this.contentPath);
        final Path from = Paths.get(this.fromPath, new String[0]);
        final Path dest = Paths.get(this.destinationPath, new String[0]);
        return Preconditions.check((acc.toMove != null ? 1 : 0) != 0, (TreeVisitor)new HclIsoVisitor<ExecutionContext>(){

            @Override
            public BodyContent visitBodyContent(BodyContent bodyContent, ExecutionContext ctx) {
                Hcl b = super.visitBodyContent(bodyContent, ctx);
                Path sourcePath = ((Hcl.ConfigFile)this.getCursor().firstEnclosingOrThrow(Hcl.ConfigFile.class)).getSourcePath();
                if (sourcePath.equals(from) && pathMatcher.matches(this.getCursor())) {
                    return null;
                }
                if (sourcePath.equals(dest) && pathMatcher.matches(this.getCursor())) {
                    return acc.toMove;
                }
                return b;
            }
        });
    }

    @Generated
    public MoveContentToFile(String contentPath, String fromPath, String destinationPath) {
        this.contentPath = contentPath;
        this.fromPath = fromPath;
        this.destinationPath = destinationPath;
    }

    @Generated
    public String getContentPath() {
        return this.contentPath;
    }

    @Generated
    public String getFromPath() {
        return this.fromPath;
    }

    @Generated
    public String getDestinationPath() {
        return this.destinationPath;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MoveContentToFile(contentPath=" + this.getContentPath() + ", fromPath=" + this.getFromPath() + ", destinationPath=" + this.getDestinationPath() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveContentToFile)) {
            return false;
        }
        MoveContentToFile other = (MoveContentToFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$contentPath = this.getContentPath();
        String other$contentPath = other.getContentPath();
        if (this$contentPath == null ? other$contentPath != null : !this$contentPath.equals(other$contentPath)) {
            return false;
        }
        String this$fromPath = this.getFromPath();
        String other$fromPath = other.getFromPath();
        if (this$fromPath == null ? other$fromPath != null : !this$fromPath.equals(other$fromPath)) {
            return false;
        }
        String this$destinationPath = this.getDestinationPath();
        String other$destinationPath = other.getDestinationPath();
        return !(this$destinationPath == null ? other$destinationPath != null : !this$destinationPath.equals(other$destinationPath));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MoveContentToFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contentPath = this.getContentPath();
        result = result * 59 + ($contentPath == null ? 43 : $contentPath.hashCode());
        String $fromPath = this.getFromPath();
        result = result * 59 + ($fromPath == null ? 43 : $fromPath.hashCode());
        String $destinationPath = this.getDestinationPath();
        result = result * 59 + ($destinationPath == null ? 43 : $destinationPath.hashCode());
        return result;
    }

    static class Scanned {
        @Nullable
        BodyContent toMove;
        boolean destinationExists;

        Scanned() {
        }
    }
}

