/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.type.NullType;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeSignatureBuilder;
import org.openrewrite.java.tree.JavaType;

class ReloadableJava8TypeSignatureBuilder
implements JavaTypeSignatureBuilder {
    @Nullable
    private Set<String> typeVariableNameStack;

    ReloadableJava8TypeSignatureBuilder() {
    }

    public String signature(@Nullable Object t) {
        return this.signature((Type)t);
    }

    private String signature(@Nullable Type type) {
        if (type == null || type instanceof Type.UnknownType || type instanceof NullType) {
            return "{undefined}";
        }
        if (type instanceof Type.ClassType) {
            try {
                return ((Type.ClassType)type).typarams_field != null && ((Type.ClassType)type).typarams_field.length() > 0 ? this.parameterizedSignature(type) : this.classSignature(type);
            }
            catch (Symbol.CompletionFailure ignored) {
                return ((Type.ClassType)type).typarams_field != null && ((Type.ClassType)type).typarams_field.length() > 0 ? this.parameterizedSignature(type) : this.classSignature(type);
            }
        }
        if (type instanceof Type.CapturedType) {
            return this.signature(((Type.CapturedType)type).wildcard);
        }
        if (type instanceof Type.TypeVar) {
            return this.genericSignature(type);
        }
        if (type instanceof Type.JCPrimitiveType) {
            return this.primitiveSignature(type);
        }
        if (type instanceof Type.JCVoidType) {
            return "void";
        }
        if (type instanceof Type.ArrayType) {
            return this.arraySignature(type);
        }
        if (type instanceof Type.WildcardType) {
            Type.WildcardType wildcard = (Type.WildcardType)type;
            StringBuilder s = new StringBuilder("Generic{" + wildcard.kind.toString());
            if (!type.isUnbound()) {
                s.append(this.signature(wildcard.type));
            }
            return s.append("}").toString();
        }
        if (type instanceof Type.JCNoType) {
            return "{none}";
        }
        if (type instanceof Type.AnnotatedType) {
            return this.signature(type.unannotatedType());
        }
        throw new IllegalStateException("Unexpected type " + type.getClass().getName());
    }

    private void completeClassSymbol(Symbol.ClassSymbol classSymbol) {
        try {
            classSymbol.complete();
        }
        catch (Symbol.CompletionFailure completionFailure) {
            // empty catch block
        }
    }

    public String arraySignature(Object type) {
        return this.signature(((Type.ArrayType)type).elemtype) + "[]";
    }

    public String classSignature(Object type) {
        if (type instanceof Type.JCVoidType) {
            return "void";
        }
        if (type instanceof Type.JCPrimitiveType) {
            return this.primitiveSignature(type);
        }
        if (type instanceof Type.JCNoType) {
            return "{undefined}";
        }
        Symbol.ClassSymbol sym = (Symbol.ClassSymbol)((Type.ClassType)type).tsym;
        this.completeClassSymbol(sym);
        return sym.flatName().toString();
    }

    public String genericSignature(Object type) {
        String boundSigStr;
        Type.TypeVar generic = (Type.TypeVar)type;
        String name = generic.tsym.name.toString();
        if (this.typeVariableNameStack == null) {
            this.typeVariableNameStack = new HashSet<String>();
        }
        if (!this.typeVariableNameStack.add(name)) {
            return "Generic{" + name + "}";
        }
        StringBuilder s = new StringBuilder("Generic{").append(name);
        StringJoiner boundSigs = new StringJoiner(" & ");
        if (generic.getUpperBound() instanceof Type.IntersectionClassType) {
            String bound;
            Type.IntersectionClassType intersectionBound = (Type.IntersectionClassType)generic.getUpperBound();
            if (intersectionBound.supertype_field != null && !"java.lang.Object".equals(bound = this.signature(intersectionBound.supertype_field))) {
                boundSigs.add(bound);
            }
            for (Type bound2 : intersectionBound.interfaces_field) {
                boundSigs.add(this.signature(bound2));
            }
        } else {
            String bound = this.signature(generic.getUpperBound());
            if (!"java.lang.Object".equals(bound)) {
                boundSigs.add(bound);
            }
        }
        if (!(boundSigStr = boundSigs.toString()).isEmpty()) {
            s.append(" extends ").append(boundSigStr);
        }
        this.typeVariableNameStack.remove(name);
        return s.append("}").toString();
    }

    public String parameterizedSignature(Object type) {
        StringBuilder s = new StringBuilder(this.classSignature(type));
        StringJoiner joiner = new StringJoiner(", ", "<", ">");
        for (Type tp : ((Type.ClassType)type).typarams_field) {
            String signature = this.signature(tp);
            joiner.add(signature);
        }
        s.append(joiner);
        return s.toString();
    }

    public String primitiveSignature(Object type) {
        TypeTag tag = ((Type.JCPrimitiveType)type).getTag();
        switch (tag) {
            case BOOLEAN: {
                return JavaType.Primitive.Boolean.getKeyword();
            }
            case BYTE: {
                return JavaType.Primitive.Byte.getKeyword();
            }
            case CHAR: {
                return JavaType.Primitive.Char.getKeyword();
            }
            case DOUBLE: {
                return JavaType.Primitive.Double.getKeyword();
            }
            case FLOAT: {
                return JavaType.Primitive.Float.getKeyword();
            }
            case INT: {
                return JavaType.Primitive.Int.getKeyword();
            }
            case LONG: {
                return JavaType.Primitive.Long.getKeyword();
            }
            case SHORT: {
                return JavaType.Primitive.Short.getKeyword();
            }
            case VOID: {
                return JavaType.Primitive.Void.getKeyword();
            }
            case NONE: {
                return JavaType.Primitive.None.getKeyword();
            }
            case CLASS: {
                return JavaType.Primitive.String.getKeyword();
            }
            case BOT: {
                return JavaType.Primitive.Null.getKeyword();
            }
        }
        throw new IllegalArgumentException("Unknown type tag " + (Object)((Object)tag));
    }

    public String methodSignature(Type selectType, Symbol.MethodSymbol symbol) {
        String s = this.classSignature(symbol.owner.type);
        s = symbol.isConstructor() ? s + "{name=<constructor>,return=" + s : s + "{name=" + ((Name)symbol.getSimpleName()).toString() + ",return=" + this.signature(selectType.getReturnType());
        return s + ",parameters=" + this.methodArgumentSignature(selectType) + '}';
    }

    public String methodSignature(Symbol.MethodSymbol symbol) {
        String s = this.classSignature(symbol.owner.type);
        String returnType = symbol.isStaticOrInstanceInit() ? "void" : this.signature(symbol.getReturnType());
        s = symbol.isConstructor() ? s + "{name=<constructor>,return=" + s : s + "{name=" + ((Name)symbol.getSimpleName()).toString() + ",return=" + returnType;
        return s + ",parameters=" + this.methodArgumentSignature(symbol) + '}';
    }

    private String methodArgumentSignature(Symbol.MethodSymbol sym) {
        if (sym.isStaticOrInstanceInit()) {
            return "[]";
        }
        StringJoiner genericArgumentTypes = new StringJoiner(",", "[", "]");
        if (sym.type == null) {
            genericArgumentTypes.add("{undefined}");
        } else {
            for (Symbol.VarSymbol parameter : sym.getParameters()) {
                genericArgumentTypes.add(this.signature(parameter.type));
            }
        }
        return genericArgumentTypes.toString();
    }

    private String methodArgumentSignature(Type selectType) {
        if (selectType instanceof Type.MethodType) {
            StringJoiner resolvedArgumentTypes = new StringJoiner(",", "[", "]");
            Type.MethodType mt = (Type.MethodType)selectType;
            if (!mt.argtypes.isEmpty()) {
                for (Type argtype : mt.argtypes) {
                    if (argtype == null) continue;
                    resolvedArgumentTypes.add(this.signature(argtype));
                }
            }
            return resolvedArgumentTypes.toString();
        }
        if (selectType instanceof Type.ForAll) {
            return this.methodArgumentSignature(((Type.ForAll)selectType).qtype);
        }
        if (selectType instanceof Type.JCNoType || selectType instanceof Type.UnknownType) {
            return "{undefined}";
        }
        throw new UnsupportedOperationException("Unexpected method type " + selectType.getClass().getName());
    }

    public String variableSignature(Symbol symbol) {
        String owner;
        if (symbol.owner instanceof Symbol.MethodSymbol) {
            owner = this.methodSignature((Symbol.MethodSymbol)symbol.owner);
        } else {
            owner = this.signature(symbol.owner.type);
            if (owner.contains("<")) {
                owner = owner.substring(0, owner.indexOf(60));
            }
        }
        return owner + "{name=" + symbol.name.toString() + ",type=" + this.signature(symbol.type) + '}';
    }
}

