/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.internal.KotlinTreeParserVisitor;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class TrailingCommaVisitor<P>
extends KotlinIsoVisitor<P> {
    private final boolean useTrailingComma;

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
        return m.getPadding().withParameters(this.handleTrailingComma(m.getPadding().getParameters()));
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = super.visitMethodInvocation(method, p);
        return m.getPadding().withArguments(this.handleTrailingComma(m.getPadding().getArguments()));
    }

    private <T extends J> JContainer<T> handleTrailingComma(JContainer<T> container) {
        List rps = container.getPadding().getElements();
        if (!rps.isEmpty()) {
            JRightPadded last;
            JRightPadded updated = last = (JRightPadded)rps.get(rps.size() - 1);
            Markers markers = last.getMarkers();
            Optional maybeTrailingComma = markers.findFirst(TrailingComma.class);
            if (!this.useTrailingComma && maybeTrailingComma.isPresent()) {
                markers = markers.removeByType(TrailingComma.class);
                updated = last.withMarkers(markers).withAfter(KotlinTreeParserVisitor.merge(last.getAfter(), ((TrailingComma)maybeTrailingComma.get()).getSuffix()));
            }
            if (this.useTrailingComma && !maybeTrailingComma.isPresent()) {
                markers = markers.add((Marker)new TrailingComma(UUID.randomUUID(), last.getAfter()));
                updated = last.withMarkers(markers).withAfter(Space.EMPTY);
            }
            if (updated != last) {
                JRightPadded finalUpdated = updated;
                rps = ListUtils.mapLast((List)rps, x -> finalUpdated);
                container = container.getPadding().withElements(rps);
            }
        }
        return container;
    }

    public TrailingCommaVisitor(boolean useTrailingComma) {
        this.useTrailingComma = useTrailingComma;
    }
}

