/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class FindTags
extends Recipe {
    @Option(displayName="XPath", description="An XPath expression used to find matching tags.", example="//dependencies/dependency")
    private final String xPath;

    public String getDisplayName() {
        return "Find XML tags";
    }

    public String getDescription() {
        return "Find XML tags by XPath expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher matcher = new XPathMatcher(this.xPath);
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
                if (matcher.matches(this.getCursor())) {
                    t = (Xml.Tag)SearchResult.found((Tree)t);
                }
                return t;
            }
        };
    }

    public static Set<Xml.Tag> find(Xml x, String xPath) {
        final XPathMatcher matcher = new XPathMatcher(xPath);
        HashSet<Xml.Tag> ts = new HashSet<Xml.Tag>();
        new XmlVisitor<Set<Xml.Tag>>(){

            @Override
            public Xml visitTag(Xml.Tag tag, Set<Xml.Tag> ts) {
                if (matcher.matches(this.getCursor())) {
                    ts.add(tag);
                }
                return super.visitTag(tag, ts);
            }
        }.visit(x, ts);
        return ts;
    }

    @Incubating(since="7.33.0")
    public static @Nullable Xml.Tag findSingle(Xml x, String xPath) {
        Set<Xml.Tag> tags = FindTags.find(x, xPath);
        if (tags.size() != 1) {
            return null;
        }
        Iterator<Xml.Tag> iterator = tags.iterator();
        if (iterator.hasNext()) {
            Xml.Tag tag = iterator.next();
            return tag;
        }
        return null;
    }

    @Generated
    public FindTags(String xPath) {
        this.xPath = xPath;
    }

    @Generated
    public String getXPath() {
        return this.xPath;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindTags(xPath=" + this.getXPath() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTags)) {
            return false;
        }
        FindTags other = (FindTags)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        return !(this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindTags;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        return result;
    }
}

