/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.tree.Xml;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.xml.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Detector detector() {
        return new Detector();
    }

    public static class Detector {
        private final IndentStatistics indentStatistics = new IndentStatistics();
        private final GeneralFormatStatistics generalFormatStatistics = new GeneralFormatStatistics();
        private final FindIndentXmlVisitor findIndentXmlVisitor = new FindIndentXmlVisitor();
        private final FindLineFormatJavaVisitor findLineFormatJavaVisitor = new FindLineFormatJavaVisitor();

        public void sample(SourceFile xml) {
            if (xml instanceof Xml.Document) {
                this.findIndentXmlVisitor.visit((Tree)xml, this.indentStatistics);
                this.findLineFormatJavaVisitor.visit((Tree)xml, this.generalFormatStatistics);
            }
        }

        public Autodetect build() {
            return new Autodetect(Tree.randomId(), Arrays.asList(this.indentStatistics.getTabsAndIndentsStyle(), this.generalFormatStatistics.getFormatStyle()));
        }
    }

    private static class GeneralFormatStatistics {
        private int linesWithCRLFNewLines = 0;
        private int linesWithLFNewLines = 0;

        private GeneralFormatStatistics() {
        }

        public boolean isIndentedWithLFNewLines() {
            return this.linesWithLFNewLines >= this.linesWithCRLFNewLines;
        }

        public GeneralFormatStyle getFormatStyle() {
            boolean useCRLF = !this.isIndentedWithLFNewLines();
            return new GeneralFormatStyle(useCRLF);
        }
    }

    private static class FindIndentXmlVisitor
    extends XmlVisitor<IndentStatistics> {
        private FindIndentXmlVisitor() {
        }

        @Override
        public Xml visitTag(Xml.Tag tag, IndentStatistics stats) {
            this.measureFrequencies(tag.getPrefix(), stats.indentFrequencies);
            return super.visitTag(tag, stats);
        }

        @Override
        public Xml visitAttribute(Xml.Attribute attribute, IndentStatistics stats) {
            this.measureFrequencies(attribute.getPrefix(), stats.continuationIndentFrequencies);
            return super.visitAttribute(attribute, stats);
        }

        private void measureFrequencies(String prefix, IndentFrequencies frequencies) {
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            if (prefix.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
                return takeWhile.get();
            }).count() > 0L) {
                char[] chars;
                int tabIndent = 0;
                int spaceIndent = 0;
                boolean mixed = false;
                for (char c2 : chars = prefix.toCharArray()) {
                    if (c2 == '\n' || c2 == '\r') {
                        tabIndent = 0;
                        spaceIndent = 0;
                        mixed = false;
                        continue;
                    }
                    if (mixed) continue;
                    if (c2 == ' ') {
                        if (tabIndent > 0) {
                            tabIndent = 0;
                            spaceIndent = 0;
                            mixed = true;
                            continue;
                        }
                        ++spaceIndent;
                        continue;
                    }
                    if (!Character.isWhitespace(c2)) continue;
                    if (spaceIndent > 0) {
                        tabIndent = 0;
                        spaceIndent = 0;
                        break;
                    }
                    ++tabIndent;
                }
                frequencies.spaceIndentFrequencies.merge(spaceIndent, 1L, Long::sum);
                frequencies.tabIndentFrequencies.merge(tabIndent, 1L, Long::sum);
                AtomicBoolean dropWhile = new AtomicBoolean(false);
                takeWhile.set(true);
                Map indentTypeCounts = prefix.chars().filter(c -> {
                    dropWhile.set(dropWhile.get() || c != 10 && c != 13);
                    return dropWhile.get();
                }).filter(c -> {
                    takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                    return takeWhile.get();
                }).mapToObj(c -> c == 32).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                if (indentTypeCounts.getOrDefault(true, 0L) >= indentTypeCounts.getOrDefault(false, 0L)) {
                    frequencies.linesWithSpaceIndents++;
                } else {
                    frequencies.linesWithTabIndents++;
                }
            }
        }
    }

    private static class FindLineFormatJavaVisitor
    extends XmlVisitor<GeneralFormatStatistics> {
        private FindLineFormatJavaVisitor() {
        }

        public @Nullable Xml visit(@Nullable Tree tree, GeneralFormatStatistics stats) {
            if (tree instanceof Xml) {
                String prefix = ((Xml)tree).getPrefix();
                char[] chars = prefix.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c != '\n' && c != '\r' || c != '\n') continue;
                    if (i == 0 || chars[i - 1] != '\r') {
                        stats.linesWithLFNewLines++;
                        continue;
                    }
                    stats.linesWithCRLFNewLines++;
                }
            }
            return (Xml)super.visit(tree, (Object)stats);
        }
    }

    private static class IndentFrequencies {
        private final Map<Integer, Long> spaceIndentFrequencies = new HashMap<Integer, Long>();
        private final Map<Integer, Long> tabIndentFrequencies = new HashMap<Integer, Long>();
        private int linesWithSpaceIndents = 0;
        private int linesWithTabIndents = 0;

        private IndentFrequencies() {
        }

        public boolean isIndentedWithSpaces() {
            return this.linesWithSpaceIndents >= this.linesWithTabIndents;
        }

        public boolean hasEnoughSamples() {
            return this.linesWithSpaceIndents + this.linesWithTabIndents > 1;
        }

        private TabsAndIndentsStyle getTabsAndIndentsStyle() {
            boolean useTabs = !this.isIndentedWithSpaces();
            int indent = TabsAndIndentsStyle.DEFAULT.getIndentSize();
            long indentCount = 0L;
            Map<Integer, Long> indentFrequencies = useTabs ? this.tabIndentFrequencies : this.spaceIndentFrequencies;
            for (Map.Entry<Integer, Long> current : indentFrequencies.entrySet()) {
                if (current.getKey() == 0) continue;
                long currentCount = 0L;
                for (Map.Entry<Integer, Long> candidate : indentFrequencies.entrySet()) {
                    if (candidate.getKey() == 0 || candidate.getKey() % current.getKey() != 0) continue;
                    currentCount += candidate.getValue().longValue();
                }
                if (currentCount > indentCount) {
                    indent = current.getKey();
                    indentCount = currentCount;
                    continue;
                }
                if (currentCount != indentCount) continue;
                indent = Math.min(indent, current.getKey());
            }
            return new TabsAndIndentsStyle(useTabs, useTabs ? indent : 1, useTabs ? 1 : indent, useTabs ? 2 : indent * 2);
        }
    }

    private static class IndentStatistics {
        IndentFrequencies indentFrequencies = new IndentFrequencies();
        IndentFrequencies continuationIndentFrequencies = new IndentFrequencies();

        private IndentStatistics() {
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            TabsAndIndentsStyle style = this.indentFrequencies.getTabsAndIndentsStyle();
            return this.continuationIndentFrequencies.hasEnoughSamples() ? style.withContinuationIndentSize(this.continuationIndentFrequencies.getTabsAndIndentsStyle().getIndentSize()) : style;
        }
    }
}

