/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.xml.search.FindTags;
import org.openrewrite.xml.trait.Namespaced;
import org.openrewrite.xml.tree.Xml;

public class XPathMatcher {
    private static final Pattern XPATH_ELEMENT_SPLITTER = Pattern.compile("((?<=/)(?=/)|[^/\\[]|\\[[^]]*])+");
    private static final Pattern ELEMENT_WITH_CONDITION_PATTERN = Pattern.compile("(@)?([-:\\w]+|\\*)(\\[.+])");
    private static final Pattern CONDITION_PATTERN = Pattern.compile("(\\[.*?])+?");
    private static final Pattern CONDITION_CONJUNCTION_PATTERN = Pattern.compile("(((local-name|namespace-uri)\\(\\)|(@)?([-\\w:]+|\\*))='(.*?)'(\\h?(or|and)\\h?)?)+?");
    private final String expression;
    private final boolean startsWithSlash;
    private final boolean startsWithDoubleSlash;
    private final String[] parts;
    private final long tagMatchingParts;

    public XPathMatcher(String expression) {
        this.expression = expression;
        this.startsWithSlash = expression.startsWith("/");
        this.startsWithDoubleSlash = expression.startsWith("//");
        this.parts = this.splitOnXPathSeparator(expression.substring(this.startsWithDoubleSlash ? 2 : (this.startsWithSlash ? 1 : 0)));
        this.tagMatchingParts = Arrays.stream(this.parts).filter(part -> !part.isEmpty() && !part.startsWith("@")).count();
    }

    private String[] splitOnXPathSeparator(String input) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m = XPATH_ELEMENT_SPLITTER.matcher(input);
        while (m.find()) {
            matches.add(m.group());
        }
        return matches.toArray(new String[0]);
    }

    public boolean matches(Cursor cursor) {
        ArrayList<Xml.Tag> path = new ArrayList<Xml.Tag>();
        for (Cursor c = cursor; c != null; c = c.getParent()) {
            if (!(c.getValue() instanceof Xml.Tag)) continue;
            path.add((Xml.Tag)c.getValue());
        }
        if (this.startsWithDoubleSlash || !this.startsWithSlash) {
            int pathIndex = 0;
            int i = this.parts.length - 1;
            while (i >= 0) {
                String partName;
                Matcher matcher;
                String part = this.parts[i];
                String partWithCondition = null;
                Xml.Tag tagForCondition = null;
                boolean conditionIsBefore = false;
                if (part.endsWith("]") && i < path.size()) {
                    int index = part.indexOf("[");
                    if (index < 0) {
                        return false;
                    }
                    partWithCondition = part;
                    tagForCondition = (Xml.Tag)path.get(pathIndex);
                } else if (i < path.size() && i > 0 && this.parts[i - 1].endsWith("]")) {
                    String partBefore = this.parts[i - 1];
                    int index = partBefore.indexOf("[");
                    if (index < 0) {
                        return false;
                    }
                    if (!partBefore.contains("@")) {
                        conditionIsBefore = true;
                        partWithCondition = partBefore;
                        tagForCondition = (Xml.Tag)path.get(this.parts.length - i);
                    }
                } else if (part.endsWith(")")) {
                    throw new UnsupportedOperationException("XPath methods are not supported");
                }
                boolean matchedCondition = false;
                if (tagForCondition != null && partWithCondition.endsWith("]") && (matcher = ELEMENT_WITH_CONDITION_PATTERN.matcher(partWithCondition)).matches()) {
                    String optionalPartName = this.matchesElementWithConditionFunction(matcher, tagForCondition, cursor);
                    if (optionalPartName == null) {
                        return false;
                    }
                    partName = optionalPartName;
                    matchedCondition = true;
                } else {
                    partName = null;
                }
                if (part.startsWith("@")) {
                    if (!matchedCondition) {
                        if (!(cursor.getValue() instanceof Xml.Attribute)) {
                            return false;
                        }
                        Xml.Attribute attribute = (Xml.Attribute)cursor.getValue();
                        if (!attribute.getKeyAsString().equals(part.substring(1)) && !"*".equals(part.substring(1))) {
                            return false;
                        }
                    }
                    --pathIndex;
                } else {
                    boolean conditionNotFulfilled = tagForCondition == null || !part.equals(partName) && !tagForCondition.getName().equals(partName);
                    int idx = part.indexOf("[");
                    if (idx > 0) {
                        part = part.substring(0, idx);
                    }
                    if (path.size() < i + 1 || !((Xml.Tag)path.get(pathIndex)).getName().equals(part) && !"*".equals(part) || conditionIsBefore && conditionNotFulfilled) {
                        return false;
                    }
                }
                --i;
                ++pathIndex;
            }
            return true;
        }
        Collections.reverse(path);
        if (this.expression.contains("//") && Arrays.stream(this.parts).anyMatch(StringUtils::isBlank)) {
            int blankPartIndex = Arrays.asList(this.parts).indexOf("");
            int doubleSlashIndex = this.expression.indexOf("//");
            if (path.size() > blankPartIndex && (long)path.size() >= this.tagMatchingParts) {
                Xml.Tag blankPartTag = (Xml.Tag)path.get(blankPartIndex);
                String part = this.parts[blankPartIndex + 1];
                Matcher matcher = ELEMENT_WITH_CONDITION_PATTERN.matcher(part);
                if ((matcher.matches() ? this.matchesElementWithConditionFunction(matcher, blankPartTag, cursor) != null : Objects.equals(blankPartTag.getName(), part)) && this.matchesWithoutDoubleSlashesAt(cursor, doubleSlashIndex)) {
                    return true;
                }
                String newExpression = String.format("%s/%s//%s", this.expression.substring(0, doubleSlashIndex), blankPartTag.getName(), this.expression.substring(doubleSlashIndex + 2));
                return new XPathMatcher(newExpression).matches(cursor);
            }
            if ((long)path.size() == this.tagMatchingParts) {
                return this.matchesWithoutDoubleSlashesAt(cursor, doubleSlashIndex);
            }
        }
        if (this.tagMatchingParts > (long)path.size()) {
            return false;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            String partName;
            Matcher matcher;
            String part = this.parts[i];
            int isAttr = part.startsWith("@") ? 1 : 0;
            Xml.Tag tag = i - isAttr < path.size() ? (Xml.Tag)path.get(i - isAttr) : null;
            boolean matchedCondition = false;
            if (tag != null && part.endsWith("]") && (matcher = ELEMENT_WITH_CONDITION_PATTERN.matcher(part)).matches()) {
                String optionalPartName = this.matchesElementWithConditionFunction(matcher, tag, cursor);
                if (optionalPartName == null) {
                    return false;
                }
                partName = optionalPartName;
                matchedCondition = true;
            } else {
                partName = part;
            }
            if (part.startsWith("@")) {
                if (matchedCondition) {
                    return true;
                }
                return cursor.getValue() instanceof Xml.Attribute && (((Xml.Attribute)cursor.getValue()).getKeyAsString().equals(part.substring(1)) || "*".equals(part.substring(1)));
            }
            if (path.size() >= i + 1 && (tag == null || tag.getName().equals(partName) || partName.equals("*") || "*".equals(part))) continue;
            return false;
        }
        return cursor.getValue() instanceof Xml.Tag && path.size() == this.parts.length;
    }

    private boolean matchesWithoutDoubleSlashesAt(Cursor cursor, int doubleSlashIndex) {
        String newExpression = String.format("%s/%s", this.expression.substring(0, doubleSlashIndex), this.expression.substring(doubleSlashIndex + 2));
        return new XPathMatcher(newExpression).matches(cursor);
    }

    private @Nullable String matchesElementWithConditionFunction(Matcher matcher, Xml.Tag tag, Cursor cursor) {
        boolean isAttributeElement = matcher.group(1) != null;
        String element = matcher.group(2);
        String allConditions = matcher.group(3);
        if (!(isAttributeElement || tag.getName().equals(element) || "*".equals(element))) {
            return null;
        }
        Matcher conditions = CONDITION_PATTERN.matcher(allConditions);
        boolean stillMatchesConditions = true;
        block0: while (conditions.find() && stillMatchesConditions) {
            String conditionGroup = conditions.group(1);
            Matcher condition = CONDITION_CONJUNCTION_PATTERN.matcher(conditionGroup);
            boolean orCondition = false;
            while (condition.find() && (stillMatchesConditions || orCondition)) {
                boolean matchCurrentCondition = false;
                boolean isAttributeCondition = condition.group(4) != null;
                String selector = isAttributeCondition ? condition.group(5) : condition.group(2);
                boolean isFunctionCondition = selector.endsWith("()");
                String value = condition.group(6);
                String conjunction = condition.group(8);
                boolean bl = orCondition = conjunction != null && conjunction.equals("or");
                if (!orCondition && conjunction != null && !conjunction.equals("and")) {
                    stillMatchesConditions = false;
                    continue block0;
                }
                if (isAttributeCondition) {
                    for (Xml.Attribute a : tag.getAttributes()) {
                        if (!a.getKeyAsString().equals(selector) && !"*".equals(selector) || !a.getValueAsString().equals(value)) continue;
                        matchCurrentCondition = true;
                        break;
                    }
                } else if (isFunctionCondition) {
                    if (isAttributeElement) {
                        for (Xml.Attribute a : tag.getAttributes()) {
                            if (!XPathMatcher.matchesElementAndFunction(new Cursor(cursor, (Object)a), element, selector, value)) continue;
                            matchCurrentCondition = true;
                            break;
                        }
                    } else {
                        matchCurrentCondition = XPathMatcher.matchesElementAndFunction(cursor, element, selector, value);
                    }
                } else {
                    for (Xml.Tag t : FindTags.find(tag, selector)) {
                        if (!t.getValue().map(v -> v.equals(value)).orElse(false).booleanValue()) continue;
                        matchCurrentCondition = true;
                        break;
                    }
                }
                if (matchCurrentCondition && orCondition) continue block0;
                stillMatchesConditions = matchCurrentCondition;
            }
        }
        return stillMatchesConditions ? element : null;
    }

    private static boolean matchesElementAndFunction(Cursor cursor, String element, String selector, String value) {
        Namespaced namespaced = new Namespaced(cursor);
        if (!element.equals("*") && !Objects.equals(namespaced.getName().orElse(null), element)) {
            return false;
        }
        if (selector.equals("local-name()")) {
            return Objects.equals(namespaced.getLocalName().orElse(null), value);
        }
        if (selector.equals("namespace-uri()")) {
            Optional<String> nsUri = namespaced.getNamespaceUri();
            return nsUri.isPresent() && nsUri.get().equals(value);
        }
        return false;
    }
}

