/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.wlactions;

import java.security.AccessController;
import java.security.Permission;
import openwfe.org.ApplicationContext;
import openwfe.org.auth.actions.OwfeAction;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.worklist.auth.LaunchPermission;
import org.apache.log4j.Logger;

public class LaunchAction
extends OwfeAction {
    private static final Logger log = Logger.getLogger((String)LaunchAction.class.getName());

    protected String getEngineId() {
        return (String)this.getArgs()[0];
    }

    protected LaunchItem getLaunchItem() {
        return (LaunchItem)this.getArgs()[1];
    }

    public Object run() throws DispatchingException {
        if (this.getLaunchItem().getWorkflowDefinitionUrl() == null) {
            throw new DispatchingException("LaunchItem with workflowDefinitionUrl field not set. Cannot launch.");
        }
        AccessController.checkPermission((Permission)LaunchPermission.newLaunchPermission((String)this.determinePermissionName()));
        ParticipantMap pMap = Definitions.getParticipantMap((ApplicationContext)this.getContext());
        Participant p = pMap.get(this.getEngineId());
        if (p == null) {
            throw new DispatchingException("Cannot launch flow on unknown engine '" + this.getEngineId() + "'");
        }
        return p.dispatch(this.getContext(), (WorkItem)this.getLaunchItem());
    }

    protected String determinePermissionName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getEngineId());
        sb.append("::");
        sb.append(this.getLaunchItem().getWorkflowDefinitionUrl());
        return sb.toString();
    }
}

