/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.servlet;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.servlet.ContainerTestRunnerClassRequest;
import org.ops4j.pax.exam.util.Injector;
import org.ops4j.pax.exam.util.InjectorFactory;
import org.ops4j.spi.ServiceProviderFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/testrunner"})
public class TestRunnerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(TestRunnerServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        log.info("TestRunnerServlet loaded");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String className = request.getParameter("class");
        String methodName = request.getParameter("method");
        String indexName = request.getParameter("index");
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            response.setContentType("application/octet-stream");
            ServletOutputStream os = response.getOutputStream();
            this.runSuite((OutputStream)os, clazz, methodName, indexName);
            os.flush();
        }
        catch (ClassNotFoundException exc) {
            throw new ServletException("cannot load test class " + className, (Throwable)exc);
        }
    }

    private void runSuite(OutputStream os, Class<?> clazz, String methodName, String indexName) throws IOException {
        InjectorFactory injectorFactory = (InjectorFactory)ServiceProviderFinder.loadUniqueServiceProvider(InjectorFactory.class);
        injectorFactory.setContext((Object)this.getServletContext());
        Injector injector = injectorFactory.createInjector();
        Integer index = null;
        if (indexName != null) {
            index = Integer.parseInt(indexName);
        }
        ContainerTestRunnerClassRequest classRequest = new ContainerTestRunnerClassRequest(clazz, injector, index);
        Description method = Description.createTestDescription(clazz, (String)methodName);
        Request request = classRequest.filterWith(method);
        JUnitCore core = new JUnitCore();
        Result result = core.run(request);
        List failures = result.getFailures();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        for (Failure failure : failures) {
            TestContainerException exc = new TestContainerException(failure.getTrace());
            oos.writeObject(exc);
        }
        if (failures.isEmpty()) {
            oos.writeObject("ok");
        }
    }
}

