/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ServiceLoader;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.spi.DefaultExamSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaxExamRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(PaxExamRuntime.class);
    private static final String TESTCONTAINER_FACTORY = "META-INF/services/org.ops4j.pax.exam.TestContainerFactory";

    public static TestContainerFactory getTestContainerFactory() {
        PaxExamRuntime.sanityCheck();
        TestContainerFactory factory = ServiceLoader.load(TestContainerFactory.class).iterator().next();
        LOG.debug("Found TestContainerFactory: " + (factory != null ? factory.getClass().getName() : "<NONE>"));
        return factory;
    }

    public static TestContainer createContainer(ExamSystem system) {
        return PaxExamRuntime.getTestContainerFactory().create(system)[0];
    }

    public static ExamSystem createTestSystem(Option ... options) throws IOException {
        return DefaultExamSystem.create(OptionUtils.combine((Option[])options, (Option[])PaxExamRuntime.defaultTestSystemOptions()));
    }

    public static ExamSystem createServerSystem(Option ... options) throws IOException {
        return DefaultExamSystem.create(OptionUtils.combine((Option[])options, (Option[])PaxExamRuntime.defaultServerSystemOptions()));
    }

    private static Option[] defaultTestSystemOptions() {
        return new Option[]{CoreOptions.bootDelegationPackage((String)"sun.*"), CoreOptions.frameworkStartLevel((int)5), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.exam.rbc.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.extender.service.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.osgi.compendium.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.logging.api.link").startLevel(Integer.valueOf(2))};
    }

    private static Option[] defaultServerSystemOptions() {
        return new Option[]{CoreOptions.bootDelegationPackage((String)"sun.*"), CoreOptions.serverMode()};
    }

    public static TestContainerFactory getTestContainerFactory(Class<? extends TestContainerFactory> select) {
        try {
            return select.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class  " + select + "is not a valid Test Container Factory.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class  " + select + "is not a valid Test Container Factory.", e);
        }
    }

    private static void sanityCheck() {
        try {
            ArrayList<URL> factories = new ArrayList<URL>();
            Enumeration<URL> systemResources = ClassLoader.getSystemResources(TESTCONTAINER_FACTORY);
            while (systemResources.hasMoreElements()) {
                factories.add(systemResources.nextElement());
            }
            if (factories.size() == 0) {
                throw new TestContainerException("No TestContainer implementation in Classpath.. ");
            }
            if (factories.size() > 1) {
                for (URL fac : factories) {
                    LOG.error("Ambiquous TestContainer:  " + fac.toExternalForm());
                }
                throw new TestContainerException("Too many TestContainer implementations in Classpath.. ");
            }
            return;
        }
        catch (IOException e) {
            throw new TestContainerException("Problem looking for TestContainerFactory descriptors in Classpath.. ", (Throwable)e);
        }
    }
}

