/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.intern;

import java.io.File;
import java.io.IOException;

public class ClassSourceFolder {
    private final File m_base;

    ClassSourceFolder(File base) {
        this.m_base = base;
    }

    public File find(Class clazz) throws IOException {
        return this.findParentOfTail(this.m_base, this.convert(clazz));
    }

    private String convert(Class c) {
        return c.getName().replace(".", "/") + ".class";
    }

    protected File findParentOfTail(File folder, String tail) throws IOException {
        for (File f : folder.listFiles()) {
            String p;
            if (!f.isHidden() && f.isDirectory()) {
                File r = this.findParentOfTail(f, tail);
                if (r == null) continue;
                return r;
            }
            if (f.isHidden() || !(p = f.getCanonicalPath().replaceAll("\\\\", "/")).endsWith(tail)) continue;
            return new File(f.getCanonicalPath().substring(0, f.getCanonicalPath().length() - tail.length()));
        }
        return null;
    }
}

