/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.intern;

import java.util.UUID;
import org.ops4j.pax.exam.TestAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTestAddress
implements TestAddress {
    private static Logger LOG = LoggerFactory.getLogger(DefaultTestAddress.class);
    private final String m_sig = this.calculate();
    private final TestAddress m_root;
    private final String m_caption;
    private final Object[] m_args;

    public DefaultTestAddress(String caption, Object ... args) {
        this(null, caption, args);
    }

    public DefaultTestAddress(TestAddress parent, String caption, Object ... args) {
        if (parent != null) {
            this.m_caption = parent.caption() + ":" + caption;
            this.m_args = parent.arguments();
        } else {
            this.m_caption = caption;
            this.m_args = args;
        }
        this.m_root = this.calculateRoot(parent);
        LOG.debug("NEW ADDRESS= " + this.m_sig + " parent=" + parent + " root=" + this.m_root + " args=" + args.toString());
    }

    private String calculate() {
        return "PaxExam-" + UUID.randomUUID().toString();
    }

    public int hashCode() {
        return this.m_sig.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TestAddress) {
            return o.equals(this.m_sig);
        }
        return false;
    }

    public String identifier() {
        return this.m_sig;
    }

    public String caption() {
        return this.m_caption;
    }

    private TestAddress calculateRoot(TestAddress parent) {
        if (parent != null) {
            return parent.root();
        }
        return this;
    }

    public TestAddress root() {
        return this.m_root;
    }

    public Object[] arguments() {
        return this.m_args;
    }

    public String toString() {
        return "[TestAddress:" + this.m_sig + " root:" + this.m_root.identifier() + "]";
    }
}

