/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.intern;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestInstantiationInstruction;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.TestProbeProvider;
import org.ops4j.pax.exam.spi.ContentCollector;
import org.ops4j.pax.exam.spi.intern.CollectFromBase;
import org.ops4j.pax.exam.spi.intern.CollectFromItems;
import org.ops4j.pax.exam.spi.intern.CompositeCollector;
import org.ops4j.pax.exam.spi.intern.DefaultTestAddress;
import org.ops4j.pax.exam.spi.intern.DefaultTestProbeProvider;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.ops4j.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProbeBuilderImpl
implements TestProbeBuilder {
    private static Logger LOG = LoggerFactory.getLogger(TestProbeBuilderImpl.class);
    private static final String DEFAULT_PROBE_METHOD_NAME = "probe";
    private final Map<TestAddress, TestInstantiationInstruction> m_probeCalls = new HashMap<TestAddress, TestInstantiationInstruction>();
    private final List<Class> m_anchors;
    private final Properties m_extraProperties;
    private final Set<String> m_ignorePackages = new HashSet<String>();
    private final Store<InputStream> m_store;

    public TestProbeBuilderImpl(Store<InputStream> store) throws IOException {
        this.m_anchors = new ArrayList<Class>();
        this.m_store = store;
        this.m_extraProperties = new Properties();
    }

    public TestAddress addTest(Class clazz, String methodName, Object ... args) {
        DefaultTestAddress address = new DefaultTestAddress(clazz.getName() + "." + methodName, args);
        this.m_probeCalls.put(address, new TestInstantiationInstruction(clazz.getName() + ";" + methodName));
        this.addAnchor(clazz);
        return address;
    }

    public TestAddress addTest(Class clazz, Object ... args) {
        return this.addTest(clazz, DEFAULT_PROBE_METHOD_NAME, args);
    }

    public List<TestAddress> addTests(Class clazz, Method ... methods) {
        ArrayList<TestAddress> list = new ArrayList<TestAddress>();
        for (Method method : methods) {
            list.add(this.addTest(clazz, method.getName(), new Object[0]));
        }
        return list;
    }

    public TestProbeBuilder addAnchor(Class clazz) {
        this.m_anchors.add(clazz);
        return this;
    }

    public TestProbeBuilder setHeader(String key, String value) {
        this.m_extraProperties.put(key, value);
        return this;
    }

    public TestProbeBuilder ignorePackageOf(Class ... classes) {
        for (Class c : classes) {
            this.m_ignorePackages.add(c.getPackage().getName());
        }
        return this;
    }

    public TestProbeProvider build() {
        if (this.m_anchors.size() == 0) {
            throw new TestContainerException("No tests added to setup!");
        }
        this.constructProbeTag(this.m_extraProperties);
        try {
            TinyBundle bundle = this.prepareProbeBundle(this.createExtraIgnores());
            return new DefaultTestProbeProvider(this.getTests(), this.m_store, this.m_store.store((Object)bundle.build(TinyBundles.withClassicBuilder())));
        }
        catch (IOException e) {
            throw new TestContainerException((Throwable)e);
        }
    }

    private TinyBundle prepareProbeBundle(Properties p) throws IOException {
        TinyBundle bundle = TinyBundles.bundle(this.m_store).set("DynamicImport-Package", "*");
        bundle.set("Bundle-SymbolicName", "");
        for (Object key : this.m_extraProperties.keySet()) {
            bundle.set((String)key, (String)this.m_extraProperties.get(key));
        }
        for (Object key : p.keySet()) {
            bundle.set((String)key, (String)p.get(key));
        }
        Map<String, URL> map = this.collectResources();
        for (String item : map.keySet()) {
            bundle.add(item, map.get(item));
        }
        return bundle;
    }

    private Map<String, URL> collectResources() throws IOException {
        ContentCollector collector = this.selectCollector();
        HashMap<String, URL> map = new HashMap<String, URL>();
        collector.collect(map);
        return map;
    }

    static String convertClassToPath(Class c) {
        return c.getName().replace(".", File.separator) + ".class";
    }

    public static File findClassesFolder(Class clazz) throws IOException {
        String clazzPath;
        ClassLoader classLoader = clazz.getClassLoader();
        URL url = classLoader.getResource(clazzPath = TestProbeBuilderImpl.convertClassToPath(clazz));
        if (url == null || !"file".equals(url.getProtocol())) {
            return null;
        }
        try {
            File file = new File(url.toURI());
            String fullPath = file.getCanonicalPath();
            String parentDirPath = fullPath.substring(0, fullPath.length() - clazzPath.length());
            return new File(parentDirPath);
        }
        catch (URISyntaxException e) {
            throw new TestContainerException((Throwable)e);
        }
    }

    private ContentCollector selectCollector() throws IOException {
        File root = TestProbeBuilderImpl.findClassesFolder(this.m_anchors.get(0));
        if (root != null) {
            return new CompositeCollector(new CollectFromBase(root), new CollectFromItems(this.m_anchors));
        }
        return new CollectFromItems(this.m_anchors);
    }

    private TestAddress[] getTests() {
        return this.m_probeCalls.keySet().toArray(new TestAddress[this.m_probeCalls.size()]);
    }

    private Properties createExtraIgnores() {
        Properties extraProperties = new Properties();
        StringBuilder sb = new StringBuilder();
        for (String p : this.m_ignorePackages) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p);
        }
        extraProperties.put("Ignore-Package", sb.toString());
        return extraProperties;
    }

    private void constructProbeTag(Properties p) {
        StringBuilder sbKeyChain = new StringBuilder();
        for (TestAddress address : this.m_probeCalls.keySet()) {
            sbKeyChain.append(address.identifier());
            sbKeyChain.append(",");
            p.put(address.identifier(), this.m_probeCalls.get(address).toString());
        }
        p.put("PaxExam-Executable", sbKeyChain.toString());
    }
}

