/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.intern;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestInstantiationInstruction;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.TestProbeProvider;
import org.ops4j.pax.exam.spi.ContentCollector;
import org.ops4j.pax.exam.spi.intern.CollectFromBase;
import org.ops4j.pax.exam.spi.intern.CollectFromItems;
import org.ops4j.pax.exam.spi.intern.CompositeCollector;
import org.ops4j.pax.exam.spi.intern.DefaultTestAddress;
import org.ops4j.pax.exam.spi.intern.DefaultTestProbeProvider;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.ops4j.store.Store;

public class TestProbeBuilderImpl
implements TestProbeBuilder {
    private static final String DEFAULT_PROBE_METHOD_NAME = "probe";
    private final Map<TestAddress, TestInstantiationInstruction> probeCalls = new LinkedHashMap<TestAddress, TestInstantiationInstruction>();
    private final List<Class<?>> anchors;
    private final Properties extraProperties;
    private final Set<String> ignorePackages = new HashSet<String>();
    private final Store<InputStream> store;

    public TestProbeBuilderImpl(Store<InputStream> store) throws IOException {
        this.anchors = new ArrayList();
        this.store = store;
        this.extraProperties = new Properties();
    }

    public TestAddress addTest(Class<?> clazz, String methodName, Object ... args) {
        DefaultTestAddress address = new DefaultTestAddress(clazz.getName() + "." + methodName, args);
        this.probeCalls.put(address, new TestInstantiationInstruction(clazz.getName() + ";" + methodName));
        this.addAnchor(clazz);
        return address;
    }

    public TestAddress addTest(Class<?> clazz, Object ... args) {
        return this.addTest(clazz, DEFAULT_PROBE_METHOD_NAME, args);
    }

    public List<TestAddress> addTests(Class<?> clazz, Method ... methods) {
        ArrayList<TestAddress> list = new ArrayList<TestAddress>();
        for (Method method : methods) {
            list.add(this.addTest(clazz, method.getName(), new Object[0]));
        }
        return list;
    }

    public TestProbeBuilder addAnchor(Class<?> clazz) {
        this.anchors.add(clazz);
        return this;
    }

    public TestProbeBuilder setHeader(String key, String value) {
        this.extraProperties.put(key, value);
        return this;
    }

    public TestProbeBuilder ignorePackageOf(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this.ignorePackages.add(c.getPackage().getName());
        }
        return this;
    }

    public TestProbeProvider build() {
        if (this.anchors.size() == 0) {
            throw new TestContainerException("No tests added to setup!");
        }
        this.constructProbeTag(this.extraProperties);
        try {
            TinyBundle bundle = this.prepareProbeBundle(this.createExtraIgnores());
            return new DefaultTestProbeProvider(this.getTests(), this.store, this.store.store((Object)bundle.build(TinyBundles.withClassicBuilder())));
        }
        catch (IOException e) {
            throw new TestContainerException((Throwable)e);
        }
    }

    private TinyBundle prepareProbeBundle(Properties p) throws IOException {
        TinyBundle bundle = TinyBundles.bundle(this.store).set("DynamicImport-Package", "*");
        bundle.set("Bundle-SymbolicName", "");
        bundle.set("Bundle-ManifestVersion", "2");
        for (Object key : this.extraProperties.keySet()) {
            bundle.set((String)key, (String)this.extraProperties.get(key));
        }
        for (Object key : p.keySet()) {
            bundle.set((String)key, (String)p.get(key));
        }
        Map<String, URL> map = this.collectResources();
        for (String item : map.keySet()) {
            bundle.add(item, map.get(item));
        }
        return bundle;
    }

    private Map<String, URL> collectResources() throws IOException {
        ContentCollector collector = this.selectCollector();
        HashMap<String, URL> map = new HashMap<String, URL>();
        collector.collect(map);
        return map;
    }

    static String convertClassToPath(Class<?> c) {
        return c.getName().replace(".", File.separator) + ".class";
    }

    public static File findClassesFolder(Class<?> clazz) throws IOException {
        String clazzPath;
        ClassLoader classLoader = clazz.getClassLoader();
        URL url = classLoader.getResource(clazzPath = TestProbeBuilderImpl.convertClassToPath(clazz));
        if (url == null || !"file".equals(url.getProtocol())) {
            return null;
        }
        try {
            File file = new File(url.toURI());
            String fullPath = file.getCanonicalPath();
            String parentDirPath = fullPath.substring(0, fullPath.length() - clazzPath.length());
            return new File(parentDirPath);
        }
        catch (URISyntaxException e) {
            throw new TestContainerException((Throwable)e);
        }
    }

    private ContentCollector selectCollector() throws IOException {
        File root = TestProbeBuilderImpl.findClassesFolder(this.anchors.get(0));
        if (root != null) {
            return new CompositeCollector(new CollectFromBase(root), new CollectFromItems(this.anchors));
        }
        return new CollectFromItems(this.anchors);
    }

    public Set<TestAddress> getTests() {
        return this.probeCalls.keySet();
    }

    private Properties createExtraIgnores() {
        Properties properties = new Properties();
        StringBuilder sb = new StringBuilder();
        for (String p : this.ignorePackages) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p);
        }
        properties.put("Ignore-Package", sb.toString());
        return properties;
    }

    private void constructProbeTag(Properties p) {
        StringBuilder sbKeyChain = new StringBuilder();
        for (TestAddress address : this.probeCalls.keySet()) {
            sbKeyChain.append(address.identifier());
            sbKeyChain.append(",");
            p.put(address.identifier(), this.probeCalls.get(address).toString());
        }
        p.put("PaxExam-Executable", sbKeyChain.toString());
    }
}

