/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.war;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Arrays;

public class FileFinder {
    private static FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    private FileFinder() {
    }

    public static File findFile(File rootDir, final String fileName) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(fileName);
            }
        };
        return FileFinder.findFile(rootDir, filter);
    }

    public static File findFile(File rootDir, FilenameFilter filter) {
        Object[] files = rootDir.listFiles(filter);
        Arrays.sort(files);
        if (files.length > 0) {
            return files[0];
        }
        files = rootDir.listFiles(directoryFilter);
        Arrays.sort(files);
        for (Object subDir : files) {
            File found = FileFinder.findFile((File)subDir, filter);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

