/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.ConfigurationManager;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.spi.DefaultExamSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxExamRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(PaxExamRuntime.class);

    private PaxExamRuntime() {
    }

    public static TestContainerFactory getTestContainerFactory() {
        PaxExamRuntime.sanityCheck();
        TestContainerFactory factory = ServiceLoader.load(TestContainerFactory.class).iterator().next();
        LOG.debug("Found TestContainerFactory: " + (factory != null ? factory.getClass().getName() : "<NONE>"));
        return factory;
    }

    public static TestContainer createContainer(ExamSystem system) {
        return PaxExamRuntime.getTestContainerFactory().create(system)[0];
    }

    public static TestContainer createContainer(String configurationClassName) throws Exception {
        Option[] options = PaxExamRuntime.getConfigurationOptions(configurationClassName);
        ExamSystem system = DefaultExamSystem.create(options);
        TestContainer testContainer = PaxExamRuntime.createContainer(system);
        testContainer.start();
        return testContainer;
    }

    private static void waitForStop(TestContainer testContainer, int localPort) {
        try {
            ServerSocket serverSocket = new ServerSocket(localPort);
            Socket socket = serverSocket.accept();
            InputStreamReader isr = new InputStreamReader(socket.getInputStream(), "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            OutputStream os = socket.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(os, "UTF-8");
            PrintWriter pw = new PrintWriter((Writer)writer, true);
            boolean running = true;
            while (running) {
                String command = reader.readLine();
                LOG.debug("command = {}", (Object)command);
                if (command.equals("stop")) {
                    testContainer.stop();
                    pw.println("stopped");
                    writer.flush();
                    LOG.info("test container stopped");
                    continue;
                }
                if (!command.equals("quit")) continue;
                LOG.debug("quitting PaxExamRuntime");
                pw.close();
                socket.close();
                serverSocket.close();
                running = false;
            }
        }
        catch (IOException exc) {
            LOG.debug("socket error", (Throwable)exc);
        }
    }

    private static Option[] getConfigurationOptions(String configurationClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> klass = Class.forName(configurationClassName, true, PaxExamRuntime.class.getClassLoader());
        Method m = PaxExamRuntime.getConfigurationMethod(klass);
        Object configClassInstance = klass.newInstance();
        Option[] options = (Option[])m.invoke(configClassInstance, new Object[0]);
        return options;
    }

    private static Method getConfigurationMethod(Class<?> klass) {
        Method[] methods;
        for (Method m : methods = klass.getMethods()) {
            Configuration conf = m.getAnnotation(Configuration.class);
            if (conf == null) continue;
            return m;
        }
        throw new IllegalArgumentException(klass.getName() + " has no @Configuration method");
    }

    public static ExamSystem createTestSystem(Option ... options) throws IOException {
        return DefaultExamSystem.create(OptionUtils.combine((Option[])options, (Option[])PaxExamRuntime.defaultTestSystemOptions()));
    }

    public static ExamSystem createServerSystem(Option ... options) throws IOException {
        return DefaultExamSystem.create(OptionUtils.combine((Option[])options, (Option[])PaxExamRuntime.defaultServerSystemOptions()));
    }

    private static Option[] defaultTestSystemOptions() {
        ConfigurationManager cm = new ConfigurationManager();
        String logging = cm.getProperty("pax.exam.logging", "pax-logging");
        return new Option[]{CoreOptions.bootDelegationPackage((String)"sun.*"), CoreOptions.frameworkStartLevel((int)5), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.exam.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.exam.inject.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.extender.service.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.osgi.compendium.link").startLevel(Integer.valueOf(2)), CoreOptions.when((boolean)logging.equals("pax-logging")).useOptions(new Option[]{(Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.logging.api.link").startLevel(Integer.valueOf(2))}), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.base.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.core.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.extender.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.framework.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.lifecycle.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.ops4j.pax.swissbox.tracker.link").startLevel(Integer.valueOf(2)), (Option)CoreOptions.url((String)"link:classpath:META-INF/links/org.apache.geronimo.specs.atinject.link").startLevel(Integer.valueOf(2))};
    }

    private static Option[] defaultServerSystemOptions() {
        return new Option[]{CoreOptions.bootDelegationPackage((String)"sun.*"), CoreOptions.serverMode()};
    }

    public static TestContainerFactory getTestContainerFactory(Class<? extends TestContainerFactory> select) {
        try {
            return select.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class  " + select + "is not a valid Test Container Factory.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class  " + select + "is not a valid Test Container Factory.", e);
        }
    }

    private static void sanityCheck() {
        ArrayList<TestContainerFactory> factories = new ArrayList<TestContainerFactory>();
        Iterator<TestContainerFactory> iter = ServiceLoader.load(TestContainerFactory.class).iterator();
        while (iter.hasNext()) {
            factories.add(iter.next());
        }
        if (factories.size() == 0) {
            throw new TestContainerException("No TestContainer implementation in Classpath");
        }
        if (factories.size() > 1) {
            for (TestContainerFactory fac : factories) {
                LOG.error("Ambiguous TestContainer:  " + fac.getClass().getName());
            }
            throw new TestContainerException("Too many TestContainer implementations in Classpath");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("required arguments: <configuration class name> <shutdown port>");
        }
        TestContainer testContainer = PaxExamRuntime.createContainer(args[0]);
        PaxExamRuntime.waitForStop(testContainer, Integer.parseInt(args[1]));
    }
}

