/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.war;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ops4j.io.FileUtils;
import org.ops4j.io.StreamUtils;
import org.ops4j.io.ZipExploder;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.options.WarProbeOption;
import org.ops4j.pax.exam.spi.war.ZipBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(WarBuilder.class);
    private File tempDir;
    private WarProbeOption option;
    private Pattern filterPattern;

    public WarBuilder(File tempDir, WarProbeOption option) {
        this.option = option;
        this.tempDir = tempDir;
    }

    public URI buildWar() {
        if (this.option.getName() == null) {
            this.option.name(UUID.randomUUID().toString());
        }
        this.processClassPath();
        try {
            File webResourceDir = this.getWebResourceDir();
            File webInfClasses = new File(webResourceDir, "WEB-INF/classes");
            File probeWar = new File(this.tempDir, this.option.getName() + ".war");
            ZipBuilder builder = new ZipBuilder(probeWar);
            for (String library : this.option.getLibraries()) {
                File file = this.toLocalFile(library);
                if (file.isDirectory()) {
                    this.copyDirectory(file, webInfClasses);
                    continue;
                }
                LOG.debug("including library {} = {}", (Object)library, (Object)file);
                builder.addFile(file, "WEB-INF/lib/" + file.getName());
            }
            builder.addDirectory(webResourceDir, "");
            builder.close();
            URI warUri = probeWar.toURI();
            LOG.info("WAR probe = {}", (Object)warUri);
            return warUri;
        }
        catch (IOException exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }

    private File toLocalFile(String anyUri) throws IOException {
        URI uri = null;
        try {
            uri = new URI(anyUri);
            File file = new File(uri);
            return file;
        }
        catch (URISyntaxException exc) {
            throw new TestContainerException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            InputStream is = uri.toURL().openStream();
            File tempFile = File.createTempFile("paxexam", ".jar");
            FileOutputStream os = new FileOutputStream(tempFile);
            StreamUtils.copyStream((InputStream)is, (OutputStream)os, (boolean)true);
            return tempFile;
        }
    }

    private void processClassPath() {
        if (this.option.isClassPathEnabled()) {
            String[] pathElems;
            this.buildClassPathPattern();
            String classpath = System.getProperty("java.class.path");
            for (String pathElem : pathElems = classpath.split(File.pathSeparator)) {
                String path;
                Matcher matcher;
                File file = new File(pathElem);
                if (!file.exists() || (matcher = this.filterPattern.matcher(path = file.getAbsolutePath())).find()) continue;
                this.option.library(path);
            }
        }
    }

    private File getWebResourceDir() throws IOException {
        File webResourceDir = new File(this.tempDir, "webapp");
        LOG.debug("building webapp in {}", (Object)webResourceDir);
        ZipExploder exploder = new ZipExploder();
        webResourceDir.mkdir();
        if (this.option.getOverlays().isEmpty()) {
            this.option.overlay("src/main/webapp");
        }
        for (String overlay : this.option.getOverlays()) {
            File file = this.toFile(overlay);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                this.copyDirectory(file, webResourceDir);
                continue;
            }
            exploder.processFile(file, webResourceDir);
        }
        File metaInfDir = new File(webResourceDir, "META-INF");
        metaInfDir.mkdir();
        for (String metaInfResource : this.option.getMetaInfResources()) {
            File source = new File(metaInfResource);
            if (source.isDirectory()) {
                this.copyDirectory(source, metaInfDir);
                continue;
            }
            FileUtils.copyFile((File)source, (File)new File(metaInfDir, source.getName()), null);
        }
        File webInfDir = new File(webResourceDir, "WEB-INF");
        webInfDir.mkdir();
        for (String webInfResource : this.option.getWebInfResources()) {
            File source = new File(webInfResource);
            if (source.isDirectory()) {
                this.copyDirectory(source, webInfDir);
                continue;
            }
            FileUtils.copyFile((File)source, (File)new File(webInfDir, source.getName()), null);
        }
        File resourceDir = new File(webResourceDir, "WEB-INF/classes");
        resourceDir.mkdir();
        for (Class klass : this.option.getClasses()) {
            this.addClass(klass, resourceDir);
        }
        for (String resource : this.option.getResources()) {
            this.addResource(resource, resourceDir);
        }
        File beansXml = new File(webInfDir, "beans.xml");
        if (!beansXml.exists()) {
            beansXml.createNewFile();
        }
        return webResourceDir;
    }

    private void addClass(Class<?> klass, File resourceDir) throws IOException {
        String resource = "/" + klass.getName().replaceAll("\\.", "/") + ".class";
        this.addResource(resource, resourceDir);
        for (Class<?> innerClass : klass.getClasses()) {
            this.addClass(innerClass, resourceDir);
        }
    }

    private void addResource(String resource, File resourceDir) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/" + resource);
        File target = new File(resourceDir, resource);
        target.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(target);
        StreamUtils.copyStream((InputStream)is, (OutputStream)os, (boolean)true);
    }

    private File toFile(String uriString) {
        try {
            URI uri = new URI(uriString);
            try {
                return new File(uri);
            }
            catch (IllegalArgumentException exc) {
                InputStream is = uri.toURL().openStream();
                File tempFile = File.createTempFile("pax-exam", ".tmp");
                FileOutputStream os = new FileOutputStream(tempFile);
                StreamUtils.copyStream((InputStream)is, (OutputStream)os, (boolean)true);
                return tempFile;
            }
        }
        catch (URISyntaxException exc) {
            throw new TestContainerException((Throwable)exc);
        }
        catch (IOException exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }

    private void copyDirectory(File fromDir, File toDir) throws IOException {
        for (File file : fromDir.listFiles()) {
            if (file.isDirectory()) {
                File targetDir = new File(toDir, file.getName());
                targetDir.mkdir();
                this.copyDirectory(file, targetDir);
                continue;
            }
            FileUtils.copyFile((File)file, (File)new File(toDir, file.getName()), null);
        }
    }

    private void buildClassPathPattern() {
        List classpathFilters = this.option.getClassPathFilters();
        if (classpathFilters.isEmpty()) {
            this.filterPattern = Pattern.compile("^$");
            return;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < classpathFilters.size(); ++i) {
            if (i > 0) {
                buffer.append("|");
            }
            buffer.append("(");
            buffer.append((String)classpathFilters.get(i));
            buffer.append(")");
        }
        String disjunction = buffer.toString();
        this.filterPattern = Pattern.compile(disjunction);
    }
}

