/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;

public class CredentialsCallbackHandler
implements CallbackHandler {
    private String username;
    private String password;

    public CredentialsCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof RealmCallback) {
                RealmCallback realmCallback = (RealmCallback)callback;
                String defaultText = realmCallback.getDefaultText();
                realmCallback.setText(defaultText);
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(this.password.toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

