/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.dbcp2.impl.ds;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.ops4j.pax.jdbc.pool.common.impl.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbcpPooledDataSourceFactory
implements DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DbcpPooledDataSourceFactory.class);
    protected static final String POOL_PREFIX = "pool.";
    protected static final String FACTORY_PREFIX = "factory.";
    protected DataSourceFactory dsFactory;

    public DbcpPooledDataSourceFactory(DataSourceFactory dsFactory) {
        this.dsFactory = dsFactory;
    }

    protected Map<String, String> getPoolProps(Properties props) {
        String dsName;
        Map<String, String> poolProps = this.getPrefixed(props, POOL_PREFIX);
        if (poolProps.get("jmxNameBase") == null) {
            poolProps.put("jmxNameBase", "org.ops4j.pax.jdbc.pool.dbcp2:type=GenericObjectPool,name=");
        }
        if ((dsName = (String)props.get("dataSourceName")) != null) {
            poolProps.put("jmxNamePrefix", dsName);
        }
        return poolProps;
    }

    protected Properties getNonPoolProps(Properties props) {
        Properties dsProps = new Properties();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (key.startsWith(POOL_PREFIX) || key.startsWith(FACTORY_PREFIX)) continue;
            dsProps.put(key, props.get(key));
        }
        dsProps.remove("dataSourceName");
        return dsProps;
    }

    protected Map<String, String> getPrefixed(Properties props, String prefix) {
        HashMap<String, String> prefixedProps = new HashMap<String, String>();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (!key.startsWith(prefix)) continue;
            String strippedKey = key.substring(prefix.length());
            prefixedProps.put(strippedKey, (String)props.get(key));
        }
        return prefixedProps;
    }

    protected ObjectName getJmxName(String dsName) {
        if (dsName == null) {
            dsName = UUID.randomUUID().toString();
        }
        try {
            return new ObjectName("org.ops4j.pax.jdbc.pool", "dsName", dsName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name for data source" + dsName, e);
        }
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        try {
            DataSource ds = this.dsFactory.createDataSource(this.getNonPoolProps(props));
            DataSourceConnectionFactory connFactory = new DataSourceConnectionFactory(ds);
            PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
            GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
            BeanConfig.configure((Object)conf, this.getPoolProps(props));
            BeanConfig.configure((Object)pcf, this.getPrefixed(props, FACTORY_PREFIX));
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pcf, conf);
            pcf.setPool((ObjectPool)pool);
            return new PoolingDataSource((ObjectPool)pool);
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        throw new SQLException("Not supported");
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Driver createDriver(Properties props) throws SQLException {
        throw new SQLException("Not supported");
    }
}

