/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j1.internal;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.XMLLayout;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxLoggingConstants;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.log4j1.internal.LoggingManagedService;
import org.ops4j.pax.logging.log4j1.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.DefaultServiceLog;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.RegisteredService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogReaderService;

public class Activator
implements BundleActivator {
    private ServiceRegistration<?> m_RegistrationPaxLogging;
    private PaxLoggingServiceImpl m_PaxLogging;
    private RegisteredService<LogReaderService, LogReaderServiceImpl> logReaderInfo;
    private RegisteredService<EventAdminPoster, EventAdminPoster> eventAdminInfo;
    private RegisteredService<ConfigurationNotifier, ConfigurationNotifier> eventAdminConfigurationNotifierInfo;

    public void start(BundleContext bundleContext) throws Exception {
        Hashtable<String, Object> serviceProperties;
        this.sanityCheck();
        String levelName = BackendSupport.defaultLogLevel(bundleContext);
        DefaultServiceLog.setLogLevel(levelName);
        if (DefaultServiceLog.getStaticLogLevel() <= 1) {
            LogLog.setInternalDebugging(true);
        }
        this.logReaderInfo = BackendSupport.createAndRegisterLogReaderService(bundleContext);
        this.eventAdminInfo = BackendSupport.eventAdminSupport(bundleContext);
        this.eventAdminConfigurationNotifierInfo = BackendSupport.eventAdminConfigurationNotifier(bundleContext);
        boolean cm = BackendSupport.isConfigurationAdminAvailable();
        if (!cm) {
            LogLog.debug("Configuration Admin is not available.");
        }
        this.m_PaxLogging = new PaxLoggingServiceImpl(bundleContext, this.logReaderInfo.getService(), this.eventAdminInfo.getService(), this.eventAdminConfigurationNotifierInfo.getService());
        String externalFile = BackendSupport.externalFile(bundleContext, "pax-logging.properties");
        Path configFilePath = Paths.get(externalFile, new String[0]);
        if (!configFilePath.toFile().isFile()) {
            LogLog.debug("Initializing Log4j1 using default configuration");
            this.m_PaxLogging.configureDefaults();
        } else {
            LogLog.debug("Initializing Log4j1 using " + configFilePath.toAbsolutePath());
            Hashtable<String, String> config = new Hashtable<String, String>();
            try (FileInputStream inputStream = new FileInputStream(configFilePath.toFile());){
                Properties properties = new Properties();
                properties.load(inputStream);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String propValue = (String)entry.getValue();
                    ((Dictionary)config).put((String)entry.getKey(), propValue);
                }
            }
            this.m_PaxLogging.setDefaultConfiguration(config);
            this.m_PaxLogging.updated(null);
        }
        if (cm) {
            serviceProperties = new Hashtable<String, Object>();
            ((Dictionary)serviceProperties).put("service.pid", "org.ops4j.pax.logging");
            this.m_RegistrationPaxLogging = bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)new LoggingManagedService(this.m_PaxLogging), serviceProperties);
        }
        serviceProperties = new Hashtable();
        ((Dictionary)serviceProperties).put("service.ranking", BackendSupport.paxLoggingServiceRanking(bundleContext));
        this.m_RegistrationPaxLogging = bundleContext.registerService(PaxLoggingConstants.LOGGING_LOGSERVICE_NAMES, (Object)this.m_PaxLogging, serviceProperties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.eventAdminInfo != null) {
            this.eventAdminInfo.close();
        }
        if (this.logReaderInfo != null) {
            this.logReaderInfo.close();
        }
        if (this.eventAdminConfigurationNotifierInfo != null) {
            this.eventAdminConfigurationNotifierInfo.close();
        }
        this.m_RegistrationPaxLogging.unregister();
        this.m_RegistrationPaxLogging = null;
        if (this.m_PaxLogging != null) {
            this.m_PaxLogging.shutdown();
            this.m_PaxLogging = null;
        }
        FallbackLogFactory.cleanup();
    }

    private void sanityCheck() {
        Bundle b1;
        Bundle paxLoggingApi = FrameworkUtil.getBundle(PaxLoggingService.class);
        Bundle paxLoggingService = FrameworkUtil.getBundle(this.getClass());
        if (paxLoggingService != (b1 = FrameworkUtil.getBundle(Logger.class))) {
            String b1Bundle = b1 == null ? "system classloader" : b1.toString();
            throw new IllegalStateException("org.apache.log4j.Logger class was loaded from " + b1Bundle + ". It should be loaded from " + paxLoggingService + ".");
        }
        Bundle b2 = FrameworkUtil.getBundle(LogManager.class);
        if (paxLoggingService != b2) {
            String b2Bundle = b2 == null ? "system classloader" : b2.toString();
            throw new IllegalStateException("org.apache.log4j.LogManager class was loaded from " + b2Bundle + ". It should be loaded from " + paxLoggingService + ".");
        }
        Bundle b3 = FrameworkUtil.getBundle(Loader.class);
        if (paxLoggingService != b3) {
            String b3Bundle = b3 == null ? "system classloader" : b3.toString();
            throw new IllegalStateException("org.apache.log4j.helpers.Loader class was loaded from " + b3Bundle + ". It should be loaded from " + paxLoggingService + ".");
        }
        Bundle b4 = FrameworkUtil.getBundle(XMLLayout.class);
        if (paxLoggingApi != b4) {
            String b4Bundle = b4 == null ? "system classloader" : b4.toString();
            throw new IllegalStateException("org.apache.log4j.xml.XMLLayout class was loaded from " + b4Bundle + ". It should be loaded from " + paxLoggingApi + ".");
        }
    }
}

