/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j1.internal;

import java.security.AccessController;
import java.util.Map;
import org.apache.log4j.AuditLevel;
import org.apache.log4j.Level;
import org.apache.log4j.MDC;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxMarker;
import org.ops4j.pax.logging.log4j1.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.spi.support.FormattingTriple;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerConsumer;

public class PaxLoggerImpl
implements PaxLogger {
    static String FQCN = PaxLoggerImpl.class.getName();
    private org.apache.log4j.Logger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private PaxLoggingServiceImpl m_service;
    private boolean m_printfFormatting;

    PaxLoggerImpl(Bundle bundle, org.apache.log4j.Logger delegate, String fqcn, PaxLoggingServiceImpl service, boolean printfFormatting) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
        this.m_printfFormatting = printfFormatting;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    public boolean isTraceEnabled(PaxMarker marker) {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled(PaxMarker marker) {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled(PaxMarker marker) {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isWarnEnabled(PaxMarker marker) {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    public boolean isErrorEnabled(PaxMarker marker) {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled(PaxMarker marker) {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.doLog(Level.TRACE, this.m_fqcn, message, null, null);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg);
            this.doLog(Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg1, arg2);
            this.doLog(Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arguments);
            this.doLog(Level.TRACE, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        if (this.isTraceEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void trace(PaxMarker marker, String message) {
        this.trace(message);
    }

    public void trace(PaxMarker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(PaxMarker marker, String format, Object ... arguments) {
        this.trace(format, arguments);
    }

    public <E extends Exception> void trace(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.trace(consumer);
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.doLog(Level.DEBUG, this.m_fqcn, message, null, null);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg);
            this.doLog(Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg1, arg2);
            this.doLog(Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arguments);
            this.doLog(Level.DEBUG, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        if (this.isDebugEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void debug(PaxMarker marker, String message) {
        this.debug(message);
    }

    public void debug(PaxMarker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(PaxMarker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    public <E extends Exception> void debug(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.debug(consumer);
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.doLog(Level.INFO, this.m_fqcn, message, null, null);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg);
            this.doLog(Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg1, arg2);
            this.doLog(Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arguments);
            this.doLog(Level.INFO, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        if (this.isInfoEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void info(PaxMarker marker, String message) {
        this.info(message);
    }

    public void info(PaxMarker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(PaxMarker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    public <E extends Exception> void info(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.info(consumer);
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.doLog(Level.WARN, this.m_fqcn, message, null, null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg);
            this.doLog(Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg1, arg2);
            this.doLog(Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arguments);
            this.doLog(Level.WARN, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        if (this.isWarnEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void warn(PaxMarker marker, String message) {
        this.warn(message);
    }

    public void warn(PaxMarker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(PaxMarker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    public <E extends Exception> void warn(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.warn(consumer);
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.doLog(Level.ERROR, this.m_fqcn, message, null, null);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg);
            this.doLog(Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg1, arg2);
            this.doLog(Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arguments);
            this.doLog(Level.ERROR, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        if (this.isErrorEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void error(PaxMarker marker, String message) {
        this.error(message);
    }

    public void error(PaxMarker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(PaxMarker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    public <E extends Exception> void error(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.error(consumer);
    }

    public void fatal(String message) {
        if (this.isFatalEnabled()) {
            this.doLog(Level.FATAL, this.m_fqcn, message, null, null);
        }
    }

    public void fatal(String format, Object arg) {
        if (this.isFatalEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg);
            this.doLog(Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void fatal(String format, Object arg1, Object arg2) {
        if (this.isFatalEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg1, arg2);
            this.doLog(Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public void fatal(String format, Object ... arguments) {
        if (this.isFatalEnabled()) {
            FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arguments);
            this.doLog(Level.FATAL, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
        }
    }

    public <E extends Exception> void fatal(LoggerConsumer<E> consumer) throws E {
        if (this.isFatalEnabled()) {
            consumer.accept((Logger)this);
        }
    }

    public void fatal(PaxMarker marker, String message) {
        this.fatal(message);
    }

    public void fatal(PaxMarker marker, String format, Object arg) {
        this.fatal(format, arg);
    }

    public void fatal(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.fatal(format, arg1, arg2);
    }

    public void fatal(PaxMarker marker, String format, Object ... arguments) {
        this.fatal(format, arguments);
    }

    public <E extends Exception> void fatal(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.fatal(consumer);
    }

    public void audit(String message) {
        this.doLog(AuditLevel.AUDIT, this.m_fqcn, message, null, null);
    }

    public void audit(String format, Object arg) {
        FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg);
        this.doLog(AuditLevel.AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
    }

    public void audit(String format, Object arg1, Object arg2) {
        FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arg1, arg2);
        this.doLog(AuditLevel.AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
    }

    public void audit(String format, Object ... arguments) {
        FormattingTriple ft = FormattingTriple.resolve(format, this.m_printfFormatting, arguments);
        this.doLog(AuditLevel.AUDIT, this.m_fqcn, ft.getMessage(), ft.getThrowable(), ft.getServiceReference());
    }

    public <E extends Exception> void audit(LoggerConsumer<E> consumer) throws E {
        consumer.accept((Logger)this);
    }

    public void audit(PaxMarker marker, String message) {
        this.audit(message);
    }

    public void audit(PaxMarker marker, String format, Object arg) {
        this.audit(format, arg);
    }

    public void audit(PaxMarker marker, String format, Object arg1, Object arg2) {
        this.audit(format, arg1, arg2);
    }

    public void audit(PaxMarker marker, String format, Object ... arguments) {
        this.audit(format, arguments);
    }

    public <E extends Exception> void audit(PaxMarker marker, LoggerConsumer<E> consumer) throws E {
        this.audit(consumer);
    }

    public void fqtrace(String fqcn, String message) {
        if (this.isTraceEnabled()) {
            this.doLog(Level.TRACE, fqcn, message, null, null);
        }
    }

    public void fqdebug(String fqcn, String message) {
        if (this.isDebugEnabled()) {
            this.doLog(Level.DEBUG, fqcn, message, null, null);
        }
    }

    public void fqinfo(String fqcn, String message) {
        if (this.isInfoEnabled()) {
            this.doLog(Level.INFO, fqcn, message, null, null);
        }
    }

    public void fqwarn(String fqcn, String message) {
        if (this.isWarnEnabled()) {
            this.doLog(Level.WARN, fqcn, message, null, null);
        }
    }

    public void fqerror(String fqcn, String message) {
        if (this.isErrorEnabled()) {
            this.doLog(Level.ERROR, fqcn, message, null, null);
        }
    }

    public void fqfatal(String fqcn, String message) {
        if (this.isFatalEnabled()) {
            this.doLog(Level.FATAL, fqcn, message, null, null);
        }
    }

    public void fqtrace(String fqcn, PaxMarker marker, String message) {
        this.fqtrace(fqcn, message);
    }

    public void fqdebug(String fqcn, PaxMarker marker, String message) {
        this.fqdebug(fqcn, message);
    }

    public void fqinfo(String fqcn, PaxMarker marker, String message) {
        this.fqinfo(fqcn, message);
    }

    public void fqwarn(String fqcn, PaxMarker marker, String message) {
        this.fqwarn(fqcn, message);
    }

    public void fqerror(String fqcn, PaxMarker marker, String message) {
        this.fqerror(fqcn, message);
    }

    public void fqfatal(String fqcn, PaxMarker marker, String message) {
        this.fqfatal(fqcn, message);
    }

    public void fqtrace(String fqcn, String message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.doLog(Level.TRACE, fqcn, message, t, null);
        }
    }

    public void fqdebug(String fqcn, String message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.doLog(Level.DEBUG, fqcn, message, t, null);
        }
    }

    public void fqinfo(String fqcn, String message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.doLog(Level.INFO, fqcn, message, t, null);
        }
    }

    public void fqwarn(String fqcn, String message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.doLog(Level.WARN, fqcn, message, t, null);
        }
    }

    public void fqerror(String fqcn, String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.doLog(Level.ERROR, fqcn, message, t, null);
        }
    }

    public void fqfatal(String fqcn, String message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.doLog(Level.FATAL, fqcn, message, t, null);
        }
    }

    public void fqtrace(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.fqtrace(fqcn, message, t);
    }

    public void fqdebug(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.fqdebug(fqcn, message, t);
    }

    public void fqinfo(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.fqinfo(fqcn, message, t);
    }

    public void fqwarn(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.fqwarn(fqcn, message, t);
    }

    public void fqerror(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.fqerror(fqcn, message, t);
    }

    public void fqfatal(String fqcn, PaxMarker marker, String message, Throwable t) {
        this.fqfatal(fqcn, message, t);
    }

    public int getPaxLogLevel() {
        Level level = this.m_delegate.getEffectiveLevel();
        if (level == null) {
            return 7;
        }
        if (Level.TRACE.isGreaterOrEqual(level)) {
            return 0;
        }
        if (Level.DEBUG.isGreaterOrEqual(level)) {
            return 1;
        }
        if (Level.INFO.isGreaterOrEqual(level)) {
            return 2;
        }
        if (Level.WARN.isGreaterOrEqual(level)) {
            return 3;
        }
        if (Level.ERROR.isGreaterOrEqual(level)) {
            return 4;
        }
        if (Level.FATAL.isGreaterOrEqual(level)) {
            return 5;
        }
        return 6;
    }

    public LogLevel getLogLevel() {
        Level level = this.m_delegate.getEffectiveLevel();
        return this.getLogLevel(level);
    }

    private LogLevel getLogLevel(Level level) {
        if (level == null) {
            return LogLevel.AUDIT;
        }
        if (Level.TRACE.isGreaterOrEqual(level)) {
            return LogLevel.TRACE;
        }
        if (Level.DEBUG.isGreaterOrEqual(level)) {
            return LogLevel.DEBUG;
        }
        if (Level.INFO.isGreaterOrEqual(level)) {
            return LogLevel.INFO;
        }
        if (Level.WARN.isGreaterOrEqual(level)) {
            return LogLevel.WARN;
        }
        return LogLevel.ERROR;
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }

    private void doLog(Level level, String fqcn, String message, Throwable t, ServiceReference<?> ref) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                this.doLog0(level, fqcn, message, t, ref);
                return null;
            });
        } else {
            this.doLog0(level, fqcn, message, t, ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog0(Level level, String fqcn, String message, Throwable t, ServiceReference<?> ref) {
        this.setDelegateContext();
        try {
            this.m_delegate.log(fqcn, level, message, t);
        }
        finally {
            this.clearDelegateContext();
        }
        LogLevel l = this.getLogLevel(level);
        this.m_service.handleEvents(this.getName(), this.m_bundle, ref, l, message, t);
    }

    private void setDelegateContext() {
        Map context = this.getPaxContext().getContext();
        if (context != null) {
            for (Object o : context.keySet()) {
                String key = (String)o;
                Object value = context.get(key);
                MDC.put(key, value);
            }
            context.remove(".log4j2_message");
        }
        if (this.m_bundle != null) {
            this.put("bundle.id", String.valueOf(this.m_bundle.getBundleId()));
            this.put("bundle.name", this.m_bundle.getSymbolicName());
            this.put("bundle.version", this.m_bundle.getVersion().toString());
        }
        this.m_service.lock(false);
    }

    private void put(String name, Object o) {
        if (o != null) {
            MDC.put(name, o);
        }
    }

    private void clearDelegateContext() {
        this.m_service.unlock(false);
        if (MDC.getContext() != null) {
            MDC.getContext().clear();
        }
    }
}

