/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j1.internal.bridges;

import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.ops4j.pax.logging.spi.PaxErrorHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ErrorHandlerBridgeImpl
implements ErrorHandler {
    private ServiceTracker<PaxErrorHandler, PaxErrorHandler> m_tracker;
    private ErrorHandler m_fallback;

    public ErrorHandlerBridgeImpl(BundleContext bundleContext, String name, ErrorHandler fallback) {
        this.m_tracker = new ServiceTracker(bundleContext, ErrorHandlerBridgeImpl.createFilter(bundleContext, name), null);
        this.m_tracker.open();
        this.m_fallback = fallback != null ? fallback : new OnlyOnceErrorHandler();
    }

    public static Filter createFilter(BundleContext bundleContext, String name) {
        try {
            return bundleContext.createFilter("(&(objectClass=" + PaxErrorHandler.class.getName() + ")(" + "org.ops4j.pax.logging.errorhandler.name" + "=" + name + "))");
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("unable to create error handler tracker", e);
        }
    }

    @Override
    public void error(String message) {
        PaxErrorHandler handler = (PaxErrorHandler)this.m_tracker.getService();
        if (handler != null) {
            handler.error(message, null);
        } else {
            this.m_fallback.error(message);
        }
    }

    @Override
    public void error(String message, Exception e, int errorCode) {
        PaxErrorHandler handler = (PaxErrorHandler)this.m_tracker.getService();
        if (handler != null) {
            handler.error(message, e);
        } else {
            this.m_fallback.error(message, e, errorCode);
        }
    }

    @Override
    public void error(String message, Exception e, int errorCode, LoggingEvent event) {
        PaxErrorHandler handler = (PaxErrorHandler)this.m_tracker.getService();
        if (handler != null) {
            handler.error(message, e);
        } else {
            this.m_fallback.error(message, e, errorCode, event);
        }
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public void setLogger(Logger logger) {
    }

    @Override
    public void setAppender(Appender appender) {
    }

    @Override
    public void setBackupAppender(Appender appender) {
    }
}

