/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.eventadmin.EventAdminTracker;
import org.ops4j.pax.logging.logback.internal.FrameworkHandler;
import org.ops4j.pax.logging.logback.internal.JdkHandler;
import org.ops4j.pax.logging.logback.internal.LogReaderServiceImpl;
import org.ops4j.pax.logging.logback.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

@SuppressWarnings(value={"LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE"})
public class Activator
implements BundleActivator {
    public static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    private static final String[] LOG_SERVICE_INTERFACE_NAMES = new String[]{LogService.class.getName(), org.knopflerfish.service.log.LogService.class.getName(), PaxLoggingService.class.getName(), ManagedService.class.getName()};
    private ServiceRegistration m_RegistrationPaxLogging;
    private JdkHandler m_JdkHandler;
    private ServiceRegistration m_registrationLogReaderService;
    private FrameworkHandler m_frameworkHandler;
    private EventAdminPoster m_eventAdmin;
    private PaxLoggingServiceImpl m_paxLogging;

    public void start(BundleContext bundleContext) throws Exception {
        try {
            this.startInternal(bundleContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void startInternal(BundleContext bundleContext) {
        LogReaderServiceImpl logReader = new LogReaderServiceImpl(100);
        String readerServiceName = LogReaderService.class.getName();
        this.m_registrationLogReaderService = bundleContext.registerService(readerServiceName, (Object)logReader, null);
        try {
            this.m_eventAdmin = new EventAdminTracker(bundleContext);
        }
        catch (NoClassDefFoundError e) {
            this.m_eventAdmin = new EventAdminPoster(){

                public void postEvent(Bundle bundle, int level, LogEntry entry, String message, Throwable exception, ServiceReference sr, Map context) {
                }

                public void destroy() {
                }
            };
        }
        this.m_paxLogging = new PaxLoggingServiceImpl(bundleContext, logReader.getAccessDelegate(), this.m_eventAdmin);
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("service.id", "org.ops4j.pax.logging.configuration");
        serviceProperties.put("service.pid", CONFIGURATION_PID);
        this.m_RegistrationPaxLogging = bundleContext.registerService(LOG_SERVICE_INTERFACE_NAMES, (Object)this.m_paxLogging, serviceProperties);
        if (!Boolean.valueOf(bundleContext.getProperty("org.ops4j.pax.logging.skipJUL")).booleanValue()) {
            Handler[] handlers;
            LogManager manager = LogManager.getLogManager();
            manager.reset();
            Logger rootLogger = manager.getLogger("");
            for (Handler handler : handlers = rootLogger.getHandlers()) {
                rootLogger.removeHandler(handler);
            }
            rootLogger.setFilter(null);
            this.m_JdkHandler = new JdkHandler(this.m_paxLogging);
            rootLogger.addHandler(this.m_JdkHandler);
        }
        this.m_frameworkHandler = new FrameworkHandler(this.m_paxLogging);
        bundleContext.addBundleListener((BundleListener)this.m_frameworkHandler);
        bundleContext.addFrameworkListener((FrameworkListener)this.m_frameworkHandler);
        bundleContext.addServiceListener((ServiceListener)this.m_frameworkHandler);
    }

    public void stop(BundleContext bundleContext) {
        this.m_eventAdmin.destroy();
        bundleContext.removeBundleListener((BundleListener)this.m_frameworkHandler);
        bundleContext.removeFrameworkListener((FrameworkListener)this.m_frameworkHandler);
        bundleContext.removeServiceListener((ServiceListener)this.m_frameworkHandler);
        if (this.m_JdkHandler != null) {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            rootLogger.removeHandler(this.m_JdkHandler);
            this.m_JdkHandler.flush();
            this.m_JdkHandler.close();
            this.m_JdkHandler = null;
        }
        this.m_RegistrationPaxLogging.unregister();
        this.m_RegistrationPaxLogging = null;
        this.m_registrationLogReaderService.unregister();
        this.m_registrationLogReaderService = null;
        this.m_paxLogging.stop();
        this.m_paxLogging = null;
    }
}

