/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.service.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;

public class PaxLoggerImpl
implements PaxLogger {
    private Logger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, Logger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    private void setDelegateContext() {
        Map context = this.getPaxContext().getContext();
        if (context != null) {
            Iterator keys = context.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = context.get(key);
                MDC.put(key, value);
            }
        }
        if (this.m_bundle != null) {
            this.put("bundle.id", new Long(this.m_bundle.getBundleId()));
            this.put("bundle.name", this.m_bundle.getSymbolicName());
            this.put("bundle.version", this.m_bundle.getHeaders().get("Bundle-Version"));
        }
    }

    private void put(String name, Object o) {
        if (o != null) {
            MDC.put(name, o);
        }
    }

    private void clearDelegateContext() {
        if (MDC.getContext() != null) {
            MDC.getContext().clear();
        }
    }

    public void trace(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.TRACE, message, t);
        this.clearDelegateContext();
    }

    public void debug(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.DEBUG, message, t);
        this.clearDelegateContext();
    }

    public void inform(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.INFO, message, t);
        this.clearDelegateContext();
    }

    public void warn(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.WARN, message, t);
        this.clearDelegateContext();
    }

    public void error(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.ERROR, message, t);
        this.clearDelegateContext();
    }

    public void fatal(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.FATAL, message, t);
        this.clearDelegateContext();
    }

    public int getLogLevel() {
        return this.m_delegate.getLevel().toInt();
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public void log(Priority level, Object message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, level, message, t);
        this.clearDelegateContext();
    }

    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }
}

