/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassLoadingHelper {
    private static final Logger LOGGER = LoggerFactory.createLogger(ClassLoadingHelper.class);
    private static List<String> javaLangObjectMethodNames = new ArrayList<String>();

    private static Object newProxyInstance(List<ClassLoader> classLoadersToTry, Class<?>[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        Object ret = null;
        ClassLoader cl = classLoadersToTry.get(0);
        List<ClassLoader> remainingClassLoaders = classLoadersToTry.subList(1, classLoadersToTry.size());
        try {
            return Proxy.newProxyInstance(cl, interfaces, delegate);
        }
        catch (IllegalArgumentException someClassNotFound) {
            if (remainingClassLoaders.size() <= 0) {
                throw someClassNotFound;
            }
            ret = ClassLoadingHelper.newProxyInstance(remainingClassLoaders, interfaces, delegate);
            return ret;
        }
    }

    public static Object newProxyInstance(List<ClassLoader> classLoadersToTry, Class<?>[] minimumSetOfInterfaces, Class<?>[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        Object ret = null;
        try {
            ret = ClassLoadingHelper.newProxyInstance(classLoadersToTry, interfaces, delegate);
        }
        catch (IllegalArgumentException someClassNotFound) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("could not create Atomikos proxy with all requested interfaces - trying again with minimum set of interfaces");
            }
            ret = ClassLoadingHelper.newProxyInstance(classLoadersToTry, minimumSetOfInterfaces, delegate);
        }
        return ret;
    }

    public static <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException nf) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static URL loadResourceFromClasspath(Class<?> clazz, String resourceName) {
        URL ret = null;
        ret = clazz.getResource(resourceName);
        if (ret == null) {
            ret = clazz.getResource("/" + resourceName);
        }
        return ret;
    }

    public static boolean existsInJavaObjectClass(Method method) {
        return javaLangObjectMethodNames.contains(method.getName());
    }

    static {
        try {
            MethodDescriptor[] methods;
            BeanInfo infos = Introspector.getBeanInfo(Object.class);
            for (MethodDescriptor methodDescriptor : methods = infos.getMethodDescriptors()) {
                javaLangObjectMethodNames.add(methodDescriptor.getName());
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }
}

