/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import com.atomikos.util.IntraVmObjectRegistry;
import com.atomikos.util.SerializableObjectFactory;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class IntraVmObjectFactory
implements ObjectFactory {
    private static final String NAME_REF_ADDRESS_TYPE = "uniqueResourceName";
    private static SerializableObjectFactory serializableObjectFactory = new SerializableObjectFactory();

    private static synchronized Object retrieveObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Object ret = null;
        if (obj instanceof Reference) {
            String resourceName = null;
            Reference ref = (Reference)obj;
            StringRefAddr nameAsRefAddr = (StringRefAddr)ref.get(NAME_REF_ADDRESS_TYPE);
            resourceName = (String)nameAsRefAddr.getContent();
            try {
                ret = IntraVmObjectRegistry.getResource(resourceName);
            }
            catch (NameNotFoundException notYetInited) {
                Object resource = serializableObjectFactory.getObjectInstance(obj, name, nameCtx, environment);
                IntraVmObjectRegistry.addResource(resourceName, resource);
                ret = resource;
            }
        }
        return ret;
    }

    public static synchronized Reference createReference(Serializable object, String name) throws NamingException {
        Reference ret = null;
        if (object == null) {
            throw new IllegalArgumentException("invalid resource: null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name should not be null");
        }
        try {
            Object existing = IntraVmObjectRegistry.getResource(name);
            if (existing != object) {
                String msg = "Another resource already exists with name " + name + " - pick a different name";
                throw new NamingException(msg);
            }
        }
        catch (NameNotFoundException notThere) {
            IntraVmObjectRegistry.addResource(name, object);
        }
        ret = SerializableObjectFactory.createReference(object, IntraVmObjectFactory.class.getName());
        ret.add(new StringRefAddr(NAME_REF_ADDRESS_TYPE, name));
        return ret;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        return IntraVmObjectFactory.retrieveObjectInstance(obj, name, nameCtx, environment);
    }
}

