/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.tm.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public abstract class AbstractActivator
implements BundleActivator {
    private BundleContext bundleContext;
    private ExecutorService executor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private AtomicBoolean scheduled = new AtomicBoolean();
    private long schedulerStopTimeout = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private ServiceRegistration managedServiceRegistration;
    private Dictionary<String, ?> configuration;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.scheduled.set(true);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", this.getPid());
        this.managedServiceRegistration = this.bundleContext.registerService(ManagedService.class, this::updated, props);
        this.scheduled.set(false);
        this.reconfigure();
    }

    public void stop(BundleContext context) throws Exception {
        this.scheduled.set(true);
        if (this.managedServiceRegistration != null) {
            this.managedServiceRegistration.unregister();
        }
        this.executor.shutdown();
        this.executor.awaitTermination(this.schedulerStopTimeout, TimeUnit.MILLISECONDS);
        this.doStop();
    }

    private void updated(Dictionary<String, ?> properties) {
        if (!this.equals(this.configuration, properties)) {
            this.configuration = properties;
            this.reconfigure();
        }
    }

    private boolean equals(Dictionary<String, ?> d1, Dictionary<String, ?> d2) {
        if (d1 == d2) {
            return true;
        }
        if (d1 == null ^ d2 == null) {
            return false;
        }
        if (d1.size() != d2.size()) {
            return false;
        }
        Enumeration<String> e1 = d1.keys();
        while (e1.hasMoreElements()) {
            Object v2;
            String key = e1.nextElement();
            Object v1 = d1.get(key);
            if (v1 == (v2 = d2.get(key)) || v2 != null && v2.equals(v1)) continue;
            return false;
        }
        return true;
    }

    private void reconfigure() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.executor.submit(this::run);
        }
    }

    private void run() {
        this.scheduled.set(false);
        this.doStop();
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.warn("Error starting service", e);
            this.doStop();
        }
    }

    protected abstract String getPid();

    protected abstract void doStart() throws Exception;

    protected abstract void doStop();

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected Dictionary<String, ?> getConfiguration() {
        return this.configuration;
    }

    protected void warn(String message, Throwable t) {
        ServiceReference ref = this.bundleContext.getServiceReference(LogService.class);
        if (ref != null) {
            LogService svc = (LogService)this.bundleContext.getService(ref);
            svc.log(2, message, t);
            this.bundleContext.ungetService(ref);
        }
    }
}

