/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.extender;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.extender.BundleObserver;
import org.ops4j.pax.swissbox.extender.BundleScanner;
import org.ops4j.pax.swissbox.lifecycle.AbstractLifecycle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWatcher<T>
extends AbstractLifecycle {
    private static final Log LOG = LogFactory.getLog(BundleWatcher.class);
    private final BundleContext m_context;
    private final BundleScanner<T> m_scanner;
    private final List<BundleObserver<T>> m_observers;
    private Map<Bundle, List<T>> m_mappings;
    private BundleListener m_bundleListener;

    public BundleWatcher(BundleContext context, BundleScanner<T> scanner) {
        this(context, scanner, null);
    }

    public BundleWatcher(BundleContext context, BundleScanner<T> scanner, BundleObserver<T> ... observers) {
        LOG.debug("Creating bundle watcher with scanner [" + scanner + "]...");
        NullArgumentException.validateNotNull(context, "Context");
        NullArgumentException.validateNotNull(scanner, "Bundle scanner");
        this.m_context = context;
        this.m_scanner = scanner;
        this.m_observers = new ArrayList<BundleObserver<T>>();
        if (observers != null) {
            this.m_observers.addAll(Arrays.asList(observers));
        }
    }

    @Override
    protected void onStart() {
        this.m_mappings = new HashMap<Bundle, List<T>>();
        this.m_bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                switch (bundleEvent.getType()) {
                    case 2: {
                        BundleWatcher.this.register(bundleEvent.getBundle());
                        break;
                    }
                    case 4: {
                        BundleWatcher.this.unregister(bundleEvent.getBundle());
                    }
                }
            }
        };
        this.m_context.addBundleListener(this.m_bundleListener);
        Bundle[] bundles = this.m_context.getBundles();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                if (bundle.getState() != 32) continue;
                this.register(bundle);
            }
        }
    }

    @Override
    protected void onStop() {
        Bundle[] toBeRemoved;
        this.m_context.removeBundleListener(this.m_bundleListener);
        for (Bundle bundle : toBeRemoved = this.m_mappings.keySet().toArray(new Bundle[this.m_mappings.keySet().size()])) {
            this.unregister(bundle);
        }
        this.m_bundleListener = null;
        this.m_mappings = null;
    }

    private void register(Bundle bundle) {
        LOG.debug("Scanning bundle [" + bundle.getSymbolicName() + "]");
        List<T> resources = this.m_scanner.scan(bundle);
        this.m_mappings.put(bundle, resources);
        if (resources != null && resources.size() > 0) {
            LOG.debug("Found resources " + resources);
            for (BundleObserver<T> observer : this.m_observers) {
                try {
                    observer.addingEntries(bundle, Collections.unmodifiableList(resources));
                }
                catch (Throwable ignore) {
                    LOG.error("Ignored exception during register", ignore);
                }
            }
        }
    }

    private void unregister(Bundle bundle) {
        LOG.debug("Releasing bundle [" + bundle.getSymbolicName() + "]");
        List<T> resources = this.m_mappings.get(bundle);
        if (resources != null && resources.size() > 0) {
            LOG.debug("Unregistering " + resources);
            for (BundleObserver<T> observer : this.m_observers) {
                try {
                    observer.removingEntries(bundle, Collections.unmodifiableList(resources));
                }
                catch (Throwable ignore) {
                    LOG.error("Ignored exception during unregister", ignore);
                }
            }
        }
        this.m_mappings.remove(bundle);
    }
}

