/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.parser;

import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletMapping;
import org.ops4j.pax.web.extender.war.internal.parser.AnnotationScanner;
import org.osgi.framework.Bundle;

public class WebServletAnnotationScanner
extends AnnotationScanner<WebServletAnnotationScanner> {
    public WebServletAnnotationScanner(Bundle bundle, String clazz) {
        super(bundle, clazz);
    }

    public void scan(WebApp webApp) {
        MultipartConfig multiPartConfigAnnotation;
        Class<?> clazz = this.loadClass();
        if (clazz == null) {
            this.log.warn("Class {} wasn't loaded", (Object)this.className);
            return;
        }
        if (!HttpServlet.class.isAssignableFrom(clazz)) {
            this.log.warn(clazz.getName() + " is not assignable from javax.servlet.http.HttpServlet");
            return;
        }
        WebServlet annotation = clazz.getAnnotation(WebServlet.class);
        if (annotation.urlPatterns().length > 0 && annotation.value().length > 0) {
            this.log.warn(clazz.getName() + " defines both @WebServlet.value and @WebServlet.urlPatterns");
            return;
        }
        String[] urlPatterns = annotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = annotation.urlPatterns();
        }
        if (urlPatterns.length == 0) {
            this.log.warn(clazz.getName() + " defines neither @WebServlet.value nor @WebServlet.urlPatterns");
            return;
        }
        String servletName = annotation.name().equals("") ? clazz.getName() : annotation.name();
        WebAppServlet webAppServlet = webApp.findServlet(servletName);
        this.log.debug("Registering Servlet {} with url(s) {}", (Object)servletName, (Object)urlPatterns);
        if (webAppServlet == null) {
            this.log.debug("Create a new Servlet");
            webAppServlet = new WebAppServlet();
            webAppServlet.setServletName(servletName);
            webAppServlet.setServletClassName(this.className);
            webApp.addServlet(webAppServlet);
            webAppServlet.setLoadOnStartup(annotation.loadOnStartup());
            webAppServlet.setAsyncSupported(annotation.asyncSupported());
        }
        WebAppInitParam[] initParams = webAppServlet.getInitParams();
        for (WebInitParam ip : annotation.initParams()) {
            if (this.initParamsContain(initParams, ip.name())) continue;
            WebAppInitParam initParam = new WebAppInitParam();
            initParam.setParamName(ip.name());
            initParam.setParamValue(ip.value());
            webAppServlet.addInitParam(initParam);
        }
        List<WebAppServletMapping> mappings = webApp.getServletMappings(servletName);
        this.log.debug("Found the following mappings {} for servlet: {}", mappings, (Object)servletName);
        if (mappings == null || mappings.isEmpty()) {
            this.log.debug("alter/create mappings");
            for (String urlPattern : urlPatterns) {
                this.log.debug("adding mapping for URL {}", (Object)urlPattern);
                WebAppServletMapping mapping = new WebAppServletMapping();
                mapping.setServletName(servletName);
                mapping.setUrlPattern(urlPattern);
                webApp.addServletMapping(mapping);
            }
        }
        if (null != (multiPartConfigAnnotation = clazz.getAnnotation(MultipartConfig.class))) {
            MultipartConfigElement multipartConfig = new MultipartConfigElement(multiPartConfigAnnotation);
            webAppServlet.setMultipartConfig(multipartConfig);
        }
    }
}

