/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl11;

import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLElement;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractServiceImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.DocumentationImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.EndpointImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLJAXBContext;
import org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLReaderImpl;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDocumented;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TPort;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceImpl
extends AbstractServiceImpl<TService, InterfaceType, Endpoint>
implements Service {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ServiceImpl.class.getName());

    public ServiceImpl(TService service, DescriptionImpl desc) {
        super(service, desc);
        this.desc = desc;
        this.documentation = new DocumentationImpl(((TService)this.model).getDocumentation(), (AbstractWSDLElementImpl)this);
        for (TPort port : ((TService)this.model).getPort()) {
            EndpointImpl e = new EndpointImpl(port, this);
            this.endpoints.add(e);
        }
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        super.addEndpoint(endpoint);
        ((TService)this.model).getPort().add((TPort)((AbstractWSDLElementImpl)((Object)endpoint)).getModel());
    }

    @Override
    public QName getQName() {
        QName serviceName = null;
        serviceName = new QName(this.desc.getTargetNamespace(), ((TService)this.model).getName());
        return serviceName;
    }

    @Override
    public Endpoint removeEndpoint(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQName(QName name) {
        ((TService)this.model).setName(name.getLocalPart());
    }

    @Override
    public InterfaceType getInterface() throws WSDLException {
        InterfaceType res = null;
        InterfaceType item = null;
        for (Endpoint ep : this.getEndpoints()) {
            item = (InterfaceType)((Binding)ep.getBinding()).getInterface();
            if (item == null) continue;
            if (res == null) {
                res = item;
                continue;
            }
            if (res == item) continue;
            throw new WSDLException("WSDL 1.1: The endpoints of this service do not implement the same interface");
        }
        return res;
    }

    @Override
    public Endpoint createEndpoint() {
        return new EndpointImpl(new TPort(), this);
    }

    @Override
    public void setInterface(InterfaceType itf) {
        LOG.warning("Operation setInterface not supported");
    }

    public static TService replaceDOMElementByTService(WSDLElement parent, Element childToReplace, WSDLReaderImpl reader) throws WSDLException {
        TService res = null;
        try {
            if (childToReplace != null && childToReplace.getLocalName().equals("service")) {
                Unmarshaller unmarshaller = WSDLJAXBContext.getJaxbContext().createUnmarshaller();
                JAXBElement jaxbElement = unmarshaller.unmarshal((Node)childToReplace, TService.class);
                ((TDefinitions)((AbstractWSDLElementImpl)parent).getModel()).getAny().remove(childToReplace);
                ((TDefinitions)((AbstractWSDLElementImpl)parent).getModel()).getAnyTopLevelOptionalElement().add((TDocumented)jaxbElement.getValue());
                res = (TService)jaxbElement.getValue();
            }
        }
        catch (JAXBException e) {
            throw new WSDLException(e);
        }
        return res;
    }
}

