/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.Session;

public final class BytesMessage
extends Message
implements javax.jms.BytesMessage {
    private transient ByteArrayOutputStream outputBuffer = null;
    private transient DataOutputStream outputStream = null;
    private transient DataInputStream inputStream = null;
    private transient boolean prepared = false;

    BytesMessage() {
        this.momMsg.type = 5;
        this.outputBuffer = new ByteArrayOutputStream();
        this.outputStream = new DataOutputStream(this.outputBuffer);
    }

    BytesMessage(Session sess, org.objectweb.joram.shared.messages.Message momMsg) throws JMSException {
        super(sess, momMsg);
        if (momMsg.isNullBody()) {
            throw new MessageFormatException("Message body is null: " + momMsg.id);
        }
        try {
            this.inputStream = new DataInputStream(new ByteArrayInputStream(momMsg.getBody()));
        }
        catch (IOException exc) {
            MessageFormatException jExc = new MessageFormatException("Message body could not be uncompressed: " + momMsg.id);
            jExc.setLinkedException((Exception)exc);
            throw jExc;
        }
    }

    public long getBodyLength() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't get not readable message's  size.");
        }
        return this.momMsg.getBodyLength();
    }

    @Override
    public void clearBody() throws JMSException {
        try {
            if (!this.RObody) {
                this.outputStream.close();
                this.outputBuffer.close();
            } else {
                this.inputStream.close();
            }
            this.outputBuffer = new ByteArrayOutputStream();
            this.outputStream = new DataOutputStream(this.outputBuffer);
            super.clearBody();
            this.prepared = false;
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while closing the stream facilities.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.writeObject(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.writeObject(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeObject(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.RObody) {
            throw new MessageNotWriteableException("Can't write a value as the message body is read-only.");
        }
        if (this.prepared) {
            this.prepared = false;
            this.outputBuffer = new ByteArrayOutputStream();
            this.outputStream = new DataOutputStream(this.outputBuffer);
        }
        try {
            this.outputStream.write(value, offset, length);
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Error while writing the value.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
    }

    public void writeChar(char value) throws JMSException {
        this.writeObject(Character.valueOf(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.writeObject(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.writeObject(Float.valueOf(value));
    }

    public void writeInt(int value) throws JMSException {
        this.writeObject(value);
    }

    public void writeLong(long value) throws JMSException {
        this.writeObject(value);
    }

    public void writeShort(short value) throws JMSException {
        this.writeObject(value);
    }

    public void writeUTF(String value) throws JMSException {
        this.writeObject(value);
    }

    public void writeObject(Object value) throws JMSException {
        block15: {
            if (this.RObody) {
                throw new MessageNotWriteableException("Can't write a value as the message body is read-only.");
            }
            if (value == null) {
                throw new NullPointerException("Forbidden null value.");
            }
            if (this.prepared) {
                this.prepared = false;
                this.outputBuffer = new ByteArrayOutputStream();
                this.outputStream = new DataOutputStream(this.outputBuffer);
            }
            try {
                if (value instanceof Boolean) {
                    this.outputStream.writeBoolean((Boolean)value);
                    break block15;
                }
                if (value instanceof Character) {
                    this.outputStream.writeChar(((Character)value).charValue());
                    break block15;
                }
                if (value instanceof Integer) {
                    this.outputStream.writeInt((Integer)value);
                    break block15;
                }
                if (value instanceof Short) {
                    this.outputStream.writeShort(((Short)value).shortValue());
                    break block15;
                }
                if (value instanceof Long) {
                    this.outputStream.writeLong((Long)value);
                    break block15;
                }
                if (value instanceof Float) {
                    this.outputStream.writeFloat(((Float)value).floatValue());
                    break block15;
                }
                if (value instanceof Double) {
                    this.outputStream.writeDouble((Double)value);
                    break block15;
                }
                if (value instanceof String) {
                    this.outputStream.writeUTF((String)value);
                    break block15;
                }
                if (value instanceof Byte) {
                    this.outputStream.writeByte(((Byte)value).intValue());
                    break block15;
                }
                if (value instanceof byte[]) {
                    this.outputStream.write((byte[])value);
                    break block15;
                }
                throw new MessageFormatException("Can't write non Java primitive type as a bytes array.");
            }
            catch (IOException ioE) {
                JMSException jE = new JMSException("Error while writing the value.");
                jE.setLinkedException((Exception)ioE);
                throw jE;
            }
        }
    }

    public boolean readBoolean() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readBoolean();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public byte readByte() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readByte();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public int readUnsignedByte() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readUnsignedByte();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public short readShort() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readShort();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public int readUnsignedShort() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readUnsignedShort();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public char readChar() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readChar();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public int readInt() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readInt();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public long readLong() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readLong();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public float readFloat() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readFloat();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public double readDouble() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readDouble();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        int counter = 0;
        try {
            for (int i = 0; i < value.length; ++i) {
                value[i] = this.inputStream.readByte();
                ++counter;
            }
        }
        catch (EOFException i) {
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
        if (counter == 0) {
            return -1;
        }
        return counter;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        if (length > value.length || length < 0) {
            throw new IndexOutOfBoundsException("Invalid length parameter: " + length);
        }
        int counter = 0;
        try {
            for (int i = 0; i < length; ++i) {
                value[i] = this.inputStream.readByte();
                ++counter;
            }
        }
        catch (EOFException i) {
        }
        catch (IOException ioE) {
            JMSException jE = new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)ioE);
            throw jE;
        }
        if (counter == 0) {
            return -1;
        }
        return counter;
    }

    public String readUTF() throws JMSException {
        if (!this.RObody) {
            throw new MessageNotReadableException("Can't read the message body as it is write-only.");
        }
        try {
            return this.inputStream.readUTF();
        }
        catch (IOException e) {
            Object jE = null;
            jE = e instanceof EOFException ? new MessageEOFException("Unexpected end of bytes array.") : new JMSException("Could not read the bytes array.");
            jE.setLinkedException((Exception)e);
            throw jE;
        }
    }

    public void reset() throws JMSException {
        try {
            if (!this.RObody) {
                this.outputStream.flush();
                this.momMsg.setBody(this.outputBuffer.toByteArray());
            } else {
                this.inputStream.close();
            }
            if (this.momMsg.isNullBody()) {
                throw new MessageFormatException("Message body is null: " + this.momMsg.id);
            }
            this.inputStream = new DataInputStream(new ByteArrayInputStream(this.momMsg.getBody()));
            this.RObody = true;
        }
        catch (IOException iE) {
            JMSException jE = new JMSException("Error while manipulating the stream facilities.");
            jE.setLinkedException((Exception)iE);
            throw jE;
        }
    }

    @Override
    protected void prepare() throws JMSException {
        super.prepare();
        try {
            if (!this.RObody) {
                this.outputStream.flush();
                this.momMsg.setBody(this.outputBuffer.toByteArray());
                this.prepared = true;
            }
        }
        catch (IOException exc) {
            MessageFormatException jExc = new MessageFormatException("The message body could not be serialized.");
            jExc.setLinkedException((Exception)exc);
            throw jExc;
        }
    }

    byte[] getBytes() throws JMSException {
        try {
            this.reset();
            byte[] result = this.momMsg.getBody();
            this.reset();
            return result;
        }
        catch (IOException e) {
            throw new JMSException("Unable to get byte message body ");
        }
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        if (!this.RObody) {
            throw new MessageFormatException("Message is not readable");
        }
        return super.getBody(c);
    }

    @Override
    protected <T> T getEffectiveBody(Class<T> c) throws JMSException {
        return (T)this.getBytes();
    }
}

