/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Configuration;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import org.objectweb.joram.client.jms.ConnectionMBean;
import org.objectweb.joram.client.jms.ConnectionMetaData;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.MessageInterceptor;
import org.objectweb.joram.client.jms.MessageProducer;
import org.objectweb.joram.client.jms.MultiSessionConsumer;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.client.jms.connection.Requestor;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.AddClientIDRequest;
import org.objectweb.joram.shared.client.CnxCloseRequest;
import org.objectweb.joram.shared.client.CnxConnectReply;
import org.objectweb.joram.shared.client.CnxConnectRequest;
import org.objectweb.joram.shared.client.CnxStartRequest;
import org.objectweb.joram.shared.client.CnxStopRequest;
import org.objectweb.joram.shared.client.ConsumerSubRequest;
import org.objectweb.joram.shared.excepts.SelectorException;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Connection
implements javax.jms.Connection,
ConnectionMBean {
    public static Logger logger = Debug.getLogger((String)Connection.class.getName());
    public static Logger tracker = Debug.getLogger((String)(Connection.class.getName() + ".tracker"));
    private RequestMultiplexer mtpx;
    private Requestor requestor;
    private ConnectionMetaData metaData = null;
    private AtomicCounter sessionsC;
    private AtomicCounter messagesC;
    private AtomicCounter subsC;
    private String proxyId;
    private int key;
    private FactoryParameters factoryParameters;
    private int status;
    private Vector<Session> sessions;
    private Vector<MultiSessionConsumer> cconsumers;
    private Closer closer;
    private String stringImage = null;
    private int hashCode;
    private Identity identity = null;
    private String clientID = null;
    private boolean lockClientID = false;
    public final String MESSAGE_ID_PREFIX_PROPERTY = "org.objectweb.joram.client.jms.messageid.prefix";
    protected String JMXBeanBaseName = null;
    Map<String, Integer> messageConsumers = new HashMap<String, Integer>();

    boolean checkThread() {
        return this.mtpx.checkDemultiplexerDaemon();
    }

    boolean checkCLSession(Session session) {
        return this.mtpx.checkCLSession(session);
    }

    boolean checkCLMessageProducer(Session session, MessageProducer mp) {
        return this.mtpx.checkCLMessageProducer(session, mp);
    }

    final String getProxyId() {
        return this.proxyId;
    }

    public void lockClientId() {
        this.lockClientID = true;
    }

    public Connection() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Connection.<init>");
        }
    }

    public void open(FactoryParameters factoryParameters, RequestChannel requestChannel) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Connection.open(" + factoryParameters + ',' + requestChannel + ')');
        }
        this.factoryParameters = (FactoryParameters)factoryParameters.clone();
        this.mtpx = new RequestMultiplexer(this, requestChannel, factoryParameters.cnxPendingTimer);
        if (factoryParameters.multiThreadSync) {
            this.mtpx.setMultiThreadSync(factoryParameters.multiThreadSyncDelay, factoryParameters.multiThreadSyncThreshold);
        }
        this.requestor = new Requestor(this.mtpx);
        this.sessions = new Vector();
        this.cconsumers = new Vector();
        this.closer = new Closer();
        this.setStatus(0);
        CnxConnectRequest req = new CnxConnectRequest();
        CnxConnectReply rep = (CnxConnectReply)this.requestor.request((AbstractJmsRequest)req);
        this.proxyId = rep.getProxyId();
        this.key = rep.getCnxKey();
        this.sessionsC = new AtomicCounter("c" + this.key + 's');
        String messageIdPrefix = Configuration.getProperty((String)"org.objectweb.joram.client.jms.messageid.prefix");
        if (messageIdPrefix == null) {
            messageIdPrefix = factoryParameters.messageIdPrefix;
        }
        this.messagesC = messageIdPrefix == null ? new AtomicCounter("ID:" + this.proxyId.substring(1) + 'c' + this.key + 'm') : new AtomicCounter("ID:" + messageIdPrefix + '_' + this.proxyId.substring(1) + 'c' + this.key + 'm');
        this.subsC = new AtomicCounter("c" + this.key + "sub");
        this.stringImage = this.getClass().getSimpleName() + ":c" + this.key + '[' + this.proxyId + ']';
        this.hashCode = (this.proxyId.hashCode() & 0xFFFF0000) + this.key;
        if (tracker.isLoggable(BasicLevel.DEBUG)) {
            tracker.log(BasicLevel.DEBUG, this.stringImage + " established.", (Throwable)new Exception());
        } else if (tracker.isLoggable(BasicLevel.INFO)) {
            tracker.log(BasicLevel.INFO, this.stringImage + " established.");
        }
        this.mtpx.setDemultiplexerDaemonName(this.toString());
        this.identity = requestChannel.getIdentity();
        if (factoryParameters.clientID != null) {
            this.clientID = factoryParameters.clientID;
            this.addClientIDToProxy(this.clientID);
            this.lockClientId();
        }
        this.registerMBean(this.JMXBeanBaseName);
    }

    public void setJMXBeanBaseName(String JMXBeanBaseName) {
        this.JMXBeanBaseName = JMXBeanBaseName;
    }

    public String getJMXBeanName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.JMXBeanBaseName).append(":type=Connections,");
        buf.append("name=").append(this.identity != null ? this.identity.getUserName() : "null");
        buf.append(" c" + this.key);
        if (this.factoryParameters.getPort() < 0) {
            buf.append(" [localhost]");
        } else {
            buf.append(" [" + this.factoryParameters.getHost()).append(" _ ").append(this.factoryParameters.getPort()).append("]");
        }
        return buf.toString();
    }

    public String registerMBean(String base) {
        String JMXBeanName;
        block3: {
            if (base == null) {
                return null;
            }
            JMXBeanName = this.getJMXBeanName();
            try {
                MXWrapper.registerMBean((Object)this, (String)JMXBeanName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, "Connection.registerMBean: " + JMXBeanName, (Throwable)e);
            }
        }
        return JMXBeanName;
    }

    public void unregisterMBean() {
        block3: {
            if (this.JMXBeanBaseName == null) {
                return;
            }
            try {
                MXWrapper.unregisterMBean((String)this.getJMXBeanName());
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, "Connection.unregisterMBean: " + this.JMXBeanBaseName + ":" + this.getJMXBeanName(), (Throwable)e);
            }
        }
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".setStatus(" + Status.toString(status) + ')');
        }
        this.status = status;
    }

    @Override
    public boolean isStopped() {
        return this.status == 0;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",proxyId=").append(this.proxyId);
        strbuf.append(",key=").append(this.key);
        strbuf.append(')');
        return strbuf.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Connection) {
            Connection cnx = (Connection)obj;
            return this.proxyId.equals(cnx.proxyId) && this.key == cnx.key;
        }
        return false;
    }

    @Override
    public final long getTxPendingTimer() {
        return this.factoryParameters.txPendingTimer;
    }

    @Override
    public final boolean getImplicitAck() {
        return this.factoryParameters.implicitAck;
    }

    @Override
    public final boolean getAsyncSend() {
        return this.factoryParameters.asyncSend;
    }

    @Override
    public final int getQueueMessageReadMax() {
        return this.factoryParameters.queueMessageReadMax;
    }

    @Override
    public final int getTopicAckBufferMax() {
        return this.factoryParameters.topicAckBufferMax;
    }

    @Override
    public final int getTopicPassivationThreshold() {
        return this.factoryParameters.topicPassivationThreshold;
    }

    @Override
    public final int getTopicActivationThreshold() {
        return this.factoryParameters.topicActivationThreshold;
    }

    public final int getCompressedMinSize() {
        return this.factoryParameters.compressedMinSize;
    }

    public final int getCompressionLevel() {
        return this.factoryParameters.compressionLevel;
    }

    @Override
    public final String getOutLocalAddress() {
        return this.factoryParameters.outLocalAddress;
    }

    @Override
    public final int getOutLocalPort() {
        return this.factoryParameters.outLocalPort;
    }

    final List<MessageInterceptor> getInInterceptors() {
        return this.factoryParameters.inInterceptors;
    }

    final List<MessageInterceptor> getOutInterceptors() {
        return this.factoryParameters.outInterceptors;
    }

    protected final synchronized void checkClosed() throws IllegalStateException {
        if (this.status == 2 || this.mtpx.isClosed()) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
    }

    public synchronized ConnectionConsumer createConnectionConsumer(javax.jms.Destination dest, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".createConnectionConsumer(" + dest + ',' + selector + ',' + sessionPool + ',' + maxMessages + ')');
        }
        this.lockClientId();
        this.checkClosed();
        return this.createConnectionConsumer(dest, null, selector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subName, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".createDurableConnectionConsumer(" + topic + ',' + subName + ',' + selector + ',' + sessionPool + ',' + maxMessages + ')');
        }
        this.lockClientId();
        this.checkClosed();
        if (subName == null) {
            throw new JMSException("Invalid subscription name: " + subName);
        }
        return this.createConnectionConsumer((javax.jms.Destination)topic, subName, selector, sessionPool, maxMessages);
    }

    private synchronized ConnectionConsumer createConnectionConsumer(javax.jms.Destination dest, String subName, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        boolean durable;
        String targetName;
        boolean queueMode;
        this.checkClosed();
        this.lockClientId();
        try {
            Selector.checks((String)selector);
        }
        catch (SelectorException sE) {
            throw new InvalidSelectorException("Invalid selector syntax: " + (Object)((Object)sE));
        }
        if (sessionPool == null) {
            throw new JMSException("Invalid ServerSessionPool parameter: " + sessionPool);
        }
        if (maxMessages <= 0) {
            throw new JMSException("Invalid maxMessages parameter: " + maxMessages);
        }
        if (dest instanceof Queue) {
            queueMode = true;
            targetName = ((Destination)dest).getName();
            durable = false;
        } else {
            queueMode = false;
            if (subName == null) {
                targetName = this.nextSubName();
                durable = false;
            } else {
                targetName = subName;
                durable = true;
            }
            this.requestor.request((AbstractJmsRequest)new ConsumerSubRequest(((Destination)dest).getName(), targetName, selector, false, durable, false, this.getClientID(), false));
        }
        MultiSessionConsumer msc = new MultiSessionConsumer(queueMode, durable, selector, ((Destination)dest).getAdminName(), targetName, sessionPool, this.factoryParameters.queueMessageReadMax, this.factoryParameters.topicActivationThreshold, this.factoryParameters.topicPassivationThreshold, this.factoryParameters.topicAckBufferMax, this.mtpx, this, maxMessages);
        msc.start();
        this.cconsumers.addElement(msc);
        return msc;
    }

    public synchronized javax.jms.Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".createSession(" + transacted + ',' + acknowledgeMode + ')');
        }
        this.checkClosed();
        Session session = new Session(this, transacted, acknowledgeMode, this.mtpx);
        this.addSession(session);
        return session;
    }

    public javax.jms.Session createSession() throws JMSException {
        return this.createSession(false, 1);
    }

    public javax.jms.Session createSession(int sessionMode) throws JMSException {
        if (sessionMode == 0) {
            return this.createSession(true, 0);
        }
        if (sessionMode == 2 || sessionMode == 1 || sessionMode == 3) {
            return this.createSession(false, sessionMode);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Unrecognised sessionMode given as parameter: " + sessionMode);
        }
        throw new JMSException("Error occured in session creation");
    }

    protected synchronized void addSession(Session session) {
        this.sessions.addElement(session);
        if (this.status == 1) {
            session.start();
        }
    }

    public synchronized void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.lockClientId();
        this.checkClosed();
        this.mtpx.setExceptionListener(listener);
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.lockClientId();
        this.checkClosed();
        return this.mtpx.getExceptionListener();
    }

    public void setClientID(String clientID) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "setClientID(" + clientID + ')');
        }
        if (clientID != null && clientID.length() == 0) {
            throw new InvalidClientIDException("The JMS client specifies an invalid client ID \"" + clientID + "\".");
        }
        if (this.lockClientID) {
            throw new IllegalStateException("ClientID is already set by the provider.");
        }
        this.checkClosed();
        this.addClientIDToProxy(clientID);
        this.clientID = clientID;
        this.lockClientId();
    }

    void setProviderClientID() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "setProviderClientID()");
        }
        this.checkClosed();
        this.clientID = this.stringImage;
        this.lockClientId();
    }

    private void addClientIDToProxy(String clientID) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "addClientIDToProxy(" + clientID + ')');
        }
        try {
            this.requestor.request((AbstractJmsRequest)new AddClientIDRequest(clientID));
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, "", (Throwable)e);
            }
            throw new InvalidClientIDException("The JMS client specifies a duplicate client ID \"" + clientID + "\". " + e.getMessage());
        }
    }

    @Override
    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientID;
    }

    public javax.jms.ConnectionMetaData getMetaData() throws JMSException {
        this.lockClientId();
        this.checkClosed();
        if (this.metaData == null) {
            this.metaData = new ConnectionMetaData();
        }
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".start()");
        }
        this.checkClosed();
        Connection connection = this;
        synchronized (connection) {
            if (this.status == 1) {
                return;
            }
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "--- " + this + ": starting...");
        }
        for (int i = 0; i < this.sessions.size(); ++i) {
            Session session = this.sessions.elementAt(i);
            session.start();
        }
        Connection connection2 = this;
        synchronized (connection2) {
            this.mtpx.sendRequest((AbstractJmsRequest)new CnxStartRequest());
            this.setStatus(1);
        }
        this.lockClientId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".stop()");
        }
        this.checkClosed();
        Connection connection = this;
        synchronized (connection) {
            if (this.status == 0) {
                return;
            }
        }
        for (int i = 0; i < this.sessions.size(); ++i) {
            Session session = this.sessions.get(i);
            session.stop();
        }
        Connection connection2 = this;
        synchronized (connection2) {
            if (this.status == 0) {
                return;
            }
            this.mtpx.sendRequest((AbstractJmsRequest)new CnxStopRequest());
            this.setStatus(0);
        }
        this.lockClientId();
    }

    @Override
    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".close()");
        }
        this.lockClientId();
        if (this.checkThread()) {
            throw new IllegalStateException("Cannot close connection");
        }
        this.unregisterMBean();
        this.closer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClose() {
        block18: {
            Connection connection = this;
            synchronized (connection) {
                if (this.status == 2) {
                    return;
                }
            }
            Vector sessionsToClose = (Vector)this.sessions.clone();
            this.sessions.clear();
            this.mtpx.closing();
            for (int i = 0; i < sessionsToClose.size(); ++i) {
                Session session = (Session)sessionsToClose.elementAt(i);
                try {
                    session.close();
                    continue;
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                }
            }
            Vector consumersToClose = (Vector)this.cconsumers.clone();
            this.cconsumers.clear();
            for (int i = 0; i < consumersToClose.size(); ++i) {
                MultiSessionConsumer consumer = (MultiSessionConsumer)consumersToClose.elementAt(i);
                try {
                    consumer.close();
                    continue;
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                }
            }
            try {
                CnxCloseRequest closeReq = new CnxCloseRequest();
                this.requestor.request((AbstractJmsRequest)closeReq);
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block18;
                logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
            }
        }
        this.mtpx.close();
        Connection connection = this;
        synchronized (connection) {
            this.setStatus(2);
        }
        if (tracker.isLoggable(BasicLevel.DEBUG)) {
            tracker.log(BasicLevel.DEBUG, this.stringImage + " closed.", (Throwable)new Exception());
        } else if (tracker.isLoggable(BasicLevel.INFO)) {
            tracker.log(BasicLevel.INFO, this.stringImage + " closed.");
        }
    }

    public void cleanup(boolean close) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".cleanup(" + close + ")");
        }
        if (close) {
            Vector sessionsToClose = (Vector)this.sessions.clone();
            this.sessions.clear();
            for (int i = 0; i < sessionsToClose.size(); ++i) {
                Session session = (Session)sessionsToClose.elementAt(i);
                try {
                    session.close();
                    continue;
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                }
            }
        }
        this.mtpx.cleanup();
    }

    String nextSessionId() {
        return this.sessionsC.nextValue();
    }

    String nextMessageId() {
        return this.messagesC.nextValue();
    }

    String nextSubName() {
        return this.subsC.nextValue();
    }

    synchronized void closeSession(Session session) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".closeSession(" + session + ')');
        }
        this.sessions.removeElement(session);
    }

    synchronized void closeConnectionConsumer(MultiSessionConsumer cc) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".closeConnectionConsumer(" + cc + ')');
        }
        this.cconsumers.removeElement(cc);
    }

    synchronized AbstractJmsReply syncRequest(AbstractJmsRequest request) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this.stringImage + ".syncRequest(" + request + ')');
        }
        return this.requestor.request(request);
    }

    synchronized void checkConsumers(String agentId) throws JMSException {
        for (int i = 0; i < this.sessions.size(); ++i) {
            Session sess = this.sessions.elementAt(i);
            sess.checkConsumers(agentId);
        }
    }

    protected final RequestMultiplexer getRequestMultiplexer() {
        return this.mtpx;
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("not yet implemented.");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new JMSException("not yet implemented.");
    }

    synchronized void openMessageConsumer(String targetName) {
        if (this.messageConsumers.containsKey(targetName)) {
            int count = this.messageConsumers.get(targetName);
            this.messageConsumers.put(targetName, count + 1);
        } else {
            this.messageConsumers.put(targetName, 1);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Connection.openMessageConsumer(" + targetName + ") count = " + this.messageConsumers.get(targetName));
        }
    }

    synchronized boolean isOpenMessageConsumer(String targetName) {
        return this.messageConsumers.containsKey(targetName);
    }

    synchronized boolean closeMessageConsumer(String targetName) {
        boolean ret = true;
        if (this.messageConsumers.containsKey(targetName)) {
            int count = this.messageConsumers.get(targetName);
            if (count > 1) {
                this.messageConsumers.put(targetName, count - 1);
                ret = false;
            } else {
                this.messageConsumers.remove(targetName);
            }
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "Connection.closeMessageConsumer(" + targetName + ") = " + ret);
        }
        return ret;
    }

    class Closer {
        Closer() {
        }

        synchronized void close() {
            Connection.this.doClose();
        }
    }

    class AtomicCounter {
        long value = 0L;
        StringBuffer strbuf;
        int initial;

        AtomicCounter(String prefix) {
            this.strbuf = new StringBuffer(prefix.length() + 20);
            this.strbuf.append(prefix);
            this.initial = this.strbuf.length();
        }

        synchronized String nextValue() {
            this.strbuf.setLength(this.initial);
            this.strbuf.append(this.value++);
            return this.strbuf.toString();
        }
    }

    private static class Status {
        public static final int STOP = 0;
        public static final int START = 1;
        public static final int CLOSE = 2;
        private static final String[] names = new String[]{"STOP", "START", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

