/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.Session;

class ContextConnection {
    private int counter = 0;
    private boolean autoStart = true;
    private Connection connection = null;
    private boolean lockClientID = false;

    void lockClientID() {
        this.lockClientID = true;
    }

    ContextConnection(javax.jms.Connection connection) {
        this.connection = (Connection)connection;
    }

    public synchronized Session createSession() throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Underlying connection is closed");
        }
        try {
            Session session = (Session)this.connection.createSession();
            return session;
        }
        finally {
            ++this.counter;
        }
    }

    synchronized Session createSession(int mode) throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Underlying connection is closed");
        }
        try {
            Session session = (Session)this.connection.createSession(mode);
            return session;
        }
        finally {
            ++this.counter;
        }
    }

    synchronized void close() throws JMSException {
        if (this.connection == null) {
            throw new JMSException("Underlying connection is closed");
        }
        if (--this.counter <= 0) {
            try {
                this.connection.close();
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void start() {
        try {
            if (this.connection == null) {
                throw new JMSException("Underlying connection is closed");
            }
            this.connection.start();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Cannot start connection", e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        try {
            if (this.connection == null) {
                throw new JMSException("Underlying connection is closed");
            }
            this.connection.stop();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException("Unable to close context", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Cannot stop connection", e.getMessage(), (Throwable)e);
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            if (this.connection == null) {
                throw new JMSException("Underlying connection is closed");
            }
            return this.connection.getMetaData();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            if (this.connection == null) {
                throw new JMSException("Underlying connection is closed");
            }
            return this.connection.getExceptionListener();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        try {
            if (this.connection == null) {
                throw new JMSException("Underlying connection is closed");
            }
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public String getClientID() {
        try {
            if (this.connection == null) {
                throw new JMSException("Underlying connection is closed");
            }
            return this.connection.getClientID();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public void setClientID(String clientID) {
        try {
            if (this.lockClientID) {
                throw new IllegalStateException("ClientID is already set by the provider.");
            }
            if (this.connection == null) {
                throw new JMSException("Underlying connection is closed");
            }
            this.connection.setClientID(clientID);
            this.lockClientID = true;
        }
        catch (InvalidClientIDException e) {
            throw new InvalidClientIDRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    synchronized void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    synchronized boolean getAutoStart() {
        return this.autoStart;
    }
}

