/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.net.SocketFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.MessageInterceptor;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class FactoryParameters
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Debug.getLogger((String)FactoryParameters.class.getName());
    private String host;
    private int port;
    private String url;
    public String clientID = null;
    public boolean TcpNoDelay = true;
    public int SoLinger = -1;
    public int SoTimeout = 0;
    public int connectingTimer = 30;
    public int txPendingTimer = 0;
    public int cnxPendingTimer = 0;
    public String socketFactory = SocketFactory.DefaultFactory;
    public boolean implicitAck;
    public boolean asyncSend = false;
    public int queueMessageReadMax = 1;
    public int topicAckBufferMax = 10;
    public boolean multiThreadSync = false;
    public int multiThreadSyncDelay = 1;
    public int multiThreadSyncThreshold = 10;
    public int topicPassivationThreshold = Integer.MAX_VALUE;
    public int topicActivationThreshold = 0;
    public String outLocalAddress = null;
    public int outLocalPort = 0;
    public final List<MessageInterceptor> inInterceptors = new ArrayList<MessageInterceptor>();
    public final List<MessageInterceptor> outInterceptors = new ArrayList<MessageInterceptor>();
    public int compressedMinSize = 0;
    public int compressionLevel = 1;
    public boolean noAckedQueue = false;
    public String messageIdPrefix = null;
    private static final String INTERCEPTOR_CLASS_NAME_SEPARATOR = ",";

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMessageIdPrefix() {
        return this.messageIdPrefix;
    }

    public void setMessageIdPrefix(String messageIdPrefix) {
        this.messageIdPrefix = messageIdPrefix;
    }

    public FactoryParameters(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public FactoryParameters(String url) {
        this.url = url;
        this.host = "";
        this.port = -1;
    }

    public FactoryParameters() {
    }

    public void toReference(Reference ref, String prefix) {
        ref.add(new StringRefAddr(prefix + ".host", this.getHost()));
        ref.add(new StringRefAddr(prefix + ".port", Integer.valueOf(this.getPort()).toString()));
        ref.add(new StringRefAddr(prefix + ".url", this.getUrl()));
        ref.add(new StringRefAddr(prefix + ".clientID", this.clientID));
        ref.add(new StringRefAddr(prefix + ".TcpNoDelay", Boolean.valueOf(this.TcpNoDelay).toString()));
        ref.add(new StringRefAddr(prefix + ".SoLinger", Integer.valueOf(this.SoLinger).toString()));
        ref.add(new StringRefAddr(prefix + ".SoTimeout", Integer.valueOf(this.SoTimeout).toString()));
        ref.add(new StringRefAddr(prefix + ".cnxT", Integer.valueOf(this.connectingTimer).toString()));
        ref.add(new StringRefAddr(prefix + ".txT", Integer.valueOf(this.txPendingTimer).toString()));
        ref.add(new StringRefAddr(prefix + ".cnxPT", Integer.valueOf(this.cnxPendingTimer).toString()));
        ref.add(new StringRefAddr(prefix + ".socketFactory", this.socketFactory));
        ref.add(new StringRefAddr(prefix + ".implicitAck", Boolean.valueOf(this.implicitAck).toString()));
        ref.add(new StringRefAddr(prefix + ".asyncSend", Boolean.valueOf(this.asyncSend).toString()));
        ref.add(new StringRefAddr(prefix + ".queueMessageReadMax", Integer.valueOf(this.queueMessageReadMax).toString()));
        ref.add(new StringRefAddr(prefix + ".topicAckBufferMax", Integer.valueOf(this.topicAckBufferMax).toString()));
        ref.add(new StringRefAddr(prefix + ".multiThreadSync", Boolean.valueOf(this.multiThreadSync).toString()));
        ref.add(new StringRefAddr(prefix + ".multiThreadSyncDelay", Integer.valueOf(this.multiThreadSyncDelay).toString()));
        ref.add(new StringRefAddr(prefix + ".multiThreadSyncThreshold", Integer.valueOf(this.multiThreadSyncThreshold).toString()));
        ref.add(new StringRefAddr(prefix + ".topicPassivationThreshold", Integer.valueOf(this.topicPassivationThreshold).toString()));
        ref.add(new StringRefAddr(prefix + ".topicActivationThreshold", Integer.valueOf(this.topicActivationThreshold).toString()));
        ref.add(new StringRefAddr(prefix + ".compressedMinSize", Integer.valueOf(this.compressedMinSize).toString()));
        ref.add(new StringRefAddr(prefix + ".compressionLevel", Integer.valueOf(this.compressionLevel).toString()));
        ref.add(new StringRefAddr(prefix + ".noAckedQueue", Boolean.valueOf(this.noAckedQueue).toString()));
        ref.add(new StringRefAddr(prefix + ".outLocalPort", Integer.valueOf(this.outLocalPort).toString()));
        if (this.outLocalAddress != null) {
            ref.add(new StringRefAddr(prefix + ".outLocalAddress", this.outLocalAddress));
        }
        if (this.inInterceptors != null && !this.inInterceptors.isEmpty()) {
            ref.add(new StringRefAddr(prefix + ".inInterceptors", this.getListInInterceptorClassName()));
        }
        if (this.outInterceptors != null && !this.outInterceptors.isEmpty()) {
            ref.add(new StringRefAddr(prefix + ".outInterceptors", this.getListOutInterceptorClassName()));
        }
        if (this.messageIdPrefix != null) {
            ref.add(new StringRefAddr(prefix + ".messageIdPrefix", this.messageIdPrefix));
        }
    }

    public void fromReference(Reference ref, String prefix) {
        RefAddr messageIdPrefixRef;
        RefAddr interceptorRef;
        this.host = (String)ref.get(prefix + ".host").getContent();
        this.port = Integer.valueOf((String)ref.get(prefix + ".port").getContent());
        this.url = (String)ref.get(prefix + ".url").getContent();
        this.clientID = (String)ref.get(prefix + ".clientID").getContent();
        this.TcpNoDelay = Boolean.valueOf((String)ref.get(prefix + ".TcpNoDelay").getContent());
        this.SoLinger = Integer.valueOf((String)ref.get(prefix + ".SoLinger").getContent());
        this.SoTimeout = Integer.valueOf((String)ref.get(prefix + ".SoTimeout").getContent());
        this.connectingTimer = Integer.valueOf((String)ref.get(prefix + ".cnxT").getContent());
        this.txPendingTimer = Integer.valueOf((String)ref.get(prefix + ".txT").getContent());
        this.cnxPendingTimer = Integer.valueOf((String)ref.get(prefix + ".cnxPT").getContent());
        this.socketFactory = (String)ref.get(prefix + ".socketFactory").getContent();
        this.implicitAck = Boolean.valueOf((String)ref.get(prefix + ".implicitAck").getContent());
        this.asyncSend = Boolean.valueOf((String)ref.get(prefix + ".asyncSend").getContent());
        this.queueMessageReadMax = Integer.valueOf((String)ref.get(prefix + ".queueMessageReadMax").getContent());
        this.topicAckBufferMax = Integer.valueOf((String)ref.get(prefix + ".topicAckBufferMax").getContent());
        this.multiThreadSync = Boolean.valueOf((String)ref.get(prefix + ".multiThreadSync").getContent());
        this.multiThreadSyncDelay = Integer.valueOf((String)ref.get(prefix + ".multiThreadSyncDelay").getContent());
        this.multiThreadSyncThreshold = Integer.valueOf((String)ref.get(prefix + ".multiThreadSyncThreshold").getContent());
        this.topicPassivationThreshold = Integer.valueOf((String)ref.get(prefix + ".topicPassivationThreshold").getContent());
        this.topicActivationThreshold = Integer.valueOf((String)ref.get(prefix + ".topicActivationThreshold").getContent());
        this.compressedMinSize = Integer.valueOf((String)ref.get(prefix + ".compressedMinSize").getContent());
        this.compressionLevel = Integer.valueOf((String)ref.get(prefix + ".compressionLevel").getContent());
        this.noAckedQueue = Boolean.valueOf((String)ref.get(prefix + ".noAckedQueue").getContent());
        this.outLocalPort = Integer.valueOf((String)ref.get(prefix + ".outLocalPort").getContent());
        RefAddr outLocalAddressRef = ref.get(prefix + ".outLocalAddress");
        if (outLocalAddressRef != null) {
            this.outLocalAddress = (String)outLocalAddressRef.getContent();
        }
        if ((interceptorRef = ref.get(prefix + ".inInterceptors")) != null) {
            this.setListInInterceptorClassName((String)interceptorRef.getContent());
        }
        if ((interceptorRef = ref.get(prefix + ".outInterceptors")) != null) {
            this.setListOutInterceptorClassName((String)interceptorRef.getContent());
        }
        if ((messageIdPrefixRef = ref.get(prefix + ".messageIdPrefix")) != null) {
            this.messageIdPrefix = (String)messageIdPrefixRef.getContent();
        }
    }

    public Hashtable<String, Object> code(Hashtable<String, Object> h, String prefix) {
        if (this.getHost() != null) {
            h.put(prefix + ".host", this.getHost());
        }
        h.put(prefix + ".port", this.getPort());
        if (this.getUrl() != null) {
            h.put(prefix + ".url", this.getUrl());
        }
        h.put(prefix + ".clientID", this.clientID);
        h.put(prefix + ".TcpNoDelay", this.TcpNoDelay);
        h.put(prefix + ".SoLinger", this.SoLinger);
        h.put(prefix + ".SoTimeout", this.SoTimeout);
        h.put(prefix + ".connectingTimer", this.connectingTimer);
        h.put(prefix + ".txPendingTimer", this.txPendingTimer);
        h.put(prefix + ".cnxPendingTimer", this.cnxPendingTimer);
        h.put(prefix + ".socketFactory", this.socketFactory);
        h.put(prefix + ".implicitAck", this.implicitAck);
        h.put(prefix + ".asyncSend", this.asyncSend);
        h.put(prefix + ".queueMessageReadMax", this.queueMessageReadMax);
        h.put(prefix + ".topicAckBufferMax", this.topicAckBufferMax);
        h.put(prefix + ".multiThreadSync", this.multiThreadSync);
        h.put(prefix + ".multiThreadSyncDelay", this.multiThreadSyncDelay);
        h.put(prefix + ".multiThreadSyncThreshold", this.multiThreadSyncThreshold);
        h.put(prefix + ".topicPassivationThreshold", this.topicPassivationThreshold);
        h.put(prefix + ".topicActivationThreshold", this.topicActivationThreshold);
        h.put(prefix + ".compressedMinSize", this.compressedMinSize);
        h.put(prefix + ".compressionLevel", this.compressionLevel);
        h.put(prefix + ".noAckedQueue", this.noAckedQueue);
        h.put(prefix + ".outLocalPort", this.outLocalPort);
        if (this.outLocalAddress != null) {
            h.put(prefix + ".outLocalAddress", this.outLocalAddress);
        }
        if (this.inInterceptors != null && !this.inInterceptors.isEmpty()) {
            h.put(prefix + ".inInterceptors", this.getListInInterceptorClassName());
        }
        if (this.outInterceptors != null && !this.outInterceptors.isEmpty()) {
            h.put(prefix + ".outInterceptors", this.getListOutInterceptorClassName());
        }
        if (this.messageIdPrefix != null) {
            h.put(prefix + ".messageIdPrefix", this.messageIdPrefix);
        }
        return h;
    }

    public void decode(Hashtable<String, Object> h, String prefix) {
        this.host = (String)h.get(prefix + ".host");
        this.port = (Integer)h.get(prefix + ".port");
        this.url = (String)h.get(prefix + ".url");
        this.clientID = (String)h.get(prefix + ".clientID");
        this.TcpNoDelay = (Boolean)h.get(prefix + ".TcpNoDelay");
        this.SoLinger = (Integer)h.get(prefix + ".SoLinger");
        this.SoTimeout = (Integer)h.get(prefix + ".SoTimeout");
        this.connectingTimer = (Integer)h.get(prefix + ".connectingTimer");
        this.txPendingTimer = (Integer)h.get(prefix + ".txPendingTimer");
        this.cnxPendingTimer = (Integer)h.get(prefix + ".cnxPendingTimer");
        this.socketFactory = (String)h.get(prefix + ".socketFactory");
        this.implicitAck = (Boolean)h.get(prefix + ".implicitAck");
        this.asyncSend = (Boolean)h.get(prefix + ".asyncSend");
        this.queueMessageReadMax = (Integer)h.get(prefix + ".queueMessageReadMax");
        this.topicAckBufferMax = (Integer)h.get(prefix + ".topicAckBufferMax");
        this.multiThreadSync = (Boolean)h.get(prefix + ".multiThreadSync");
        this.multiThreadSyncDelay = (Integer)h.get(prefix + ".multiThreadSyncDelay");
        this.multiThreadSyncThreshold = (Integer)h.get(prefix + ".multiThreadSyncThreshold");
        this.topicPassivationThreshold = (Integer)h.get(prefix + ".topicPassivationThreshold");
        this.topicActivationThreshold = (Integer)h.get(prefix + ".topicActivationThreshold");
        this.compressedMinSize = (Integer)h.get(prefix + ".compressedMinSize");
        this.compressionLevel = (Integer)h.get(prefix + ".compressionLevel");
        this.noAckedQueue = (Boolean)h.get(prefix + ".noAckedQueue");
        this.outLocalPort = (Integer)h.get(prefix + ".outLocalPort");
        this.outLocalAddress = (String)h.get(prefix + ".outLocalAddress");
        String listInterceptorClassNames = (String)h.get(prefix + ".inInterceptors");
        if (listInterceptorClassNames != null) {
            this.setListInInterceptorClassName(listInterceptorClassNames);
        }
        if ((listInterceptorClassNames = (String)h.get(prefix + ".outInterceptors")) != null) {
            this.setListOutInterceptorClassName(listInterceptorClassNames);
        }
        this.messageIdPrefix = (String)h.get(prefix + ".messageIdPrefix");
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",host=").append(this.host);
        strbuf.append(",port=").append(this.port);
        strbuf.append(",url=").append(this.url);
        strbuf.append(",connectingTimer=").append(this.connectingTimer);
        strbuf.append(",txPendingTimer=").append(this.txPendingTimer);
        strbuf.append(",cnxPendingTimer=").append(this.cnxPendingTimer);
        strbuf.append(",implicitAck=").append(this.implicitAck);
        strbuf.append(",asyncSend=").append(this.asyncSend);
        strbuf.append(",queueMessageReadMax=").append(this.queueMessageReadMax);
        strbuf.append(",topicAckBufferMax=").append(this.topicAckBufferMax);
        strbuf.append(",multiThreadSync=").append(this.multiThreadSync);
        strbuf.append(",multiThreadSyncDelay=").append(this.multiThreadSyncDelay);
        strbuf.append(",multiThreadSyncThreshold=").append(this.multiThreadSyncThreshold);
        strbuf.append(",topicPassivationThreshold=").append(this.topicPassivationThreshold);
        strbuf.append(",topicActivationThreshold=").append(this.topicActivationThreshold);
        strbuf.append(",compressedMinSize=").append(this.compressedMinSize);
        strbuf.append(",compressionLevel=").append(this.compressionLevel);
        strbuf.append(",noAckedQueue=").append(this.noAckedQueue);
        strbuf.append(",outLocalAddress=").append(this.outLocalAddress);
        strbuf.append(",outLocalPort=").append(this.outLocalPort);
        if (this.inInterceptors != null) {
            strbuf.append(",inInterceptors=").append(this.getListInInterceptorClassName());
        }
        if (this.outInterceptors != null) {
            strbuf.append(",outInterceptors=").append(this.getListOutInterceptorClassName());
        }
        if (this.messageIdPrefix != null) {
            strbuf.append(",messageIdPrefix=").append(this.messageIdPrefix);
        }
        return strbuf.toString();
    }

    public void addInInterceptor(String pInterceptorClassName) {
        this.addInterceptor(pInterceptorClassName, this.inInterceptors);
    }

    public void addOutInterceptor(String pInterceptorClassName) {
        this.addInterceptor(pInterceptorClassName, this.outInterceptors);
    }

    private void addInterceptor(String pInterceptorClassName, List<MessageInterceptor> pInterceptors) {
        if (pInterceptorClassName != null) {
            try {
                pInterceptors.add((MessageInterceptor)Class.forName(pInterceptorClassName).newInstance());
            }
            catch (Throwable t) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.WARN, "Cannot set interceptor: " + pInterceptorClassName, t);
                }
                logger.log(BasicLevel.WARN, "Cannot set interceptor: " + pInterceptorClassName + ": " + t.getMessage());
            }
        }
    }

    public boolean removeInInterceptor(String pInterceptorClassName) {
        return this.removeInterceptor(pInterceptorClassName, this.inInterceptors);
    }

    public boolean removeOutInterceptor(String pInterceptorClassName) {
        return this.removeInterceptor(pInterceptorClassName, this.outInterceptors);
    }

    public boolean removeInterceptor(String pInterceptorClassName, List<MessageInterceptor> pInterceptors) {
        boolean removed = false;
        if (pInterceptorClassName != null) {
            Iterator<MessageInterceptor> it = pInterceptors.iterator();
            while (it.hasNext()) {
                if (!pInterceptorClassName.equals(it.next().getClass().getName())) continue;
                removed = true;
                it.remove();
            }
        }
        return removed;
    }

    private String getListInInterceptorClassName() {
        return this.getListInterceptorClassName(this.inInterceptors);
    }

    private String getListOutInterceptorClassName() {
        return this.getListInterceptorClassName(this.outInterceptors);
    }

    private String getListInterceptorClassName(List<MessageInterceptor> pInterceptors) {
        if (pInterceptors != null && !pInterceptors.isEmpty()) {
            StringBuffer cns = new StringBuffer();
            Iterator<MessageInterceptor> it = pInterceptors.iterator();
            while (it.hasNext()) {
                cns.append(it.next().getClass().getName());
                if (!it.hasNext()) continue;
                cns.append(INTERCEPTOR_CLASS_NAME_SEPARATOR);
            }
            return cns.toString();
        }
        return null;
    }

    private void setListInInterceptorClassName(String pListInterceptorClassName) {
        this.setListInterceptorClassName(pListInterceptorClassName, this.inInterceptors);
    }

    private void setListOutInterceptorClassName(String pListInterceptorClassName) {
        this.setListInterceptorClassName(pListInterceptorClassName, this.outInterceptors);
    }

    private void setListInterceptorClassName(String pListInterceptorClassName, List<MessageInterceptor> pInterceptors) {
        if (pListInterceptorClassName != null) {
            StringTokenizer cns = new StringTokenizer(pListInterceptorClassName, INTERCEPTOR_CLASS_NAME_SEPARATOR);
            while (cns.hasMoreTokens()) {
                this.addInterceptor(cns.nextToken(), pInterceptors);
            }
        }
    }

    public void setParameters(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = properties.getProperty(name);
            try {
                if ("cnxPendingTimer".equals(name)) {
                    this.cnxPendingTimer = Integer.valueOf(value);
                    continue;
                }
                if ("connectingTimer".equals(name)) {
                    this.connectingTimer = Integer.valueOf(value);
                    continue;
                }
                if ("asyncSend".equals(name)) {
                    this.asyncSend = Boolean.valueOf(value);
                    continue;
                }
                if ("txPendingTimer".equals(name)) {
                    this.txPendingTimer = Integer.valueOf(value);
                    continue;
                }
                if ("implicitAck".equals(name)) {
                    this.implicitAck = Boolean.valueOf(value);
                    continue;
                }
                if ("multiThreadSync".equals(name)) {
                    this.multiThreadSync = Boolean.valueOf(value);
                    continue;
                }
                if ("multiThreadSyncDelay".equals(name)) {
                    this.multiThreadSyncDelay = Integer.valueOf(value);
                    continue;
                }
                if ("multiThreadSyncThreshold".equals(name)) {
                    this.multiThreadSyncThreshold = Integer.valueOf(value);
                    continue;
                }
                if ("queueMessageReadMax".equals(name)) {
                    this.queueMessageReadMax = Integer.valueOf(value);
                    continue;
                }
                if ("topicAckBufferMax".equals(name)) {
                    this.topicAckBufferMax = Integer.valueOf(value);
                    continue;
                }
                if ("topicActivationThreshold".equals(name)) {
                    this.topicActivationThreshold = Integer.valueOf(value);
                    continue;
                }
                if ("topicPassivationThreshold".equals(name)) {
                    this.topicPassivationThreshold = Integer.valueOf(value);
                    continue;
                }
                if ("SoTimeout".equals(name)) {
                    this.SoTimeout = Integer.valueOf(value);
                    continue;
                }
                if ("TcpNoDelay".equals(name)) {
                    this.TcpNoDelay = Boolean.valueOf(value);
                    continue;
                }
                if ("SoLinger".equals(name)) {
                    this.SoLinger = Integer.valueOf(value);
                    continue;
                }
                if ("compressedMinSize".equals(name)) {
                    this.compressedMinSize = Integer.valueOf(value);
                    continue;
                }
                if ("compressionLevel".equals(name)) {
                    this.compressionLevel = Integer.valueOf(value);
                    continue;
                }
                if ("noAckedQueue".equals(name)) {
                    this.noAckedQueue = Boolean.valueOf(value);
                    continue;
                }
                if ("outLocalPort".equals(name)) {
                    this.outLocalPort = Integer.valueOf(value);
                    continue;
                }
                if ("outLocalAddress".equals(name)) {
                    this.outLocalAddress = value;
                    continue;
                }
                if ("clientID".equals(name)) {
                    this.clientID = value;
                    continue;
                }
                if ("messageIdPrefix".equals(name)) {
                    this.messageIdPrefix = value;
                    continue;
                }
                logger.log(BasicLevel.ERROR, "Could not set FactoryParameters <" + name + ", " + value + ">", (Throwable)new Exception("Unknow parameter: " + name));
            }
            catch (NumberFormatException exc) {
                logger.log(BasicLevel.ERROR, "Could not set FactoryParameters <" + name + ", " + value + ">", (Throwable)exc);
            }
        }
    }
}

