/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageListener;

public class JMSConsumer
implements javax.jms.JMSConsumer {
    private MessageConsumer consumer;

    public JMSConsumer(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to close JMSConsumer", e.getMessage(), (Throwable)e);
        }
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        try {
            return this.consumer.getMessageListener();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to get message listener", e.getMessage(), (Throwable)e);
        }
    }

    public String getMessageSelector() {
        try {
            return this.consumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }

    public Message receive() {
        Message message = null;
        try {
            message = this.consumer.receive();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to receive message", e.getMessage(), (Throwable)e);
        }
        return message;
    }

    public Message receive(long timeout) {
        Message message = null;
        try {
            message = this.consumer.receive(timeout);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to receive message", e.getMessage(), (Throwable)e);
        }
        return message;
    }

    public <T> T receiveBody(Class<T> c) {
        try {
            Message message = this.receive();
            if (message != null) {
                Object body = message.getBody(c);
                if (body == null) {
                    throw new MessageFormatRuntimeException("Message has no body.");
                }
                return (T)body;
            }
            return null;
        }
        catch (MessageFormatException e) {
            throw new MessageFormatRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new MessageFormatRuntimeException("Unable to get message body", e.getMessage(), (Throwable)e);
        }
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        try {
            Message message = this.receive(timeout);
            if (message != null) {
                Object body = message.getBody(c);
                if (body == null) {
                    throw new MessageFormatRuntimeException("Message has no body.");
                }
                return (T)body;
            }
            return null;
        }
        catch (MessageFormatException e) {
            throw new MessageFormatRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new MessageFormatRuntimeException("Unable to get message body", e.getMessage(), (Throwable)e);
        }
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        Message m = this.receiveNoWait();
        if (m != null) {
            try {
                return (T)m.getBody(c);
            }
            catch (JMSException e) {
                throw new MessageFormatRuntimeException("Unable to get message body", e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public Message receiveNoWait() {
        Message message = null;
        try {
            message = this.consumer.receiveNoWait();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to receive message", e.getMessage(), (Throwable)e);
        }
        return message;
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        try {
            this.consumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to set message listener", e.getMessage(), (Throwable)e);
        }
    }
}

