/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.InvalidSelectorException;
import javax.jms.InvalidSelectorRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.management.JMRuntimeException;
import org.objectweb.joram.client.jms.ContextConnection;
import org.objectweb.joram.client.jms.JMSConsumer;
import org.objectweb.joram.client.jms.JMSProducer;
import org.objectweb.joram.client.jms.MessageConsumer;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JMSContext
implements javax.jms.JMSContext {
    public static Logger logger = Debug.getLogger((String)JMSContext.class.getName());
    private boolean closed = false;
    private ContextConnection connection = null;
    private Session session = null;

    public javax.jms.JMSContext createContext(int sessionMode) {
        return new JMSContext(this.connection, sessionMode);
    }

    public JMSContext(ContextConnection connection, int sessionMode) {
        this.connection = connection;
        try {
            this.session = connection.createSession(sessionMode);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "JMSContext created ");
            }
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, "JMSContext not created ", (Throwable)e);
            }
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public JMSContext(Connection cnx) {
        this.connection = new ContextConnection(cnx);
        try {
            this.session = this.connection.createSession();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "JMSContext created parameters[ Connection = " + this.connection + " | session = " + this.session + ", " + this.session.transacted + ", " + this.session.getSessionMode() + " ] ");
            }
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, "JMSContext not created ", (Throwable)e);
            }
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public JMSContext(Connection cnx, int sessionMode) {
        this.connection = new ContextConnection(cnx);
        try {
            this.session = this.connection.createSession(sessionMode);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "JMSContext created ");
            }
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, "JMSContext not created ", (Throwable)e);
            }
            throw new JMSRuntimeException("Unable to create JMSContext", e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.connection.lockClientID();
        if (this.session.checkThread()) {
            throw new IllegalStateRuntimeException("Cannot stop context from listener");
        }
        try {
            this.session.close();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException("Unable to close context: " + e.getMessage(), null, (Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to close context: " + e.getMessage(), null, (Throwable)e);
        }
        try {
            this.connection.close();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException("Unable to close context: " + e.getMessage(), null, (Throwable)e);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to close context: " + e.getMessage(), null, (Throwable)e);
        }
        this.closed = true;
    }

    public void acknowledge() {
        this.connection.lockClientID();
        try {
            this.session.acknowledge();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException("Unable to acknowledge", e.getMessage(), (Throwable)e);
        }
        catch (JMSException e) {
            logger.log(BasicLevel.ERROR, "Unable to acknowledge", (Throwable)e);
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public void commit() {
        this.connection.lockClientID();
        try {
            this.session.commit();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public void recover() {
        this.connection.lockClientID();
        try {
            this.session.recover();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public void rollback() {
        this.connection.lockClientID();
        try {
            this.session.rollback();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public Message createMessage() {
        this.connection.lockClientID();
        try {
            return this.session.createMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create message", e.getMessage(), (Throwable)e);
        }
    }

    public BytesMessage createBytesMessage() {
        this.connection.lockClientID();
        try {
            return this.session.createBytesMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create byte message " + e.getMessage());
        }
    }

    public MapMessage createMapMessage() {
        this.connection.lockClientID();
        try {
            return this.session.createMapMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create message", e.getMessage(), (Throwable)e);
        }
    }

    public ObjectMessage createObjectMessage() {
        this.connection.lockClientID();
        try {
            return this.session.createObjectMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create message", e.getMessage(), (Throwable)e);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        this.connection.lockClientID();
        try {
            return this.session.createObjectMessage(object);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create message", e.getMessage(), (Throwable)e);
        }
    }

    public TextMessage createTextMessage() {
        this.connection.lockClientID();
        try {
            return this.session.createTextMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create message", e.getMessage(), (Throwable)e);
        }
    }

    public TextMessage createTextMessage(String text) {
        this.connection.lockClientID();
        try {
            return this.session.createTextMessage(text);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create message", e.getMessage(), (Throwable)e);
        }
    }

    public StreamMessage createStreamMessage() {
        this.connection.lockClientID();
        try {
            return this.session.createStreamMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create message", e.getMessage(), (Throwable)e);
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        this.connection.lockClientID();
        try {
            return this.session.createTemporaryQueue();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create temporary queue", e.getMessage(), (Throwable)e);
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        this.connection.lockClientID();
        try {
            return this.session.createTemporaryTopic();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create temporary topic", e.getMessage(), (Throwable)e);
        }
    }

    public Queue createQueue(String name) {
        this.connection.lockClientID();
        try {
            return this.session.createQueue(name);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create queue: " + name, e.getMessage(), (Throwable)e);
        }
    }

    public Topic createTopic(String name) {
        this.connection.lockClientID();
        try {
            return this.session.createTopic(name);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create topic: " + name, e.getMessage(), (Throwable)e);
        }
    }

    public boolean getAutoStart() {
        this.connection.lockClientID();
        return this.connection.getAutoStart();
    }

    public void setAutoStart(boolean autoStart) {
        this.connection.lockClientID();
        this.connection.setAutoStart(autoStart);
    }

    public javax.jms.JMSConsumer createConsumer(Destination destination) {
        return this.createConsumer(destination, null);
    }

    public javax.jms.JMSConsumer createConsumer(Destination destination, String selector) {
        return this.createConsumer(destination, selector, false);
    }

    public javax.jms.JMSConsumer createConsumer(Destination destination, String selector, boolean noLocal) {
        this.connection.lockClientID();
        try {
            MessageConsumer consumer = (MessageConsumer)this.session.createConsumer(destination, selector, noLocal);
            JMSConsumer jMSConsumer = new JMSConsumer(consumer);
            return jMSConsumer;
        }
        catch (InvalidDestinationException e) {
            throw new InvalidDestinationRuntimeException(e.getMessage());
        }
        catch (InvalidSelectorException e) {
            throw new InvalidSelectorRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Unable to instantiate a JMSConsumer" + e.getMessage());
            }
            throw new JMSRuntimeException("Unable to instantiate a JMSConsumer");
        }
        finally {
            if (this.connection.getAutoStart()) {
                this.connection.start();
            }
        }
    }

    public QueueBrowser createBrowser(Queue queue) {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        this.connection.lockClientID();
        try {
            return this.session.createBrowser(queue, messageSelector);
        }
        catch (InvalidDestinationException e) {
            throw new InvalidDestinationRuntimeException(e.getMessage());
        }
        catch (InvalidSelectorException e) {
            throw new InvalidSelectorRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public javax.jms.JMSConsumer createDurableConsumer(Topic topic, String name) {
        return this.createDurableConsumer(topic, name, null, false);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String selector, boolean noLocal) {
        this.connection.lockClientID();
        try {
            MessageConsumer consumer = (MessageConsumer)this.session.createDurableConsumer(topic, name, selector, noLocal);
            JMSConsumer jMSConsumer = new JMSConsumer(consumer);
            return jMSConsumer;
        }
        catch (InvalidDestinationException e) {
            throw new InvalidDestinationRuntimeException(e.getMessage());
        }
        catch (InvalidSelectorException e) {
            throw new InvalidSelectorRuntimeException(e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Unable to instantiate a JMSConsumer" + e.getMessage());
            }
            throw new JMSRuntimeException("Unable to instantiate a JMSConsumer");
        }
        finally {
            if (this.connection.getAutoStart()) {
                this.connection.start();
            }
        }
    }

    public JMSProducer createProducer() {
        this.connection.lockClientID();
        try {
            return new JMSProducer(this.session);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to create producer " + e.getMessage());
        }
    }

    public javax.jms.JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    public javax.jms.JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.connection.lockClientID();
        try {
            JMSConsumer jMSConsumer = new JMSConsumer(this.session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector));
            return jMSConsumer;
        }
        catch (InvalidDestinationException e) {
            throw new InvalidDestinationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (InvalidSelectorException e) {
            throw new InvalidSelectorRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Unable to crate shared consumer " + e.getMessage());
            }
            throw new JMSRuntimeException("Unable to create shared consumer " + e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        finally {
            if (this.connection.getAutoStart()) {
                this.connection.start();
            }
        }
    }

    public javax.jms.JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    public javax.jms.JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        this.connection.lockClientID();
        try {
            JMSConsumer jMSConsumer = new JMSConsumer(this.session.createSharedDurableConsumer(topic, name, messageSelector));
            return jMSConsumer;
        }
        catch (InvalidDestinationException e) {
            throw new InvalidDestinationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (InvalidSelectorException e) {
            throw new InvalidSelectorRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "Unable to crate shared durable consumer " + e.getMessage());
            }
            throw new JMSRuntimeException("Unable to create shared durable consumer " + e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        finally {
            if (this.connection.getAutoStart()) {
                this.connection.start();
            }
        }
    }

    private Session getCopyOfSession() {
        try {
            return this.connection.createSession(this.getSessionMode());
        }
        catch (JMSException e) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, "Unable to create a session " + e.getMessage());
            }
            throw new JMRuntimeException("Unable to create a session " + e.getMessage());
        }
    }

    public int getSessionMode() {
        this.connection.lockClientID();
        try {
            return this.session.getAcknowledgeMode();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to get session mode", e.getMessage(), (Throwable)e);
        }
    }

    public boolean getTransacted() {
        this.connection.lockClientID();
        return this.session.transacted;
    }

    public ConnectionMetaData getMetaData() {
        this.connection.lockClientID();
        return this.connection.getMetaData();
    }

    public String getClientID() {
        return this.connection.getClientID();
    }

    public void setClientID(String clientID) {
        this.connection.setClientID(clientID);
    }

    public ExceptionListener getExceptionListener() {
        this.connection.lockClientID();
        return this.connection.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.connection.lockClientID();
        this.connection.setExceptionListener(listener);
    }

    public void start() {
        this.connection.lockClientID();
        this.connection.start();
    }

    public void stop() {
        this.connection.lockClientID();
        if (this.session.checkThread()) {
            throw new IllegalStateRuntimeException("Cannot stop context from listener");
        }
        this.connection.stop();
    }

    public void unsubscribe(String name) {
        this.connection.lockClientID();
        try {
            this.session.unsubscribe(name);
        }
        catch (InvalidDestinationException exc) {
            throw new InvalidDestinationRuntimeException("Unable to unsubcribe to: " + name, exc.getMessage(), (Throwable)exc);
        }
        catch (JMSException exc) {
            throw new JMSRuntimeException("Unable to unsubcribe to: " + name, exc.getMessage(), (Throwable)exc);
        }
    }

    Session getSession() {
        return this.session;
    }
}

