/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.ObjectMessage;
import org.objectweb.joram.client.jms.MessageProducer;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.TextMessage;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JMSProducer
implements javax.jms.JMSProducer {
    public static Logger logger = Debug.getLogger((String)JMSProducer.class.getName());
    private CompletionListener completionListener = null;
    String jmsCorrelationID = null;
    private String jmsType = null;
    private MessageProducer messageProducer = null;
    private Map<String, Object> properties;
    private Destination replyTo = null;
    private Session session = null;

    public JMSProducer(Session session) throws JMSException {
        try {
            this.session = session;
            this.properties = new HashMap<String, Object>();
            this.messageProducer = new MessageProducer(this.session, null);
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, "JMSProducer created with [ producer = " + this.messageProducer + " | session = " + session + " ] ");
            }
        }
        catch (JMSException e) {
            logger.log(BasicLevel.DEBUG, "Unable to instantiate a JMSProducer" + e.getMessage());
            throw new JMSException("Unable to instantiate a JMSProducer");
        }
    }

    public javax.jms.JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    private void doSend(Destination destination, Message message) {
        try {
            message = this.writeCurrentProperties(message);
            if (this.getAsync() == null) {
                this.messageProducer.send(destination, message);
            } else {
                this.messageProducer.send(destination, message, this.completionListener);
            }
        }
        catch (MessageNotWriteableException e) {
            throw new MessageNotWriteableRuntimeException(e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidDestinationRuntimeException(e.getMessage());
        }
        catch (MessageFormatException e) {
            throw new MessageFormatRuntimeException(e.getMessage());
        }
        catch (InvalidDestinationException e) {
            throw new InvalidDestinationRuntimeException(e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new IllegalStateRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
    }

    public long getDeliveryDelay() {
        try {
            return this.messageProducer.getDeliveryDelay();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to get delivery delay");
        }
    }

    public int getDeliveryMode() {
        try {
            return this.messageProducer.getDeliveryMode();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to get delivery mode");
        }
    }

    public boolean getDisableMessageID() {
        try {
            return this.messageProducer.getDisableMessageID();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to get disable message id");
        }
    }

    public boolean getDisableMessageTimestamp() {
        try {
            return this.messageProducer.getDisableMessageTimestamp();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to get disable message timestamp");
        }
    }

    public String getJMSCorrelationID() {
        return this.jmsCorrelationID;
    }

    public javax.jms.JMSProducer setJMSCorrelationID(String correlationID) {
        this.jmsCorrelationID = correlationID;
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.jmsCorrelationID.getBytes();
    }

    public javax.jms.JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.jmsCorrelationID = ConversionHelper.toString((Object)correlationID);
        return this;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public int getPriority() {
        try {
            return this.messageProducer.getPriority();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to get priority");
        }
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public long getTimeToLive() {
        try {
            return this.messageProducer.getTimeToLive();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to get time to live");
        }
    }

    public boolean propertyExists(String name) {
        return this.properties.containsKey(name);
    }

    public javax.jms.JMSProducer send(Destination destination, byte[] body) {
        BytesMessage message = null;
        try {
            message = this.session.createBytesMessage();
            message.writeBytes(body);
        }
        catch (MessageNotWriteableException e) {
            throw new MessageNotWriteableRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
        this.doSend(destination, (Message)message);
        return this;
    }

    public javax.jms.JMSProducer send(Destination destination, Map<String, Object> body) {
        MapMessage message = null;
        try {
            message = this.session.createMapMessage();
            for (String key : body.keySet()) {
                message.setObject(key, body.get(key));
            }
        }
        catch (MessageFormatException e) {
            throw new MessageFormatRuntimeException(e.getMessage());
        }
        catch (MessageNotWriteableException e) {
            throw new MessageNotWriteableRuntimeException(e.getMessage());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
        this.doSend(destination, (Message)message);
        return this;
    }

    public javax.jms.JMSProducer send(Destination destination, Message message) {
        this.doSend(destination, message);
        return this;
    }

    public javax.jms.JMSProducer send(Destination destination, Serializable body) {
        ObjectMessage message = null;
        try {
            message = this.session.createObjectMessage(body);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
        this.doSend(destination, (Message)message);
        return this;
    }

    public javax.jms.JMSProducer send(Destination destination, String body) {
        try {
            TextMessage message = (TextMessage)this.session.createTextMessage(body);
            this.doSend(destination, message);
        }
        catch (JMSException e) {
            String errorMessage = "Unable to send message: " + body + " to " + destination + "using session: " + this.session;
            if (e instanceof MessageFormatException) {
                throw new MessageFormatRuntimeException(errorMessage);
            }
            if (e instanceof InvalidDestinationException) {
                throw new InvalidDestinationRuntimeException(errorMessage);
            }
            throw new JMSRuntimeException(errorMessage);
        }
        return this;
    }

    public javax.jms.JMSProducer setDeliveryDelay(long deliveryDelay) {
        try {
            this.messageProducer.setDeliveryDelay(deliveryDelay);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to set delivery delay");
        }
        return this;
    }

    public javax.jms.JMSProducer setDeliveryMode(int deliveryMode) {
        try {
            this.messageProducer.setDeliveryMode(deliveryMode);
            return this;
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to set delivery mode");
        }
    }

    public javax.jms.JMSProducer setDisableMessageID(boolean value) {
        try {
            this.messageProducer.setDisableMessageID(value);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to set disable message id");
        }
        return this;
    }

    public javax.jms.JMSProducer setDisableMessageTimestamp(boolean value) {
        try {
            this.messageProducer.setDisableMessageTimestamp(value);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to set disable message timestamp");
        }
        return this;
    }

    public javax.jms.JMSProducer setJMSReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public javax.jms.JMSProducer setJMSType(String type) {
        this.jmsType = type;
        return this;
    }

    public javax.jms.JMSProducer setPriority(int priority) {
        try {
            this.messageProducer.setPriority(priority);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to set priority");
        }
        return this;
    }

    public javax.jms.JMSProducer setTimeToLive(long timeToLive) {
        try {
            this.messageProducer.setTimeToLive(timeToLive);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Unable to set time to live");
        }
        return this;
    }

    private Message writeCurrentProperties(Message message) throws JMSException {
        if (this.jmsCorrelationID != null) {
            message.setJMSCorrelationID(this.jmsCorrelationID);
        }
        if (this.jmsType != null) {
            message.setJMSType(this.jmsType);
        }
        if (this.replyTo != null) {
            message.setJMSReplyTo(this.replyTo);
        }
        for (String key : this.properties.keySet()) {
            message.setObjectProperty(key, this.properties.get(key));
        }
        if (this.replyTo != null) {
            message.setJMSReplyTo(this.replyTo);
        }
        return message;
    }

    private final Object doGetProperty(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        return this.properties.get(name);
    }

    public final String getString2Property(String name) throws JMSException {
        return ConversionHelper.toString((Object)this.doGetProperty(name));
    }

    public javax.jms.JMSProducer clearProperties() {
        this.properties.clear();
        return this;
    }

    public boolean getBooleanProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        try {
            return ConversionHelper.toBoolean((Object)this.properties.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatRuntimeException(mE.getMessage());
        }
    }

    public byte getByteProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        try {
            return ConversionHelper.toByte((Object)this.properties.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatRuntimeException(mE.getMessage());
        }
    }

    public short getShortProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        try {
            return ConversionHelper.toShort((Object)this.properties.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatRuntimeException(mE.getMessage());
        }
    }

    public int getIntProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        try {
            return ConversionHelper.toInt((Object)this.properties.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatRuntimeException(mE.getMessage());
        }
    }

    public long getLongProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        try {
            return ConversionHelper.toLong((Object)this.properties.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatRuntimeException(mE.getMessage());
        }
    }

    public float getFloatProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        try {
            return ConversionHelper.toFloat((Object)this.properties.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatRuntimeException(mE.getMessage());
        }
    }

    public double getDoubleProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        try {
            return ConversionHelper.toDouble((Object)this.properties.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatRuntimeException(mE.getMessage());
        }
    }

    public String getStringProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        return ConversionHelper.toString((Object)this.properties.get(name));
    }

    public Object getObjectProperty(String name) {
        if (name == null || name.equals("")) {
            throw new JMSRuntimeException("Invalid property name: " + name);
        }
        return this.properties.get(name);
    }

    public javax.jms.JMSProducer setProperty(String name, boolean value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.properties.put(name, value);
        return this;
    }

    public javax.jms.JMSProducer setProperty(String name, byte value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.properties.put(name, value);
        return this;
    }

    public javax.jms.JMSProducer setProperty(String name, double value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.properties.put(name, value);
        return this;
    }

    public javax.jms.JMSProducer setProperty(String name, float value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.properties.put(name, Float.valueOf(value));
        return this;
    }

    public javax.jms.JMSProducer setProperty(String name, int value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.properties.put(name, value);
        return this;
    }

    public javax.jms.JMSProducer setProperty(String name, long value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.properties.put(name, value);
        return this;
    }

    public javax.jms.JMSProducer setProperty(String name, Object value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (!(value instanceof Boolean || value instanceof Number || value instanceof String)) {
            throw new MessageFormatRuntimeException("Can't set non primitive Java object as a property value.");
        }
        this.properties.put(name, value);
        return this;
    }

    public javax.jms.JMSProducer setProperty(String name, short value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.properties.put(name, value);
        return this;
    }

    public javax.jms.JMSProducer setProperty(String name, String value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.properties.put(name, value);
        return this;
    }
}

