/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;

public final class MapMessage
extends Message
implements javax.jms.MapMessage {
    private transient HashMap<String, Object> map;

    MapMessage() {
        this.momMsg.type = 3;
        this.map = new HashMap();
    }

    MapMessage(Session session, org.objectweb.joram.shared.messages.Message momMsg) throws MessageFormatException {
        super(session, momMsg);
        if (momMsg.isNullBody()) {
            throw new MessageFormatException("Message body is null: " + momMsg.id);
        }
        try {
            this.map = momMsg.getMap();
        }
        catch (Exception exc) {
            throw new MessageFormatException("Error while deserializing the wrapped Map: " + exc);
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.map.clear();
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.setObject(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.setObject(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.setObject(name, value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        byte[] buff = new byte[length];
        System.arraycopy(value, offset, buff, 0, length);
        this.setObject(name, buff);
    }

    public void setChar(String name, char value) throws JMSException {
        this.setObject(name, Character.valueOf(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.setObject(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        this.setObject(name, Float.valueOf(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.setObject(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.setObject(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        this.setObject(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        this.setObject(name, value);
    }

    public void setObject(String name, Object value) throws JMSException {
        if (this.RObody) {
            throw new MessageNotWriteableException("Can't set a value as the message body is read-only.");
        }
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid null or empty value name.");
        }
        if (!(value instanceof Boolean || value instanceof Character || value instanceof Number || value instanceof String || value instanceof byte[] || value == null)) {
            throw new MessageFormatException("Can't set non Java primitive type as a map value.");
        }
        this.map.put(name, value);
    }

    public boolean getBoolean(String name) throws JMSException {
        try {
            return ConversionHelper.toBoolean((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public byte getByte(String name) throws JMSException {
        try {
            return ConversionHelper.toByte((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public byte[] getBytes(String name) throws JMSException {
        try {
            return ConversionHelper.toBytes((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public char getChar(String name) throws JMSException {
        try {
            return ConversionHelper.toChar((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public double getDouble(String name) throws JMSException {
        try {
            return ConversionHelper.toDouble((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public float getFloat(String name) throws JMSException {
        try {
            return ConversionHelper.toFloat((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public int getInt(String name) throws JMSException {
        try {
            return ConversionHelper.toInt((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public long getLong(String name) throws JMSException {
        try {
            return ConversionHelper.toLong((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public Object getObject(String name) throws JMSException {
        return this.map.get(name);
    }

    public short getShort(String name) throws JMSException {
        try {
            return ConversionHelper.toShort((Object)this.map.get(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public String getString(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value instanceof byte[]) {
            throw new MessageFormatException("Type " + value.getClass().getName() + " can't be converted to String.");
        }
        return ConversionHelper.toString((Object)value);
    }

    public boolean itemExists(String name) throws JMSException {
        return this.map.containsKey(name);
    }

    public Enumeration getMapNames() throws JMSException {
        Vector<String> vec = new Vector<String>();
        if (this.map.keySet() != null) {
            Iterator<String> it = this.map.keySet().iterator();
            while (it.hasNext()) {
                vec.add(it.next());
            }
        }
        return vec.elements();
    }

    @Override
    protected void prepare() throws JMSException {
        super.prepare();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.map);
            oos.flush();
            this.momMsg.setBody(baos.toByteArray());
            oos.close();
            baos.close();
        }
        catch (IOException exc) {
            MessageFormatException jExc = new MessageFormatException("The message body could not be serialized.");
            jExc.setLinkedException((Exception)exc);
            throw jExc;
        }
    }

    @Override
    protected <T> T getEffectiveBody(Class<T> c) throws JMSException {
        return (T)this.map;
    }
}

