/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.BinaryDump;
import fr.dyade.aaa.common.Debug;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.objectweb.joram.client.jms.BytesMessage;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.MapMessage;
import org.objectweb.joram.client.jms.ObjectMessage;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.StreamMessage;
import org.objectweb.joram.client.jms.TextMessage;
import org.objectweb.joram.client.jms.admin.AdminMessage;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Message
implements javax.jms.Message {
    public static Logger logger = Debug.getLogger((String)Message.class.getName());
    protected org.objectweb.joram.shared.messages.Message momMsg;
    protected transient Session session = null;
    protected transient javax.jms.Destination jmsDest = null;
    protected boolean RObody = false;
    public boolean propertiesRO = false;
    private static boolean first = true;
    private static boolean strictVerificationError = false;
    private static boolean strictVerificationWarn = true;

    protected Message() {
        this.momMsg = new org.objectweb.joram.shared.messages.Message();
    }

    public void setCompressedMinSize(int compressedMinSize) {
        this.momMsg.compressedMinSize = compressedMinSize;
    }

    public final int getCompressedMinSize() {
        return this.momMsg.compressedMinSize;
    }

    public final boolean isCompressed() {
        return this.momMsg.compressed;
    }

    public final void setCompressionLevel(int compressionLevel) {
        this.momMsg.compressionLevel = compressionLevel;
    }

    public final int getCompressionLevel() {
        return this.momMsg.compressionLevel;
    }

    public static Message wrapMomMessage(Session session, org.objectweb.joram.shared.messages.Message momMsg) throws JMSException {
        switch (momMsg.type) {
            case 0: {
                return new Message(session, momMsg);
            }
            case 1: {
                return new TextMessage(session, momMsg);
            }
            case 2: {
                return new ObjectMessage(session, momMsg);
            }
            case 3: {
                return new MapMessage(session, momMsg);
            }
            case 4: {
                return new StreamMessage(session, momMsg);
            }
            case 5: {
                return new BytesMessage(session, momMsg);
            }
            case 6: {
                return new AdminMessage(session, momMsg);
            }
        }
        throw new JMSException("Unknow message type: " + momMsg.type);
    }

    protected Message(Session session, org.objectweb.joram.shared.messages.Message momMsg) {
        this.session = session;
        this.momMsg = momMsg;
        this.setReadOnly();
    }

    public void acknowledge() throws JMSException {
        if (this.session.getAcknowledgeMode() == Session.INDIVIDUAL_ACKNOWLEDGE) {
            this.session.acknowledge((Destination)this.getJMSDestination(), this.getJMSMessageID());
        }
        if (this.session == null || this.session.getTransacted() || this.session.getAcknowledgeMode() != 2) {
            return;
        }
        this.session.acknowledge();
    }

    public void clearBody() throws JMSException {
        this.momMsg.clearBody();
        this.RObody = false;
    }

    private void setReadOnly() {
        this.momMsg.setProperty("JMSXDeliveryCount", (Object)this.momMsg.redelivered);
        this.propertiesRO = true;
        this.RObody = true;
    }

    public final String getJMSMessageID() throws JMSException {
        return this.momMsg.id;
    }

    public final void setJMSMessageID(String id) throws JMSException {
        this.momMsg.id = id;
    }

    public final int getJMSPriority() throws JMSException {
        return this.momMsg.priority;
    }

    public final void setJMSPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new JMSException("Priority of " + priority + " is not valid (should be an integer between 0 and 9).");
        }
        this.momMsg.priority = priority;
    }

    public final javax.jms.Destination getJMSDestination() throws JMSException {
        if (this.jmsDest != null) {
            return this.jmsDest;
        }
        if (this.momMsg.toId != null) {
            try {
                return Destination.newInstance(this.momMsg.toId, this.momMsg.toName, this.momMsg.toType);
            }
            catch (Exception exc) {
                throw new JMSException(exc.getMessage());
            }
        }
        return null;
    }

    public final void setJMSDestination(javax.jms.Destination dest) throws JMSException {
        this.jmsDest = dest;
        if (dest != null && dest instanceof Destination) {
            Destination d = (Destination)dest;
            this.momMsg.setDestination(d.getName(), d.getAdminName(), d.getType());
            return;
        }
        this.momMsg.setDestination(null, null, (byte)0);
    }

    public final long getJMSExpiration() throws JMSException {
        return this.momMsg.expiration;
    }

    public final void setJMSExpiration(long expiration) throws JMSException {
        if (expiration >= 0L) {
            this.momMsg.expiration = expiration;
        }
    }

    public final boolean getJMSRedelivered() throws JMSException {
        return this.momMsg.redelivered;
    }

    public final void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.momMsg.redelivered = redelivered;
    }

    public final javax.jms.Destination getJMSReplyTo() throws JMSException {
        if (this.momMsg.replyToId != null) {
            try {
                return Destination.newInstance(this.momMsg.replyToId, this.momMsg.replyToName, this.momMsg.replyToType);
            }
            catch (Exception exc) {
                throw new JMSException(exc.getMessage());
            }
        }
        return null;
    }

    public final void setJMSReplyTo(javax.jms.Destination replyTo) throws JMSException {
        if (replyTo != null && replyTo instanceof Destination) {
            Destination d = (Destination)replyTo;
            this.momMsg.setReplyTo(d.getName(), d.getAdminName(), d.getType());
            return;
        }
        this.momMsg.setReplyTo(null, null, (byte)0);
    }

    public final long getJMSTimestamp() throws JMSException {
        return this.momMsg.timestamp;
    }

    public final void setJMSTimestamp(long timestamp) throws JMSException {
        this.momMsg.timestamp = timestamp;
    }

    public final String getJMSCorrelationID() throws JMSException {
        return this.momMsg.correlationId;
    }

    public final void setJMSCorrelationID(String correlationID) throws JMSException {
        this.momMsg.correlationId = correlationID;
    }

    public final byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.momMsg.getJMSCorrelationIDAsBytes();
    }

    public final void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.momMsg.setJMSCorrelationIDAsBytes(correlationID);
    }

    public final int getJMSDeliveryMode() throws JMSException {
        if (this.momMsg.persistent) {
            return 2;
        }
        return 1;
    }

    public final void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new JMSException("Invalid delivery mode.");
        }
        this.momMsg.persistent = deliveryMode == 2;
    }

    public final String getJMSType() throws JMSException {
        return this.momMsg.jmsType;
    }

    public final void setJMSType(String type) throws JMSException {
        this.momMsg.jmsType = type;
    }

    public final void clearProperties() throws JMSException {
        this.propertiesRO = false;
        if (this.momMsg.properties == null) {
            return;
        }
        this.momMsg.properties.clear();
        this.momMsg.properties = null;
    }

    public final void resetPropertiesRO() throws JMSException {
        this.propertiesRO = false;
    }

    public final boolean propertyExists(String name) throws JMSException {
        if (this.momMsg.properties == null) {
            return false;
        }
        return this.momMsg.properties.containsKey(name);
    }

    public void getProperties(Map h) {
        if (this.momMsg.properties == null) {
            return;
        }
        this.momMsg.properties.copyInto(h);
        h.put("JMSXDeliveryCount", this.momMsg.redelivered);
    }

    public final Enumeration getPropertyNames() throws JMSException {
        if (this.momMsg.properties == null) {
            return new Hashtable().keys();
        }
        return this.momMsg.properties.keys();
    }

    public final void setBooleanProperty(String name, boolean value) throws JMSException {
        this.doSetProperty(name, value);
    }

    public final void setByteProperty(String name, byte value) throws JMSException {
        this.doSetProperty(name, value);
    }

    public final void setShortProperty(String name, short value) throws JMSException {
        this.doSetProperty(name, value);
    }

    public final void setIntProperty(String name, int value) throws JMSException {
        this.doSetProperty(name, value);
    }

    public final void setLongProperty(String name, long value) throws JMSException {
        this.doSetProperty(name, value);
    }

    public final void setFloatProperty(String name, float value) throws JMSException {
        this.doSetProperty(name, Float.valueOf(value));
    }

    public final void setDoubleProperty(String name, double value) throws JMSException {
        this.doSetProperty(name, value);
    }

    public final void setStringProperty(String name, String value) throws JMSException {
        this.doSetProperty(name, value);
    }

    public final void setObjectProperty(String name, Object value) throws JMSException {
        if (!(value instanceof Boolean || value instanceof Number || value instanceof String)) {
            throw new MessageFormatException("Can't set non primitive Java object as a property value.");
        }
        this.doSetProperty(name, value);
    }

    private final void checkIdentifier(String identifier) throws IllegalArgumentException {
        if (!Message.strictVerificationWarn()) {
            return;
        }
        char[] chars = identifier.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            if (Message.strictVerificationError()) {
                throw new IllegalArgumentException("Invalid property name: " + identifier);
            }
            if (Message.strictVerificationWarn()) {
                logger.log(BasicLevel.WARN, "Invalid property name \"" + identifier + "\" in JMS message.");
            }
            return;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            if (Message.strictVerificationError()) {
                throw new IllegalArgumentException("Invalid property name: " + identifier);
            }
            if (Message.strictVerificationWarn()) {
                logger.log(BasicLevel.WARN, "Invalid property name \"" + identifier + "\" in JMS message.");
            }
            return;
        }
    }

    private static final void initStrictVerification() {
        if (first) {
            first = false;
            String value = System.getProperty("org.objectweb.joram.jms.strict.identifier", "warn");
            if (!value.equalsIgnoreCase("warn")) {
                Boolean bool = Boolean.parseBoolean(value);
                strictVerificationError = bool;
                strictVerificationWarn = bool;
            }
        }
    }

    private static final boolean strictVerificationError() {
        Message.initStrictVerification();
        return strictVerificationError;
    }

    private static final boolean strictVerificationWarn() {
        Message.initStrictVerification();
        return strictVerificationError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void doSetProperty(String name, Object value) throws JMSException {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        this.checkIdentifier(name);
        if (name.startsWith("JMSX")) {
            if (name.equals("JMSXGroupID")) {
                this.momMsg.setProperty(name, (Object)ConversionHelper.toString((Object)value));
                return;
            } else {
                if (!name.equals("JMSXGroupSeq")) throw new JMSException("Property names with prefix 'JMSX' are reserved.");
                try {
                    this.momMsg.setProperty(name, (Object)ConversionHelper.toInt((Object)value));
                    return;
                }
                catch (MessageValueException mE) {
                    throw new MessageFormatException(mE.getMessage());
                }
            }
        } else if (name.startsWith("JMS_JORAM")) {
            if (this.propertiesRO) {
                throw new MessageNotWriteableException("Can't set property as the message properties are READ-ONLY.");
            }
            this.momMsg.setProperty(name, value);
            return;
        } else {
            if (name.startsWith("JMS")) {
                throw new JMSException("Property names with prefix 'JMS' are  reserved.");
            }
            if (name.equalsIgnoreCase("NULL") || name.equalsIgnoreCase("TRUE") || name.equalsIgnoreCase("FALSE") || name.equalsIgnoreCase("NOT") || name.equalsIgnoreCase("AND") || name.equalsIgnoreCase("OR") || name.equalsIgnoreCase("BETWEEN") || name.equalsIgnoreCase("LIKE") || name.equalsIgnoreCase("IN") || name.equalsIgnoreCase("IS") || name.equalsIgnoreCase("ESCAPE")) {
                throw new JMSException("Invalid property name cannot use SQL terminal: " + name);
            }
            if (this.propertiesRO) {
                throw new MessageNotWriteableException("Can't set property as the message properties are READ-ONLY.");
            }
            this.momMsg.setProperty(name, value);
        }
    }

    public final boolean getBooleanProperty(String name) throws JMSException {
        try {
            return ConversionHelper.toBoolean((Object)this.doGetProperty(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public final byte getByteProperty(String name) throws JMSException {
        try {
            return ConversionHelper.toByte((Object)this.doGetProperty(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public final short getShortProperty(String name) throws JMSException {
        try {
            return ConversionHelper.toShort((Object)this.doGetProperty(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public final int getIntProperty(String name) throws JMSException {
        try {
            return ConversionHelper.toInt((Object)this.doGetProperty(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public final long getLongProperty(String name) throws JMSException {
        try {
            return ConversionHelper.toLong((Object)this.doGetProperty(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public final float getFloatProperty(String name) throws JMSException {
        try {
            return ConversionHelper.toFloat((Object)this.doGetProperty(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public final double getDoubleProperty(String name) throws JMSException {
        try {
            return ConversionHelper.toDouble((Object)this.doGetProperty(name));
        }
        catch (MessageValueException mE) {
            throw new MessageFormatException(mE.getMessage());
        }
    }

    public final String getStringProperty(String name) throws JMSException {
        return ConversionHelper.toString((Object)this.doGetProperty(name));
    }

    public final Object getObjectProperty(String name) throws JMSException {
        return this.doGetProperty(name);
    }

    private final Object doGetProperty(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (name.equals("JMSXDeliveryCount")) {
            return this.momMsg.deliveryCount;
        }
        return this.momMsg.getProperty(name);
    }

    public static Message convertJMSMessage(javax.jms.Message jmsMsg) throws JMSException {
        if (jmsMsg == null) {
            return null;
        }
        Message joramMsg = null;
        if (jmsMsg instanceof javax.jms.TextMessage) {
            joramMsg = new TextMessage();
            ((javax.jms.TextMessage)joramMsg).setText(((javax.jms.TextMessage)jmsMsg).getText());
        } else if (jmsMsg instanceof javax.jms.ObjectMessage) {
            joramMsg = new ObjectMessage();
            ((javax.jms.ObjectMessage)joramMsg).setObject(((javax.jms.ObjectMessage)jmsMsg).getObject());
        } else if (jmsMsg instanceof javax.jms.StreamMessage) {
            joramMsg = new StreamMessage();
            try {
                ((javax.jms.StreamMessage)jmsMsg).reset();
                while (true) {
                    ((StreamMessage)joramMsg).writeObject(((javax.jms.StreamMessage)jmsMsg).readObject());
                }
            }
            catch (Exception exception) {}
        } else if (jmsMsg instanceof javax.jms.BytesMessage) {
            joramMsg = new BytesMessage();
            try {
                ((javax.jms.BytesMessage)jmsMsg).reset();
                while (true) {
                    ((BytesMessage)joramMsg).writeByte(((javax.jms.BytesMessage)jmsMsg).readByte());
                }
            }
            catch (Exception exception) {}
        } else if (jmsMsg instanceof javax.jms.MapMessage) {
            joramMsg = new MapMessage();
            Enumeration mapNames = ((javax.jms.MapMessage)jmsMsg).getMapNames();
            while (mapNames.hasMoreElements()) {
                String mapName = (String)mapNames.nextElement();
                ((javax.jms.MapMessage)joramMsg).setObject(mapName, ((javax.jms.MapMessage)jmsMsg).getObject(mapName));
            }
        } else {
            joramMsg = new Message();
        }
        joramMsg.setJMSDestination(jmsMsg.getJMSDestination());
        joramMsg.setJMSCorrelationID(jmsMsg.getJMSCorrelationID());
        joramMsg.setJMSReplyTo(jmsMsg.getJMSReplyTo());
        joramMsg.setJMSType(jmsMsg.getJMSType());
        joramMsg.setJMSMessageID(jmsMsg.getJMSMessageID());
        joramMsg.setJMSExpiration(jmsMsg.getJMSExpiration());
        joramMsg.setJMSRedelivered(jmsMsg.getJMSRedelivered());
        Enumeration names = jmsMsg.getPropertyNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                try {
                    joramMsg.setObjectProperty(name, jmsMsg.getObjectProperty(name));
                }
                catch (JMSException e) {
                    if (name.startsWith("JMSX") || name.startsWith("JMS_")) continue;
                    throw e;
                }
            }
        }
        return joramMsg;
    }

    public static void prepareJMSMessage(Message msg) throws JMSException {
        msg.prepare();
    }

    protected void prepare() throws JMSException {
        this.momMsg.deliveryCount = 0;
    }

    public org.objectweb.joram.shared.messages.Message getMomMsg() {
        return this.momMsg;
    }

    public final String toString() {
        StringBuffer strbuf = new StringBuffer();
        this.toString(strbuf);
        return strbuf.toString();
    }

    public void toString(StringBuffer strbuf) {
        try {
            strbuf.append('(');
            strbuf.append(super.toString());
            strbuf.append(",JMSMessageID=").append(this.getJMSMessageID());
            try {
                strbuf.append(",JMSDestination=").append(this.getJMSDestination());
            }
            catch (JMSException exc) {
                logger.log(BasicLevel.ERROR, "Message.toString()", (Throwable)exc);
            }
            strbuf.append(",JMSCorrelationID=").append(this.getJMSCorrelationID());
            strbuf.append(",JMSDeliveryMode=").append(this.getJMSDeliveryMode());
            strbuf.append(",JMSExpiration=").append(this.getJMSExpiration());
            strbuf.append(",JMSPriority=").append(this.getJMSPriority());
            strbuf.append(",JMSRedelivered=").append(this.getJMSRedelivered());
            try {
                strbuf.append(",JMSReplyTo=").append(this.getJMSReplyTo());
            }
            catch (JMSException exc) {
                logger.log(BasicLevel.ERROR, "Message.toString()", (Throwable)exc);
            }
            strbuf.append(",JMSTimestamp=").append(this.getJMSTimestamp());
            strbuf.append(",JMSDeliveryTime=").append(this.getJMSDeliveryTime());
            strbuf.append(",JMSType=").append(this.getJMSType());
            if (!this.momMsg.isNullBody()) {
                strbuf.append(",size=").append(this.momMsg.getBodyLength());
            }
            strbuf.append(')');
        }
        catch (JMSException exc) {
            logger.log(BasicLevel.ERROR, "Message.toString()", (Throwable)exc);
        }
    }

    public byte[] getRawBody() throws IOException {
        return this.momMsg.getBody();
    }

    public String dumpBody() throws IOException {
        return BinaryDump.dump((byte[])this.getRawBody(), (long)0L, (int)0);
    }

    public Appendable dumpBody(Appendable strbuf) throws IOException {
        return strbuf.append(BinaryDump.dump((byte[])this.getRawBody(), (long)0L, (int)0));
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        if (this.momMsg.isNullBody()) {
            return true;
        }
        if (this instanceof StreamMessage) {
            return false;
        }
        if (this instanceof TextMessage) {
            return c.isAssignableFrom(String.class);
        }
        if (this instanceof BytesMessage) {
            return byte[].class.equals((Object)c) || Object.class.equals((Object)c);
        }
        if (this instanceof MapMessage) {
            return Map.class.equals((Object)c) || Object.class.equals((Object)c);
        }
        if (this instanceof ObjectMessage) {
            return c.isAssignableFrom(((ObjectMessage)this).getObject().getClass());
        }
        throw new JMSException("Unable to to return a value");
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        if (this.isBodyAssignableTo(c)) {
            return this.getEffectiveBody(c);
        }
        throw new MessageFormatException("Unable to get message body");
    }

    protected <T> T getEffectiveBody(Class<T> c) throws JMSException {
        return null;
    }

    public long getJMSDeliveryTime() throws JMSException {
        return this.momMsg.deliveryTime;
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.momMsg.deliveryTime = deliveryTime;
    }
}

