/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.MessageConsumerListener;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.joram.client.jms.SingleSessionConsumer;
import org.objectweb.joram.client.jms.TemporaryQueue;
import org.objectweb.joram.client.jms.TemporaryTopic;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.ConsumerCloseSubRequest;
import org.objectweb.joram.shared.client.ConsumerSubRequest;
import org.objectweb.joram.shared.client.ConsumerUnsubRequest;
import org.objectweb.joram.shared.excepts.SelectorException;
import org.objectweb.joram.shared.selectors.ClientSelector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class MessageConsumer
implements javax.jms.MessageConsumer {
    private static Logger logger = Debug.getLogger((String)MessageConsumer.class.getName());
    String selector;
    private boolean durableSubscriber;
    protected Destination dest;
    protected boolean noLocal;
    protected Session sess;
    String targetName;
    boolean queueMode;
    private int status;
    private Closer closer;
    private boolean shared = false;
    private MessageListener messageListener;

    MessageConsumer(Session sess, Destination dest, String selector, String subName, boolean noLocal, boolean shared, boolean durableSubscriber) throws JMSException {
        Connection tempTCnx;
        Connection tempQCnx;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumer.<init>(" + sess + ',' + dest + ',' + selector + ',' + subName + ',' + noLocal + ',' + shared + ',' + durableSubscriber + ')');
        }
        if (dest == null) {
            throw new InvalidDestinationException("Invalid null destination.");
        }
        dest.check();
        if (dest instanceof TemporaryQueue ? (tempQCnx = ((TemporaryQueue)dest).getCnx()) == null || !tempQCnx.equals(sess.getConnection()) : dest instanceof TemporaryTopic && ((tempTCnx = ((TemporaryTopic)dest).getCnx()) == null || !tempTCnx.equals(sess.getConnection()))) {
            throw new JMSSecurityException("Forbidden consumer on this temporary destination.");
        }
        try {
            ClientSelector.checks((String)selector);
        }
        catch (SelectorException sE) {
            throw new InvalidSelectorException("Invalid selector syntax: " + (Object)((Object)sE));
        }
        if (dest instanceof Topic) {
            this.durableSubscriber = durableSubscriber;
            this.noLocal = noLocal;
            this.queueMode = false;
            this.targetName = subName == null ? sess.getConnection().nextSubName() : subName;
            if (!shared || !sess.getConnection().isOpenMessageConsumer(this.targetName)) {
                if (noLocal && !durableSubscriber && sess.getConnection().getClientID() == null) {
                    sess.getConnection().setProviderClientID();
                }
                sess.syncRequest((AbstractJmsRequest)new ConsumerSubRequest(dest.getName(), this.targetName, selector, noLocal, durableSubscriber, sess.isAsyncSub(), sess.getConnection().getClientID(), shared));
            }
            sess.getConnection().openMessageConsumer(this.targetName);
        } else {
            this.targetName = dest.getName();
            this.queueMode = true;
        }
        this.sess = sess;
        this.dest = dest;
        this.selector = selector;
        this.shared = shared;
        this.closer = new Closer();
        this.setStatus(0);
    }

    MessageConsumer(Session sess, Destination dest, String selector) throws JMSException {
        this(sess, dest, selector, null, false, false, false);
    }

    private synchronized void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumer.setStatus(" + Status.toString(status) + ')');
        }
        this.status = status;
    }

    public final String getTargetName() {
        return this.targetName;
    }

    public final boolean getQueueMode() {
        return this.queueMode;
    }

    protected synchronized void checkClosed() throws IllegalStateException {
        if (this.status == 1) {
            throw new IllegalStateException("Forbidden call on a closed consumer.");
        }
    }

    public String toString() {
        return "Consumer:" + this.sess.getId();
    }

    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumer.setMessageListener(" + messageListener + ')');
        }
        this.checkClosed();
        MessageConsumerListener mcl = this.sess.getMessageConsumerListener(this.targetName);
        if (mcl != null) {
            if (messageListener == null) {
                if (this.shared) {
                    mcl.removeMessageListener(this.messageListener);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, "MessageConsumer.setMessageListener mcl.getMessageListenersSize() = " + mcl.getMessageListenersSize());
                    }
                    if (mcl.getMessageListenersSize() < 1) {
                        this.sess.removeMessageListener(mcl, false);
                        this.sess.removeMessageConsumerListener(this.targetName);
                    }
                } else {
                    this.sess.removeMessageListener(mcl, false);
                    this.sess.removeMessageConsumerListener(this.targetName);
                }
            } else if (this.shared && mcl.getMessageListenersSize() > 0) {
                mcl.addMessageListener(messageListener);
            } else {
                this.sess.removeMessageListener(mcl, false);
                mcl = this.sess.addMessageListener(new SingleSessionConsumer(this.queueMode, this.durableSubscriber, this.selector, this.dest.getAdminName(), this.targetName, this.sess, messageListener), false);
                this.sess.putMessageConsumerListener(this.targetName, mcl);
            }
        } else if (messageListener != null) {
            mcl = this.sess.addMessageListener(new SingleSessionConsumer(this.queueMode, this.durableSubscriber, this.selector, this.dest.getAdminName(), this.targetName, this.sess, messageListener), true);
            this.sess.putMessageConsumerListener(this.targetName, mcl);
        }
        this.messageListener = messageListener;
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        MessageConsumerListener mcl = this.sess.getMessageConsumerListener(this.targetName);
        if (mcl == null) {
            return null;
        }
        return mcl.getMessageListener();
    }

    public final String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public Message receive(long timeOut) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumer.receive(" + timeOut + ')');
        }
        this.checkClosed();
        return this.sess.receive(timeOut, timeOut, this, this.targetName, this.selector, this.queueMode);
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    public Message receiveNoWait() throws JMSException {
        this.checkClosed();
        if (this.sess.getConnection().isStopped()) {
            return null;
        }
        return this.sess.receive(-1L, 0L, this, this.targetName, this.selector, this.queueMode);
    }

    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumer.close()");
        }
        if (this.sess.getConnection().closeMessageConsumer(this.targetName)) {
            this.closer.close();
        } else {
            this.setStatus(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClose() throws JMSException {
        block12: {
            MessageConsumer messageConsumer = this;
            synchronized (messageConsumer) {
                if (this.status == 1) {
                    return;
                }
                this.setStatus(1);
            }
            if (!this.queueMode) {
                if (this.durableSubscriber) {
                    try {
                        this.sess.syncRequest((AbstractJmsRequest)new ConsumerCloseSubRequest(this.targetName));
                    }
                    catch (JMSException exc) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                        }
                        break block12;
                    }
                }
                try {
                    this.sess.syncRequest((AbstractJmsRequest)new ConsumerUnsubRequest(this.targetName));
                }
                catch (JMSException exc) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block12;
                    logger.log(BasicLevel.DEBUG, "", (Throwable)exc);
                }
            }
        }
        this.sess.closeConsumer(this);
        MessageConsumerListener mcl = this.sess.getMessageConsumerListener(this.targetName);
        if (mcl != null) {
            this.sess.removeMessageListener(mcl, false);
            this.sess.removeMessageConsumerListener(this.targetName);
        }
    }

    public Destination getDest() {
        return this.dest;
    }

    public boolean isQueueMode() {
        return this.queueMode;
    }

    public boolean isOpen() {
        return this.status == 0;
    }

    class Closer {
        Closer() {
        }

        synchronized void close() throws JMSException {
            MessageConsumer.this.doClose();
        }
    }

    private static class Status {
        public static final int OPEN = 0;
        public static final int CLOSE = 1;
        private static final String[] names = new String[]{"OPEN", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

