/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.StoppedQueueException;
import java.util.ArrayList;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.connection.AbortedRequestException;
import org.objectweb.joram.client.jms.connection.ReplyListener;
import org.objectweb.joram.client.jms.connection.RequestMultiplexer;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.ActivateConsumerRequest;
import org.objectweb.joram.shared.client.ConsumerAckRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.ConsumerSetListRequest;
import org.objectweb.joram.shared.client.ConsumerUnsetListRequest;
import org.objectweb.joram.shared.client.MomExceptionReply;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

abstract class MessageConsumerListener
implements ReplyListener {
    private static final boolean debug = false;
    private static final Logger logger = Debug.getLogger((String)MessageConsumerListener.class.getName());
    private boolean queueMode;
    private boolean durable;
    private String selector;
    private String destName;
    private String targetName;
    private volatile int requestId;
    private int status;
    private Vector<String> messagesToAck;
    private volatile int messageCount;
    private volatile int receiveStatus;
    private boolean topicMsgInputPassivated;
    private boolean waitingMessagesBrokerSide = false;
    private int queueMessageReadMax;
    private RequestMultiplexer rm;
    private int topicActivationThreshold;
    private int topicPassivationThreshold;
    private int topicAckBufferMax;
    private ArrayList<MessageListener> listeners;
    private int listenerPosition = 0;

    public final String getDestName() {
        return this.destName;
    }

    MessageConsumerListener(boolean queueMode, boolean durable, String selector, String destName, String targetName, MessageListener listener, int queueMessageReadMax, int topicActivationThreshold, int topicPassivationThreshold, int topicAckBufferMax, RequestMultiplexer reqMultiplexer) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener(" + queueMode + ',' + durable + ',' + selector + ',' + destName + ',' + targetName + ',' + listener + ',' + queueMessageReadMax + ',' + topicActivationThreshold + ',' + topicPassivationThreshold + ',' + topicAckBufferMax + ',' + reqMultiplexer + ')');
        }
        this.queueMode = queueMode;
        this.durable = durable;
        this.selector = selector;
        this.destName = destName;
        this.targetName = targetName;
        if (queueMessageReadMax < 0) {
            logger.log(BasicLevel.INFO, "Bad value for queueMessageReadMax(" + queueMessageReadMax + "), set default.");
            queueMessageReadMax = 1;
        }
        this.queueMessageReadMax = queueMessageReadMax;
        if (topicActivationThreshold < 0) {
            logger.log(BasicLevel.INFO, "Bad value for topicActivationThreshold(), set default.");
            topicActivationThreshold = 0;
        }
        if (topicPassivationThreshold <= 0) {
            logger.log(BasicLevel.INFO, "Bad value for topicPassivationThreshold(" + topicPassivationThreshold + "), set default.");
            topicPassivationThreshold = Integer.MAX_VALUE;
        }
        if (topicActivationThreshold >= topicPassivationThreshold) {
            logger.log(BasicLevel.INFO, "Bad value for topicActivationThreshold/topicPassivationThreshold(" + topicActivationThreshold + '/' + topicPassivationThreshold + "), set default.");
            topicActivationThreshold = 0;
            topicPassivationThreshold = Integer.MAX_VALUE;
        }
        this.topicActivationThreshold = topicActivationThreshold;
        this.topicPassivationThreshold = topicPassivationThreshold;
        this.topicAckBufferMax = topicAckBufferMax;
        this.rm = reqMultiplexer;
        this.messagesToAck = new Vector(0);
        this.requestId = -1;
        this.messageCount = 0;
        this.topicMsgInputPassivated = false;
        this.listeners = new ArrayList();
        this.listeners.add(listener);
        this.setStatus(0);
        this.setReceiveStatus(0);
    }

    protected final int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.setStatus(" + Status.toString(status) + ')');
        }
        this.status = status;
    }

    private void setReceiveStatus(int s) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.setReceiveStatus(" + ReceiveStatus.toString(s) + ')');
        }
        this.receiveStatus = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseMessageCount(int ackMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.decreaseMessageCount()");
        }
        MessageConsumerListener messageConsumerListener = this;
        synchronized (messageConsumerListener) {
            --this.messageCount;
        }
        if (this.queueMode) {
            boolean subscribe = false;
            Object[] toAck = null;
            MessageConsumerListener messageConsumerListener2 = this;
            synchronized (messageConsumerListener2) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, " -> messageCount = " + this.messageCount);
                }
                if ((this.messageCount < this.queueMessageReadMax || this.queueMessageReadMax == 0) && this.receiveStatus == 2) {
                    subscribe = true;
                    if (ackMode == 3) {
                        Vector<String> vector = this.messagesToAck;
                        synchronized (vector) {
                            if (this.messagesToAck.size() > 0) {
                                toAck = new String[this.messagesToAck.size()];
                                this.messagesToAck.copyInto(toAck);
                                this.messagesToAck.clear();
                            }
                        }
                    }
                }
            }
            if (subscribe) {
                if (this.queueMessageReadMax == 0) {
                    this.subscribe((String[])toAck, 1);
                } else {
                    this.subscribe((String[])toAck, this.queueMessageReadMax);
                }
            }
        } else {
            messageConsumerListener = this;
            synchronized (messageConsumerListener) {
                if (this.waitingMessagesBrokerSide && this.messageCount <= this.topicActivationThreshold) {
                    this.activateMessageInput();
                    return;
                }
                if (this.topicMsgInputPassivated) {
                    if (this.messageCount <= this.topicActivationThreshold) {
                        this.activateMessageInput();
                    }
                } else if (this.messageCount > this.topicPassivationThreshold) {
                    this.passivateMessageInput();
                }
            }
        }
        if (ackMode == 3 && this.messageCount == 0) {
            this.acknowledge(0);
        }
    }

    synchronized void start() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.start()");
        }
        if (this.status == 0) {
            if (this.queueMessageReadMax == 0) {
                this.subscribe(null, 1);
            } else {
                this.subscribe(null, this.queueMessageReadMax);
            }
        } else {
            throw new java.lang.IllegalStateException("Status error");
        }
        this.setStatus(1);
    }

    private void subscribe(String[] toAck, int msgCount) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.subscribe()");
        }
        ConsumerSetListRequest req = new ConsumerSetListRequest(this.targetName, this.selector, this.queueMode, toAck, msgCount);
        this.setReceiveStatus(1);
        this.rm.sendRequest((AbstractJmsRequest)req, this, null);
        this.requestId = req.getRequestId();
    }

    protected abstract boolean checkSessionThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.close()");
        }
        if (this.queueMode) {
            ConsumerUnsetListRequest unsetLR = new ConsumerUnsetListRequest(this.queueMode);
            unsetLR.setTarget(this.targetName);
            unsetLR.setCancelledRequestId(this.requestId);
            this.rm.sendRequest((AbstractJmsRequest)unsetLR);
        }
        MessageConsumerListener messageConsumerListener = this;
        synchronized (messageConsumerListener) {
            while (this.status == 2) {
                try {
                    if (!this.checkSessionThread()) {
                        this.wait();
                        continue;
                    }
                    this.setStatus(3);
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (this.status == 0 || this.status == 3) {
                return;
            }
            this.rm.abortRequest(this.requestId);
            this.acknowledge(0);
            this.setStatus(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(int threshold) {
        block7: {
            try {
                Vector<String> vector = this.messagesToAck;
                synchronized (vector) {
                    if (this.messagesToAck.size() > threshold) {
                        ConsumerAckRequest ack = new ConsumerAckRequest(this.targetName, this.queueMode);
                        for (int i = 0; i < this.messagesToAck.size(); ++i) {
                            String msgId = this.messagesToAck.elementAt(i);
                            ack.addId(msgId);
                        }
                        this.rm.sendRequest((AbstractJmsRequest)ack);
                        this.messagesToAck.clear();
                    }
                }
            }
            catch (JMSException exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block7;
                logger.log(BasicLevel.ERROR, "", (Throwable)exc);
            }
        }
    }

    @Override
    public synchronized boolean replyReceived(AbstractJmsReply reply) throws AbortedRequestException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.replyReceived(" + reply + ')');
        }
        if (this.status == 3) {
            throw new AbortedRequestException();
        }
        if (this.queueMode) {
            this.setReceiveStatus(2);
        }
        try {
            ConsumerMessages cm = (ConsumerMessages)reply;
            this.messageCount += cm.getMessageCount();
            this.waitingMessagesBrokerSide = !cm.hasPendingMessages();
            this.pushMessages(cm);
        }
        catch (StoppedQueueException exc) {
            throw new AbortedRequestException();
        }
        catch (JMSException exc) {
            throw new AbortedRequestException();
        }
        return this.queueMode;
    }

    public abstract void pushMessages(ConsumerMessages var1) throws JMSException;

    @Override
    public void replyAborted(int requestId) {
    }

    @Override
    public void errorReceived(int requestId, MomExceptionReply exc) {
    }

    public synchronized boolean isClosed() {
        return this.status == 3;
    }

    public final MessageListener getMessageListener() {
        return this.listeners.get(this.listenerPosition);
    }

    public final boolean getQueueMode() {
        return this.queueMode;
    }

    public final String getTargetName() {
        return this.targetName;
    }

    protected void activateListener(Message msg, MessageListener listener, int ackMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.onMessage(" + msg + ')');
        }
        if (this.queueMessageReadMax > 0) {
            this.decreaseMessageCount(ackMode);
        }
        try {
            listener.onMessage((javax.jms.Message)msg);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, " -> consumer.onMessage(" + msg + ") returned");
            }
        }
        catch (RuntimeException re) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, "", (Throwable)re);
            }
            JMSException exc = new JMSException(re.toString());
            exc.setLinkedException((Exception)re);
            throw exc;
        }
        if (this.queueMessageReadMax == 0) {
            this.decreaseMessageCount(ackMode);
        }
    }

    public abstract void onMessage(Message var1, MessageListener var2, int var3) throws JMSException;

    synchronized void addMessageListener(MessageListener messageListener) {
        this.listeners.add(messageListener);
    }

    synchronized boolean removeMessageListener(MessageListener messageListener) {
        return this.listeners.remove(messageListener);
    }

    public int getMessageListenersSize() {
        return this.listeners.size();
    }

    private synchronized MessageListener getNextlistener() {
        int size = this.listeners.size();
        if (size == 1) {
            return this.listeners.get(0);
        }
        if (size < 1) {
            return null;
        }
        ++this.listenerPosition;
        if (this.listenerPosition >= size) {
            this.listenerPosition = 0;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.getNextlistener() listenerPosition = " + this.listenerPosition);
        }
        return this.listeners.get(this.listenerPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg, int ackMode) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.onMessage(" + msg + ')');
        }
        MessageListener listener = this.getNextlistener();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "MessageConsumerListener.onMessage listener = " + listener);
        }
        if (listener != null) {
            MessageConsumerListener messageConsumerListener = this;
            synchronized (messageConsumerListener) {
                if (this.status != 1) {
                    this.notifyAll();
                    throw new IllegalStateException("Message listener closed");
                }
                this.setStatus(2);
            }
            try {
                this.activateListener(msg, listener, ackMode);
            }
            finally {
                messageConsumerListener = this;
                synchronized (messageConsumerListener) {
                    if (this.status == 2) {
                        this.setStatus(1);
                    }
                    this.notifyAll();
                }
            }
        }
        throw new JMSException("Null listener");
    }

    void ack(String msgId, int ackMode) throws JMSException {
        if (ackMode == 3) {
            this.messagesToAck.addElement(msgId);
            if (!this.queueMode) {
                this.acknowledge(this.topicAckBufferMax);
            }
        } else {
            ConsumerAckRequest ack = new ConsumerAckRequest(this.targetName, this.queueMode);
            ack.addId(msgId);
            this.rm.sendRequest((AbstractJmsRequest)ack);
        }
    }

    void activateMessageInput() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "activateMessageInput " + this.targetName + '/' + this.messageCount + " -> " + (this.messageCount < this.topicActivationThreshold));
        }
        this.rm.sendRequest((AbstractJmsRequest)new ActivateConsumerRequest(this.targetName, this.topicPassivationThreshold - this.messageCount));
        this.topicMsgInputPassivated = false;
    }

    void passivateMessageInput() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "passivateMessageInput " + this.targetName + '/' + this.messageCount + " -> " + (this.messageCount > this.topicPassivationThreshold));
        }
        this.rm.sendRequest((AbstractJmsRequest)new ActivateConsumerRequest(this.targetName, 0));
        this.topicMsgInputPassivated = true;
    }

    private static class ReceiveStatus {
        public static final int INIT = 0;
        public static final int WAIT_FOR_REPLY = 1;
        public static final int CONSUMING_REPLY = 2;
        private static final String[] names = new String[]{"INIT", "WAIT_FOR_REPLY", "CONSUMING_REPLY"};

        private ReceiveStatus() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }

    protected static class Status {
        public static final int INIT = 0;
        public static final int RUN = 1;
        public static final int ON_MSG = 2;
        public static final int CLOSE = 3;
        private static final String[] names = new String[]{"INIT", "RUN", "ON_MSG", "CLOSE"};

        protected Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

