/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import javax.jms.CompletionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Session;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class MessageProducer
implements javax.jms.MessageProducer {
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private long deliveryDelay = 0L;
    private boolean messageIDDisabled = false;
    private boolean timestampDisabled = false;
    private boolean identified = true;
    protected boolean closed = false;
    protected Session sess;
    protected Destination dest = null;
    private static Logger logger = Debug.getLogger((String)MessageProducer.class.getName());

    MessageProducer(Session sess, Destination dest) throws JMSException {
        this.sess = sess;
        this.dest = dest;
        if (dest == null) {
            this.identified = false;
        } else {
            dest.check();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this + ": created.");
        }
    }

    public synchronized void setDisableMessageID(boolean value) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        this.messageIDDisabled = value;
    }

    public synchronized void setDeliveryMode(int deliveryMode) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new JMSException("Can't set invalid delivery mode.");
        }
        this.deliveryMode = deliveryMode;
    }

    public synchronized void setPriority(int priority) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        if (priority < 0 || priority > 9) {
            throw new JMSException("Can't set invalid priority value.");
        }
        this.priority = priority;
    }

    public synchronized void setTimeToLive(long timeToLive) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        this.timeToLive = timeToLive;
    }

    public synchronized void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        this.timestampDisabled = value;
    }

    public synchronized javax.jms.Destination getDestination() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        return this.dest;
    }

    public synchronized boolean getDisableMessageID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        return this.messageIDDisabled;
    }

    public synchronized int getDeliveryMode() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        return this.deliveryMode;
    }

    public synchronized int getPriority() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        return this.priority;
    }

    public synchronized long getTimeToLive() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        return this.timeToLive;
    }

    public synchronized boolean getDisableMessageTimestamp() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        return this.timestampDisabled;
    }

    public synchronized void send(Message message) throws JMSException {
        if (!this.identified) {
            throw new UnsupportedOperationException("Can't send message to an unidentified destination.");
        }
        this.doSend(this.dest, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public synchronized void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (!this.identified) {
            throw new UnsupportedOperationException("Can't send message to an unidentified destination.");
        }
        this.doSend(this.dest, message, deliveryMode, priority, timeToLive);
    }

    public synchronized void send(javax.jms.Destination dest, Message message) throws JMSException {
        if (dest == null) {
            throw new InvalidDestinationException("Can't send message to an unidentified destination.");
        }
        if (this.identified) {
            throw new UnsupportedOperationException("An identified message producer can't use this method.");
        }
        this.doSend((Destination)dest, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public synchronized void send(javax.jms.Destination dest, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (dest == null) {
            throw new InvalidDestinationException("Can't send message to an unidentified destination.");
        }
        if (this.identified) {
            throw new UnsupportedOperationException("An identified message producer can't use this method.");
        }
        this.doSend((Destination)dest, message, deliveryMode, priority, timeToLive);
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        if (!this.identified) {
            throw new UnsupportedOperationException("Can't send message to an unidentified destination.");
        }
        if (completionListener == null) {
            throw new IllegalArgumentException("Completion listener is null");
        }
        this.doSend(this.dest, message, this.deliveryMode, this.priority, this.timeToLive, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (!this.identified) {
            throw new UnsupportedOperationException("Can't send message to an unidentified destination.");
        }
        if (completionListener == null) {
            throw new IllegalArgumentException("Completion listener is null");
        }
        this.doSend(this.dest, message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void send(javax.jms.Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Can't send message to an unidentified destination.");
        }
        if (this.identified) {
            throw new UnsupportedOperationException("An identified message producer can't use this method.");
        }
        if (completionListener == null) {
            throw new IllegalArgumentException("Completion listener is null");
        }
        this.doSend((Destination)destination, message, this.deliveryMode, this.priority, this.timeToLive, completionListener);
    }

    public void send(javax.jms.Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Can't send message to an unidentified destination.");
        }
        if (this.identified) {
            throw new UnsupportedOperationException("An identified message producer can't use this method.");
        }
        if (completionListener == null) {
            throw new IllegalArgumentException("Completion listener is null");
        }
        this.doSend((Destination)destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, "--- " + this + ": closing...");
        }
        this.sess.closeProducer(this);
        this.closed = true;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, this + ": closed.");
        }
    }

    private void doSend(Destination dest, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.doSend(dest, message, deliveryMode, priority, timeToLive, null);
    }

    private void doSend(Destination dest, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        this.sess.send(dest, message, deliveryMode, priority, timeToLive, this.timestampDisabled, this.deliveryDelay, completionListener, this);
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.deliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() throws JMSException {
        return this.deliveryDelay;
    }
}

