/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import java.net.ConnectException;
import java.util.List;
import java.util.Properties;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.QueueMBean;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.shared.admin.AddRemoteDestination;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearQueue;
import org.objectweb.joram.shared.admin.ClusterAdd;
import org.objectweb.joram.shared.admin.ClusterLeave;
import org.objectweb.joram.shared.admin.ClusterList;
import org.objectweb.joram.shared.admin.ClusterListReply;
import org.objectweb.joram.shared.admin.DelRemoteDestination;
import org.objectweb.joram.shared.admin.DeleteQueueMessage;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetDeliveredMessages;
import org.objectweb.joram.shared.admin.GetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.GetNumberReply;
import org.objectweb.joram.shared.admin.GetPendingMessages;
import org.objectweb.joram.shared.admin.GetPendingRequests;
import org.objectweb.joram.shared.admin.GetQueueMessage;
import org.objectweb.joram.shared.admin.GetQueueMessageIds;
import org.objectweb.joram.shared.admin.GetQueueMessageIdsRep;
import org.objectweb.joram.shared.admin.GetQueueMessageRep;
import org.objectweb.joram.shared.admin.SendDestinationsWeights;
import org.objectweb.joram.shared.admin.SetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.SetSyncExceptionOnFullDestRequest;
import org.objectweb.joram.shared.admin.SetThresholdRequest;

public class Queue
extends Destination
implements javax.jms.Queue,
QueueMBean {
    private static final long serialVersionUID = 1L;
    public static final String REDELIVERY_DELAY = "redeliveryDelay";
    public static final String DELIVERY_DELAY = "deliveryDelay";

    public Queue() {
        super((byte)2);
    }

    public Queue(String name) {
        super(name, (byte)2);
    }

    protected Queue(String name, byte type) {
        super(name, type);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Queue");
        if (this.adminName != null) {
            strbuf.append('[').append(this.adminName).append(']');
        }
        strbuf.append(':').append(this.agentId);
        return strbuf.toString();
    }

    public String getQueueName() throws JMSException {
        return this.getAdminName();
    }

    public static Queue createQueue(String agentId, String name) {
        Queue dest = new Queue();
        dest.agentId = agentId;
        dest.adminName = name;
        return dest;
    }

    public static Queue create() throws ConnectException, AdminException {
        return Queue.create(AdminModule.getLocalServerId());
    }

    public static Queue create(int serverId) throws ConnectException, AdminException {
        return Queue.create(serverId, null, null, null);
    }

    public static Queue create(String name) throws ConnectException, AdminException {
        return Queue.create(AdminModule.getLocalServerId(), name, null, null);
    }

    public static Queue create(int serverId, String name) throws ConnectException, AdminException {
        return Queue.create(serverId, name, null, null);
    }

    public static Queue create(int serverId, Properties prop) throws ConnectException, AdminException {
        return Queue.create(serverId, null, prop);
    }

    public static Queue create(int serverId, String className, Properties prop) throws ConnectException, AdminException {
        return Queue.create(serverId, null, className, prop);
    }

    public static Queue create(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        Queue queue = new Queue();
        if (className == null) {
            className = "org.objectweb.joram.mom.dest.Queue";
        }
        queue.doCreate(serverId, name, className, prop, queue, (byte)2);
        return queue;
    }

    @Override
    public void setThreshold(int threshold) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetThresholdRequest(this.agentId, threshold));
    }

    @Override
    public int getThreshold() throws ConnectException, AdminException {
        GetDMQSettingsRequest request = new GetDMQSettingsRequest(this.agentId);
        GetDMQSettingsReply reply = (GetDMQSettingsReply)this.doRequest((AdminRequest)request);
        return reply.getThreshold();
    }

    @Override
    public void setNbMaxMsg(int nbMaxMsg) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetNbMaxMsgRequest(this.agentId, nbMaxMsg));
    }

    @Override
    public int getNbMaxMsg() throws ConnectException, AdminException {
        GetNbMaxMsgRequest request = new GetNbMaxMsgRequest(this.agentId);
        GetNumberReply reply = (GetNumberReply)this.doRequest((AdminRequest)request);
        return reply.getNumber();
    }

    public void setSyncExceptionOnFull(boolean syncExceptionOnFull) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetSyncExceptionOnFullDestRequest(this.agentId, syncExceptionOnFull));
    }

    @Override
    public int getPendingMessages() throws ConnectException, AdminException {
        GetPendingMessages request = new GetPendingMessages(this.agentId);
        GetNumberReply reply = (GetNumberReply)this.doRequest((AdminRequest)request);
        return reply.getNumber();
    }

    @Override
    public int getPendingRequests() throws ConnectException, AdminException {
        GetPendingRequests request = new GetPendingRequests(this.agentId);
        GetNumberReply reply = (GetNumberReply)this.doRequest((AdminRequest)request);
        return reply.getNumber();
    }

    public int getDeliveredMessages() throws ConnectException, AdminException {
        GetDeliveredMessages request = new GetDeliveredMessages(this.agentId);
        GetNumberReply reply = (GetNumberReply)this.doRequest((AdminRequest)request);
        return reply.getNumber();
    }

    @Override
    public String[] getMessageIds() throws AdminException, ConnectException {
        GetQueueMessageIdsRep reply = (GetQueueMessageIdsRep)this.doRequest((AdminRequest)new GetQueueMessageIds(this.agentId));
        return reply.getMessageIds();
    }

    public javax.jms.Message getMessage(String msgId) throws AdminException, ConnectException, JMSException {
        GetQueueMessageRep reply = (GetQueueMessageRep)this.doRequest((AdminRequest)new GetQueueMessage(this.agentId, msgId, true));
        return Message.wrapMomMessage(null, reply.getMessage());
    }

    public javax.jms.Message readMessage(String msgId) throws AdminException, ConnectException, JMSException {
        return this.getMessage(msgId);
    }

    @Override
    public String getMessageDigest(String msgId) throws AdminException, ConnectException, JMSException {
        GetQueueMessageRep reply = (GetQueueMessageRep)this.doRequest((AdminRequest)new GetQueueMessage(this.agentId, msgId, false));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Message: ").append(msg.getJMSMessageID());
        strbuf.append("\n\tTo: ").append(msg.getJMSDestination());
        strbuf.append("\n\tCorrelationId: ").append(msg.getJMSCorrelationID());
        strbuf.append("\n\tDeliveryMode: ").append(msg.getJMSDeliveryMode());
        strbuf.append("\n\tExpiration: ").append(msg.getJMSExpiration());
        strbuf.append("\n\tPriority: ").append(msg.getJMSPriority());
        strbuf.append("\n\tRedelivered: ").append(msg.getJMSRedelivered());
        strbuf.append("\n\tReplyTo: ").append(msg.getJMSReplyTo());
        strbuf.append("\n\tTimestamp: ").append(msg.getJMSTimestamp());
        strbuf.append("\n\tType: ").append(msg.getJMSType());
        return strbuf.toString();
    }

    @Override
    public Properties getMessageHeader(String msgId) throws AdminException, ConnectException, JMSException {
        GetQueueMessageRep reply = (GetQueueMessageRep)this.doRequest((AdminRequest)new GetQueueMessage(this.agentId, msgId, false));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        Properties prop = new Properties();
        prop.setProperty("JMSMessageID", msg.getJMSMessageID());
        prop.setProperty("JMSDestination", msg.getJMSDestination().toString());
        if (msg.getJMSCorrelationID() != null) {
            prop.setProperty("JMSCorrelationID", msg.getJMSCorrelationID());
        }
        prop.setProperty("JMSDeliveryMode", Integer.valueOf(msg.getJMSDeliveryMode()).toString());
        prop.setProperty("JMSExpiration", Long.valueOf(msg.getJMSExpiration()).toString());
        prop.setProperty("JMSPriority", Integer.valueOf(msg.getJMSPriority()).toString());
        prop.setProperty("JMSRedelivered", Boolean.valueOf(msg.getJMSRedelivered()).toString());
        if (msg.getJMSReplyTo() != null) {
            prop.setProperty("JMSReplyTo", msg.getJMSReplyTo().toString());
        }
        prop.setProperty("JMSTimestamp", Long.valueOf(msg.getJMSTimestamp()).toString());
        if (msg.getJMSType() != null) {
            prop.setProperty("JMSType", msg.getJMSType());
        }
        return prop;
    }

    @Override
    public Properties getMessageProperties(String msgId) throws AdminException, ConnectException, JMSException {
        GetQueueMessageRep reply = (GetQueueMessageRep)this.doRequest((AdminRequest)new GetQueueMessage(this.agentId, msgId, false));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        Properties prop = new Properties();
        msg.getProperties(prop);
        return prop;
    }

    @Override
    public void deleteMessage(String msgId) throws AdminException, ConnectException {
        this.doRequest((AdminRequest)new DeleteQueueMessage(this.agentId, msgId));
    }

    @Override
    public void clear() throws AdminException, ConnectException {
        this.doRequest((AdminRequest)new ClearQueue(this.agentId));
    }

    public void addClusteredQueue(Queue addedQueue) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new ClusterAdd(this.agentId, addedQueue.getName()));
    }

    public void removeClusteredQueue(Queue removedQueue) throws ConnectException, AdminException {
        removedQueue.removeFromCluster();
    }

    public void removeFromCluster() throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new ClusterLeave(this.agentId));
    }

    public String[] getQueueClusterElements() throws ConnectException, AdminException {
        ClusterListReply reply = (ClusterListReply)this.doRequest((AdminRequest)new ClusterList(this.agentId));
        List list = reply.getDestinations();
        return list == null ? null : list.toArray(new String[list.size()]);
    }

    @Override
    public void registerAsDefaultDMQ() throws ConnectException, AdminException {
        this.getWrapper().setDefaultDMQId(this.getName());
    }

    @Override
    public void registerAsDefaultDMQ(int serverId) throws ConnectException, AdminException {
        this.getWrapper().setDefaultDMQId(serverId, this.getName());
    }

    public void addRemoteDestination(String destId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new AddRemoteDestination(this.agentId, destId));
    }

    public void addRemoteDestination(Queue remote) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new AddRemoteDestination(this.agentId, remote.getName()));
    }

    public void delRemoteDestination(String destId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new DelRemoteDestination(this.agentId, destId));
    }

    public void delRemoteDestination(Queue remote) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new DelRemoteDestination(this.agentId, remote.getName()));
    }

    public void sendDestinationsWeights(int[] weights) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SendDestinationsWeights(this.agentId, weights));
    }

    public void setRedeliveryDelay(int redeliveryDelay) throws ConnectException, AdminException {
        Properties properties = new Properties();
        properties.setProperty(REDELIVERY_DELAY, "" + redeliveryDelay);
        this.setProperties(properties);
    }

    public void setDeliveryDelay(int deliveryDelay) throws ConnectException, AdminException {
        Properties properties = new Properties();
        properties.setProperty(DELIVERY_DELAY, "" + deliveryDelay);
        this.setProperties(properties);
    }

    public void setPause(boolean pause) throws ConnectException, AdminException {
        Properties properties = new Properties();
        properties.setProperty("jms_joram_pause", "" + pause);
        this.getWrapper().processAdmin(this.getName(), 11, properties);
    }

    @Override
    public AdminReply setProperties(Properties prop) throws ConnectException, AdminException {
        return this.getWrapper().processAdmin(this.getName(), 5, prop);
    }
}

